/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.jcajce.provider;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1OctetString;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Primitive;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Sequence;
import com.aspose.html.internal.ms.core.bc.asn1.misc.IDEACBCPar;
import com.aspose.html.internal.ms.core.bc.asn1.misc.MiscObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.crypto.AuthenticationParametersWithIV;
import com.aspose.html.internal.ms.core.bc.crypto.MACOperatorFactory;
import com.aspose.html.internal.ms.core.bc.crypto.Parameters;
import com.aspose.html.internal.ms.core.bc.crypto.ParametersWithIV;
import com.aspose.html.internal.ms.core.bc.crypto.SymmetricKeyGenerator;
import com.aspose.html.internal.ms.core.bc.crypto.general.IDEA;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.AlgorithmProvider;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.AuthParametersCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BaseAlgorithmParameters;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BaseCipher;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BaseKeyGenerator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BaseMac;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BaseSecretKeyFactory;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BouncyCastleFipsProvider;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.EngineCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.GuardedEngineCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.IVAlgorithmParameterGenerator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.IvParametersCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.KeyGeneratorCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ParametersCreator;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ParametersCreatorProvider;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.Utils;
import com.aspose.html.internal.ms.core.bc.util.Arrays;
import java.io.IOException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;

class ProvIDEA
extends AlgorithmProvider {
    private static final String PREFIX = ProvIDEA.class.getName();
    private Class[] availableSpecs = new Class[]{IvParameterSpec.class};
    private ParametersCreatorProvider<Parameters> generalParametersCreatorProvider = new ParametersCreatorProvider<Parameters>(){

        @Override
        public ParametersCreator get(Parameters parameters) {
            if (Utils.isAuthMode(parameters.getAlgorithm())) {
                return new AuthParametersCreator((AuthenticationParametersWithIV)parameters);
            }
            return new IvParametersCreator((ParametersWithIV)parameters);
        }
    };

    ProvIDEA() {
    }

    public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameterGenerator", MiscObjectIdentifiers.as_sys_sec_alg_ideaCBC, PREFIX + "$AlgParamGen", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new IVAlgorithmParameterGenerator(bouncyCastleFipsProvider, "IDEA", 8);
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameters.IDEA", PREFIX + "$AlgParams", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new AlgParams();
            }
        }));
        bouncyCastleFipsProvider.addAlias("AlgorithmParameters", "IDEA", MiscObjectIdentifiers.as_sys_sec_alg_ideaCBC);
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.IDEA", PREFIX + "$ECB", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 64, IDEA.ECBwithPKCS7, IDEA.ECB, IDEA.ECBwithISO10126_2, IDEA.ECBwithISO7816_4, IDEA.ECBwithTBC, IDEA.ECBwithX923, IDEA.CBC, IDEA.CBCwithPKCS7, IDEA.CBCwithISO10126_2, IDEA.CBCwithISO7816_4, IDEA.CBCwithTBC, IDEA.CBCwithX923, IDEA.CBCwithCS1, IDEA.CBCwithCS2, IDEA.CBCwithCS3, IDEA.CFB64, IDEA.CFB8, IDEA.OFB, IDEA.CTR, IDEA.EAX, IDEA.OpenPGPCFB).withGeneralOperators(ProvIDEA.this.generalParametersCreatorProvider, new IDEA.OperatorFactory(), new IDEA.AEADOperatorFactory()).withParameters(ProvIDEA.this.availableSpecs).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher", MiscObjectIdentifiers.as_sys_sec_alg_ideaCBC, PREFIX + "$CBC", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 64, IDEA.CBCwithPKCS7).withGeneralOperators(ProvIDEA.this.generalParametersCreatorProvider, new IDEA.OperatorFactory(), null).withParameters(ProvIDEA.this.availableSpecs).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyGenerator.IDEA", PREFIX + "$KeyGen", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseKeyGenerator(bouncyCastleFipsProvider, "IDEA", 128, false, new KeyGeneratorCreator(){

                    public SymmetricKeyGenerator createInstance(int n2, SecureRandom secureRandom) {
                        return new IDEA.KeyGenerator(n2, secureRandom);
                    }
                });
            }
        }));
        bouncyCastleFipsProvider.addAlias("KeyGenerator", "IDEA", MiscObjectIdentifiers.as_sys_sec_alg_ideaCBC);
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.IDEAMAC", PREFIX + "$Mac", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseMac(IDEA.CBC_MAC, (MACOperatorFactory)new IDEA.MACOperatorFactory(), new AuthParametersCreator(IDEA.CBC_MAC));
            }
        }));
        bouncyCastleFipsProvider.addAlias("Alg.Alias.Mac.IDEA", "IDEAMAC");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.IDEAMAC/CFB8", PREFIX + "$CFB8MAC", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseMac(IDEA.CFB8_MAC, (MACOperatorFactory)new IDEA.MACOperatorFactory(), new AuthParametersCreator(IDEA.CFB8_MAC));
            }
        }));
        bouncyCastleFipsProvider.addAlias("Alg.Alias.Mac.IDEA/CFB8", "IDEAMAC/CFB8");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.IDEACMAC", PREFIX + "$CMAC", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseMac(IDEA.CMAC, (MACOperatorFactory)new IDEA.MACOperatorFactory(), new AuthParametersCreator(IDEA.CMAC));
            }
        }));
        bouncyCastleFipsProvider.addAlias("Mac", "IDEACMAC", "IDEA-CMAC");
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.IDEA", PREFIX + "$IDEAKFACT", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseSecretKeyFactory("IDEA", IDEA.ALGORITHM, new BaseSecretKeyFactory.Validator(){

                    public byte[] validated(byte[] byArray) throws InvalidKeySpecException {
                        int n2 = byArray.length * 8;
                        if (n2 < 40 || n2 > 128) {
                            throw new InvalidKeySpecException("IDEA key must be of length 40 to 128 bits");
                        }
                        return byArray;
                    }
                });
            }
        }));
    }

    private static class AlgParams
    extends BaseAlgorithmParameters {
        private byte[] iv;

        private AlgParams() {
        }

        protected byte[] localGetEncoded() throws IOException {
            return new IDEACBCPar(Arrays.clone(this.iv)).getEncoded();
        }

        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == IvParameterSpec.class || clazz == AlgorithmParameterSpec.class) {
                return new IvParameterSpec(this.iv);
            }
            throw new InvalidParameterSpecException("AlgorithmParameterSpec not recognized: " + clazz.getName());
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (!(algorithmParameterSpec instanceof IvParameterSpec)) {
                throw new InvalidParameterSpecException("IvParameterSpec required to initialise a IV parameters algorithm parameters object");
            }
            this.iv = ((IvParameterSpec)algorithmParameterSpec).getIV();
        }

        protected void localInit(byte[] byArray) throws IOException {
            ASN1Primitive aSN1Primitive = ASN1Primitive.fromByteArray(byArray);
            if (aSN1Primitive instanceof ASN1Sequence) {
                IDEACBCPar iDEACBCPar = IDEACBCPar.getInstance(aSN1Primitive);
                this.iv = Arrays.clone(iDEACBCPar.getIV());
            } else if (aSN1Primitive instanceof ASN1OctetString) {
                this.iv = Arrays.clone(ASN1OctetString.getInstance(aSN1Primitive).getOctets());
            } else {
                throw new IOException("Unable to recognize parameters");
            }
        }

        protected String engineToString() {
            return "IDEA Parameters";
        }
    }
}

