/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.jcajce.provider;

import com.aspose.html.internal.ms.core.bc.crypto.UpdateOutputStream;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsOutputDigestCalculator;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsSHS;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.AlgorithmProvider;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.BouncyCastleFipsProvider;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.EngineCreator;
import com.aspose.html.internal.ms.core.bc.util.Arrays;
import com.aspose.html.internal.ms.core.bc.util.Strings;
import com.aspose.html.internal.ms.core.bc.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;

class ProvJKS
extends AlgorithmProvider {
    private static final String PREFIX = "com.aspose.html.internal.ms.core.bc.jcajce.provider.keystore.jks.";

    ProvJKS() {
    }

    void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyStore.JKS", "com.aspose.html.internal.ms.core.bc.jcajce.provider.keystore.jks.JKS", new EngineCreator(){

            public Object createInstance(Object object) {
                return new JKSKeyStoreSpi(bouncyCastleFipsProvider);
            }
        });
    }

    private static final class BCJKSTrustedCertEntry {
        final Date date;
        final Certificate cert;

        public BCJKSTrustedCertEntry(Date date, Certificate certificate) {
            this.date = date;
            this.cert = certificate;
        }
    }

    private static final class ErasableByteStream
    extends ByteArrayInputStream {
        public ErasableByteStream(byte[] byArray, int n2, int n3) {
            super(byArray, n2, n3);
        }

        public void erase() {
            Arrays.fill(this.buf, (byte)0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JKSKeyStoreSpi
    extends KeyStoreSpi {
        private final Hashtable<String, BCJKSTrustedCertEntry> certificateEntries = new Hashtable();
        private static final String NOT_IMPLEMENTED_MESSAGE = "BCFIPS JKS store is read-only and only supports certificate entries";
        private final BouncyCastleFipsProvider fipsProvider;

        public JKSKeyStoreSpi(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            this.fipsProvider = bouncyCastleFipsProvider;
        }

        @Override
        public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
            return null;
        }

        @Override
        public Certificate[] engineGetCertificateChain(String string) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Certificate engineGetCertificate(String string) {
            Hashtable<String, BCJKSTrustedCertEntry> hashtable = this.certificateEntries;
            synchronized (hashtable) {
                BCJKSTrustedCertEntry bCJKSTrustedCertEntry = this.certificateEntries.get(string);
                if (bCJKSTrustedCertEntry != null) {
                    return bCJKSTrustedCertEntry.cert;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Date engineGetCreationDate(String string) {
            Hashtable<String, BCJKSTrustedCertEntry> hashtable = this.certificateEntries;
            synchronized (hashtable) {
                BCJKSTrustedCertEntry bCJKSTrustedCertEntry = this.certificateEntries.get(string);
                if (bCJKSTrustedCertEntry != null) {
                    return bCJKSTrustedCertEntry.date;
                }
            }
            return null;
        }

        @Override
        public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
            throw new KeyStoreException(NOT_IMPLEMENTED_MESSAGE);
        }

        @Override
        public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
            throw new KeyStoreException(NOT_IMPLEMENTED_MESSAGE);
        }

        @Override
        public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
            throw new KeyStoreException(NOT_IMPLEMENTED_MESSAGE);
        }

        @Override
        public void engineDeleteEntry(String string) throws KeyStoreException {
            throw new KeyStoreException(NOT_IMPLEMENTED_MESSAGE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Enumeration<String> engineAliases() {
            Hashtable<String, BCJKSTrustedCertEntry> hashtable = this.certificateEntries;
            synchronized (hashtable) {
                return this.certificateEntries.keys();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean engineContainsAlias(String string) {
            if (string == null) {
                throw new NullPointerException("alias value is null");
            }
            Hashtable<String, BCJKSTrustedCertEntry> hashtable = this.certificateEntries;
            synchronized (hashtable) {
                return this.certificateEntries.containsKey(string);
            }
        }

        @Override
        public int engineSize() {
            return this.certificateEntries.size();
        }

        @Override
        public boolean engineIsKeyEntry(String string) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean engineIsCertificateEntry(String string) {
            Hashtable<String, BCJKSTrustedCertEntry> hashtable = this.certificateEntries;
            synchronized (hashtable) {
                return this.certificateEntries.containsKey(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String engineGetCertificateAlias(Certificate certificate) {
            Hashtable<String, BCJKSTrustedCertEntry> hashtable = this.certificateEntries;
            synchronized (hashtable) {
                for (Map.Entry<String, BCJKSTrustedCertEntry> entry : this.certificateEntries.entrySet()) {
                    if (!entry.getValue().cert.equals(certificate)) continue;
                    return entry.getKey();
                }
                return null;
            }
        }

        @Override
        public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
            throw new IOException(NOT_IMPLEMENTED_MESSAGE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
            if (inputStream == null) {
                return;
            }
            ErasableByteStream erasableByteStream = this.validateStream(inputStream, cArray);
            Hashtable<String, BCJKSTrustedCertEntry> hashtable = this.certificateEntries;
            synchronized (hashtable) {
                try {
                    block25: {
                        DataInputStream dataInputStream = new DataInputStream(erasableByteStream);
                        int n2 = dataInputStream.readInt();
                        int n3 = dataInputStream.readInt();
                        if (n2 != -17957139) break block25;
                        CertificateFactory certificateFactory = null;
                        Hashtable<String, CertificateFactory> hashtable2 = null;
                        switch (n3) {
                            case 1: {
                                certificateFactory = CertificateFactory.getInstance("X.509", this.fipsProvider);
                                break;
                            }
                            case 2: {
                                hashtable2 = new Hashtable<String, CertificateFactory>();
                                break;
                            }
                            default: {
                                throw new IllegalStateException("unable to discern store version");
                            }
                        }
                        int n4 = dataInputStream.readInt();
                        block17: for (int i2 = 0; i2 < n4; ++i2) {
                            int n5 = dataInputStream.readInt();
                            switch (n5) {
                                case 1: {
                                    throw new IOException(NOT_IMPLEMENTED_MESSAGE);
                                }
                                case 2: {
                                    Certificate certificate;
                                    String string = dataInputStream.readUTF();
                                    Date date = new Date(dataInputStream.readLong());
                                    if (n3 == 2) {
                                        String string2 = dataInputStream.readUTF();
                                        if (hashtable2.containsKey(string2)) {
                                            certificateFactory = (CertificateFactory)hashtable2.get(string2);
                                        } else {
                                            certificateFactory = CertificateFactory.getInstance(string2, this.fipsProvider);
                                            hashtable2.put(string2, certificateFactory);
                                        }
                                    }
                                    int n6 = dataInputStream.readInt();
                                    byte[] byArray = new byte[n6];
                                    dataInputStream.readFully(byArray);
                                    ErasableByteStream erasableByteStream2 = new ErasableByteStream(byArray, 0, byArray.length);
                                    try {
                                        certificate = certificateFactory.generateCertificate(erasableByteStream2);
                                        if (erasableByteStream2.available() != 0) {
                                            throw new IOException("password incorrect or store tampered with");
                                        }
                                    }
                                    finally {
                                        erasableByteStream2.erase();
                                    }
                                    this.certificateEntries.put(string, new BCJKSTrustedCertEntry(date, certificate));
                                    continue block17;
                                }
                                default: {
                                    throw new IllegalStateException("unable to discern entry type");
                                }
                            }
                        }
                    }
                    if (erasableByteStream.available() != 0) {
                        throw new IOException("password incorrect or store tampered with");
                    }
                }
                finally {
                    erasableByteStream.erase();
                }
            }
        }

        private void addPassword(OutputStream outputStream, char[] cArray) throws IOException {
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                outputStream.write((byte)(cArray[i2] >> 8));
                outputStream.write((byte)cArray[i2]);
            }
            outputStream.write(Strings.toByteArray("Mighty Aphrodite"));
        }

        private ErasableByteStream validateStream(InputStream inputStream, char[] cArray) throws IOException {
            FipsOutputDigestCalculator<FipsSHS.Parameters> fipsOutputDigestCalculator = new FipsSHS.OperatorFactory<FipsSHS.Parameters>().createOutputDigestCalculator(FipsSHS.SHA1);
            byte[] byArray = Streams.readAll(inputStream);
            if (cArray != null) {
                UpdateOutputStream updateOutputStream = fipsOutputDigestCalculator.getDigestStream();
                this.addPassword(updateOutputStream, cArray);
                updateOutputStream.write(byArray, 0, byArray.length - fipsOutputDigestCalculator.getDigestSize());
                byte[] byArray2 = fipsOutputDigestCalculator.getDigest();
                byte[] byArray3 = new byte[byArray2.length];
                System.arraycopy(byArray, byArray.length - byArray2.length, byArray3, 0, byArray2.length);
                if (!Arrays.constantTimeAreEqual(byArray2, byArray3)) {
                    Arrays.fill(byArray, (byte)0);
                    throw new IOException("password incorrect or store tampered with");
                }
                return new ErasableByteStream(byArray, 0, byArray.length - byArray2.length);
            }
            return new ErasableByteStream(byArray, 0, byArray.length - fipsOutputDigestCalculator.getDigestSize());
        }
    }
}

