/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.math.ec.custom.sec;

import com.aspose.html.internal.ms.core.bc.math.ec.ECConstants;
import com.aspose.html.internal.ms.core.bc.math.ec.ECCurve;
import com.aspose.html.internal.ms.core.bc.math.ec.ECFieldElement;
import com.aspose.html.internal.ms.core.bc.math.ec.ECPoint;
import com.aspose.html.internal.ms.core.bc.math.ec.custom.sec.SecP160K1Point;
import com.aspose.html.internal.ms.core.bc.math.ec.custom.sec.SecP160R2Curve;
import com.aspose.html.internal.ms.core.bc.math.ec.custom.sec.SecP160R2FieldElement;
import com.aspose.html.internal.ms.core.bc.util.encoders.Hex;
import java.math.BigInteger;

public class SecP160K1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = SecP160R2Curve.q;
    private static final int SECP160K1_DEFAULT_COORDS = 2;
    protected SecP160K1Point infinity = new SecP160K1Point(this, null, null);

    public SecP160K1Curve() {
        super(q);
        this.a = this.fromBigInteger(ECConstants.ZERO);
        this.b = this.fromBigInteger(BigInteger.valueOf(7L));
        this.order = new BigInteger(1, Hex.decode("0100000000000000000001B8FA16DFAB9ACA16B6B3"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    protected ECCurve cloneCurve() {
        return new SecP160K1Curve();
    }

    public boolean supportsCoordinateSystem(int n2) {
        switch (n2) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    public int getFieldSize() {
        return q.bitLength();
    }

    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecP160R2FieldElement(bigInteger);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecP160K1Point(this, eCFieldElement, eCFieldElement2);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecP160K1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }
}

