/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.openssl.jcajce;

import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PrivateKeyInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.html.internal.ms.core.bc.cert.jcajce.JcaX509CRLHolder;
import com.aspose.html.internal.ms.core.bc.cert.jcajce.JcaX509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.openssl.MiscPEMGenerator;
import com.aspose.html.internal.ms.core.bc.openssl.PEMEncryptor;
import java.io.IOException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;

public class JcaMiscPEMGenerator
extends MiscPEMGenerator {
    private Object obj;
    private String algorithm;
    private char[] password;
    private SecureRandom random;
    private Provider provider;

    public JcaMiscPEMGenerator(Object o2) throws IOException {
        super(JcaMiscPEMGenerator.convertObject(o2));
    }

    public JcaMiscPEMGenerator(Object o2, PEMEncryptor encryptor) throws IOException {
        super(JcaMiscPEMGenerator.convertObject(o2), encryptor);
    }

    private static Object convertObject(Object o2) throws IOException {
        if (o2 instanceof X509Certificate) {
            try {
                return new JcaX509CertificateHolder((X509Certificate)o2);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IllegalArgumentException("Cannot encode object: " + certificateEncodingException.toString());
            }
        }
        if (o2 instanceof X509CRL) {
            try {
                return new JcaX509CRLHolder((X509CRL)o2);
            }
            catch (CRLException cRLException) {
                throw new IllegalArgumentException("Cannot encode object: " + cRLException.toString());
            }
        }
        if (o2 instanceof KeyPair) {
            return JcaMiscPEMGenerator.convertObject(((KeyPair)o2).getPrivate());
        }
        if (o2 instanceof PrivateKey) {
            return PrivateKeyInfo.getInstance(((Key)o2).getEncoded());
        }
        if (o2 instanceof PublicKey) {
            return SubjectPublicKeyInfo.getInstance(((PublicKey)o2).getEncoded());
        }
        return o2;
    }
}

