/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.pkcs;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1Encodable;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1EncodableVector;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.DERBitString;
import com.aspose.html.internal.ms.core.bc.asn1.DERSet;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.Attribute;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.CertificationRequest;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.CertificationRequestInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x500.X500Name;
import com.aspose.html.internal.ms.core.bc.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.html.internal.ms.core.bc.operator.ContentSigner;
import com.aspose.html.internal.ms.core.bc.pkcs.PKCS10CertificationRequest;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PKCS10CertificationRequestBuilder {
    private SubjectPublicKeyInfo publicKeyInfo;
    private X500Name subject;
    private List attributes = new ArrayList();
    private boolean leaveOffEmpty = false;

    public PKCS10CertificationRequestBuilder(PKCS10CertificationRequestBuilder original) {
        this.publicKeyInfo = original.publicKeyInfo;
        this.subject = original.subject;
        this.leaveOffEmpty = original.leaveOffEmpty;
        this.attributes = new ArrayList(original.attributes);
    }

    public PKCS10CertificationRequestBuilder(X500Name subject, SubjectPublicKeyInfo publicKeyInfo) {
        this.subject = subject;
        this.publicKeyInfo = publicKeyInfo;
    }

    public PKCS10CertificationRequestBuilder setAttribute(ASN1ObjectIdentifier attrType, ASN1Encodable attrValue) {
        Iterator iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            if (!((Attribute)iterator.next()).getAttrType().equals(attrType)) continue;
            throw new IllegalStateException("Attribute " + attrType.toString() + " is already set");
        }
        this.addAttribute(attrType, attrValue);
        return this;
    }

    public PKCS10CertificationRequestBuilder setAttribute(ASN1ObjectIdentifier attrType, ASN1Encodable[] attrValue) {
        Iterator iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            if (!((Attribute)iterator.next()).getAttrType().equals(attrType)) continue;
            throw new IllegalStateException("Attribute " + attrType.toString() + " is already set");
        }
        this.addAttribute(attrType, attrValue);
        return this;
    }

    public PKCS10CertificationRequestBuilder addAttribute(ASN1ObjectIdentifier attrType, ASN1Encodable attrValue) {
        this.attributes.add(new Attribute(attrType, new DERSet(attrValue)));
        return this;
    }

    public PKCS10CertificationRequestBuilder addAttribute(ASN1ObjectIdentifier attrType, ASN1Encodable[] attrValues) {
        this.attributes.add(new Attribute(attrType, new DERSet(attrValues)));
        return this;
    }

    public PKCS10CertificationRequestBuilder setLeaveOffEmptyAttributes(boolean leaveOffEmpty) {
        this.leaveOffEmpty = leaveOffEmpty;
        return this;
    }

    public PKCS10CertificationRequest build(ContentSigner signer) {
        Object object;
        CertificationRequestInfo certificationRequestInfo;
        if (this.attributes.isEmpty()) {
            certificationRequestInfo = this.leaveOffEmpty ? new CertificationRequestInfo(this.subject, this.publicKeyInfo, null) : new CertificationRequestInfo(this.subject, this.publicKeyInfo, new DERSet());
        } else {
            object = new ASN1EncodableVector();
            Iterator iterator = this.attributes.iterator();
            while (iterator.hasNext()) {
                ((ASN1EncodableVector)object).add(Attribute.getInstance(iterator.next()));
            }
            certificationRequestInfo = new CertificationRequestInfo(this.subject, this.publicKeyInfo, new DERSet((ASN1EncodableVector)object));
        }
        try {
            object = signer.getOutputStream();
            ((OutputStream)object).write(certificationRequestInfo.getEncoded("DER"));
            ((OutputStream)object).close();
            return new PKCS10CertificationRequest(new CertificationRequest(certificationRequestInfo, signer.getAlgorithmIdentifier(), new DERBitString(signer.getSignature())));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("cannot produce certification request signature");
        }
    }
}

