/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.pkcs;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1OctetString;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Primitive;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Sequence;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.ContentInfo;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.MacData;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PKCS12PBEParams;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.Pfx;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.pkcs.MacDataGenerator;
import com.aspose.html.internal.ms.core.bc.pkcs.PKCS12MacCalculatorBuilderProvider;
import com.aspose.html.internal.ms.core.bc.pkcs.PKCSException;
import com.aspose.html.internal.ms.core.bc.pkcs.PKCSIOException;
import com.aspose.html.internal.ms.core.bc.util.Arrays;
import java.io.IOException;

public class PKCS12PfxPdu {
    private Pfx pfx;

    private static Pfx parseBytes(byte[] pfxEncoding) throws IOException {
        try {
            return Pfx.getInstance(ASN1Primitive.fromByteArray(pfxEncoding));
        }
        catch (ClassCastException classCastException) {
            throw new PKCSIOException("malformed data: " + classCastException.getMessage(), classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new PKCSIOException("malformed data: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    public PKCS12PfxPdu(Pfx pfx) {
        this.pfx = pfx;
    }

    public PKCS12PfxPdu(byte[] pfx) throws IOException {
        this(PKCS12PfxPdu.parseBytes(pfx));
    }

    public ContentInfo[] getContentInfos() {
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(ASN1OctetString.getInstance(this.pfx.getAuthSafe().getContent()).getOctets());
        ContentInfo[] contentInfoArray = new ContentInfo[aSN1Sequence.size()];
        for (int i2 = 0; i2 != aSN1Sequence.size(); ++i2) {
            contentInfoArray[i2] = ContentInfo.getInstance(aSN1Sequence.getObjectAt(i2));
        }
        return contentInfoArray;
    }

    public boolean hasMac() {
        return this.pfx.getMacData() != null;
    }

    public AlgorithmIdentifier getMacAlgorithmID() {
        MacData macData = this.pfx.getMacData();
        if (macData != null) {
            return macData.getMac().getAlgorithmId();
        }
        return null;
    }

    public boolean isMacValid(PKCS12MacCalculatorBuilderProvider macCalcProviderBuilder, char[] password) throws PKCSException {
        if (this.hasMac()) {
            MacData macData = this.pfx.getMacData();
            MacDataGenerator macDataGenerator = new MacDataGenerator(macCalcProviderBuilder.get(new AlgorithmIdentifier(macData.getMac().getAlgorithmId().getAlgorithm(), new PKCS12PBEParams(macData.getSalt(), macData.getIterationCount().intValue()))));
            try {
                MacData macData2 = macDataGenerator.build(password, ASN1OctetString.getInstance(this.pfx.getAuthSafe().getContent()).getOctets());
                return Arrays.constantTimeAreEqual(macData2.getEncoded(), this.pfx.getMacData().getEncoded());
            }
            catch (IOException iOException) {
                throw new PKCSException("unable to process AuthSafe: " + iOException.getMessage());
            }
        }
        throw new IllegalStateException("no MAC present on PFX");
    }

    public Pfx toASN1Structure() {
        return this.pfx;
    }

    public byte[] getEncoded() throws IOException {
        return this.toASN1Structure().getEncoded();
    }

    public byte[] getEncoded(String encoding) throws IOException {
        return this.toASN1Structure().getEncoded(encoding);
    }
}

