/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.pkcs.jcajce;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Primitive;
import com.aspose.html.internal.ms.core.bc.asn1.bc.BCObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.EncryptionScheme;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.KeyDerivationFunc;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PBES2Parameters;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PBKDF2Params;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PKCS12PBEParams;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.crypto.PasswordConverter;
import com.aspose.html.internal.ms.core.bc.crypto.general.KDF;
import com.aspose.html.internal.ms.core.bc.jcajce.PKCS12KeyWithParameters;
import com.aspose.html.internal.ms.core.bc.jcajce.util.DefaultJcaJceHelper;
import com.aspose.html.internal.ms.core.bc.jcajce.util.JcaJceHelper;
import com.aspose.html.internal.ms.core.bc.jcajce.util.NamedJcaJceHelper;
import com.aspose.html.internal.ms.core.bc.jcajce.util.ProviderJcaJceHelper;
import com.aspose.html.internal.ms.core.bc.operator.DefaultSecretKeySizeProvider;
import com.aspose.html.internal.ms.core.bc.operator.GenericKey;
import com.aspose.html.internal.ms.core.bc.operator.OperatorCreationException;
import com.aspose.html.internal.ms.core.bc.operator.OutputEncryptor;
import com.aspose.html.internal.ms.core.bc.operator.PBKDF2Config;
import com.aspose.html.internal.ms.core.bc.operator.PBKDFConfig;
import com.aspose.html.internal.ms.core.bc.operator.ScryptConfig;
import com.aspose.html.internal.ms.core.bc.operator.ScryptParams;
import com.aspose.html.internal.ms.core.bc.operator.SecretKeySizeProvider;
import com.aspose.html.internal.ms.core.bc.pkcs.jcajce.JceUtils;
import java.io.OutputStream;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class JcePKCSPBEOutputEncryptorBuilder {
    private final PBKDFConfig pbkdf;
    private JcaJceHelper helper = new DefaultJcaJceHelper();
    private ASN1ObjectIdentifier algorithm;
    private ASN1ObjectIdentifier keyEncAlgorithm;
    private SecureRandom random;
    private SecretKeySizeProvider keySizeProvider = DefaultSecretKeySizeProvider.INSTANCE;
    private int iterationCount = 1024;
    private PBKDF2Config.Builder pbkdfBuilder = new PBKDF2Config.Builder();

    public JcePKCSPBEOutputEncryptorBuilder(ASN1ObjectIdentifier keyEncryptionAlg) {
        this.pbkdf = null;
        if (this.isPKCS12(keyEncryptionAlg)) {
            this.algorithm = keyEncryptionAlg;
            this.keyEncAlgorithm = keyEncryptionAlg;
        } else {
            this.algorithm = PKCSObjectIdentifiers.id_PBES2;
            this.keyEncAlgorithm = keyEncryptionAlg;
        }
    }

    public JcePKCSPBEOutputEncryptorBuilder(PBKDFConfig pbkdfAlgorithm, ASN1ObjectIdentifier keyEncryptionAlg) {
        this.algorithm = PKCSObjectIdentifiers.id_PBES2;
        this.pbkdf = pbkdfAlgorithm;
        this.keyEncAlgorithm = keyEncryptionAlg;
    }

    public JcePKCSPBEOutputEncryptorBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePKCSPBEOutputEncryptorBuilder setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public JcePKCSPBEOutputEncryptorBuilder setRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public JcePKCSPBEOutputEncryptorBuilder setKeySizeProvider(SecretKeySizeProvider keySizeProvider) {
        this.keySizeProvider = keySizeProvider;
        return this;
    }

    public JcePKCSPBEOutputEncryptorBuilder setPRF(AlgorithmIdentifier prf) {
        if (this.pbkdf != null) {
            throw new IllegalStateException("set PRF count using PBKDFDef");
        }
        this.pbkdfBuilder.withPRF(prf);
        return this;
    }

    public JcePKCSPBEOutputEncryptorBuilder setIterationCount(int iterationCount) {
        if (this.pbkdf != null) {
            throw new IllegalStateException("set iteration count using PBKDFDef");
        }
        this.iterationCount = iterationCount;
        this.pbkdfBuilder.withIterationCount(iterationCount);
        return this;
    }

    public OutputEncryptor build(final char[] password) throws OperatorCreationException {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        try {
            AlgorithmIdentifier algorithmIdentifier;
            Cipher cipher;
            if (this.isPKCS12(this.algorithm)) {
                byte[] byArray = new byte[20];
                this.random.nextBytes(byArray);
                cipher = this.helper.createCipher(this.algorithm.getId());
                cipher.init(1, new PKCS12KeyWithParameters(password, byArray, this.iterationCount));
                algorithmIdentifier = new AlgorithmIdentifier(this.algorithm, new PKCS12PBEParams(byArray, this.iterationCount));
            } else if (this.algorithm.equals(PKCSObjectIdentifiers.id_PBES2)) {
                PBKDFConfig pBKDFConfig;
                PBKDFConfig pBKDFConfig2 = pBKDFConfig = this.pbkdf == null ? this.pbkdfBuilder.build() : this.pbkdf;
                if (JceUtils.id_scrypt.equals(pBKDFConfig.getAlgorithm())) {
                    ScryptConfig scryptConfig = (ScryptConfig)pBKDFConfig;
                    byte[] byArray = new byte[scryptConfig.getSaltLength()];
                    this.random.nextBytes(byArray);
                    ScryptParams scryptParams = new ScryptParams(byArray, scryptConfig.getCostParameter(), scryptConfig.getBlockSize(), scryptConfig.getParallelizationParameter());
                    AlgorithmIdentifier algorithmIdentifier2 = new AlgorithmIdentifier(this.keyEncAlgorithm);
                    KDF.ScryptParameters scryptParameters = KDF.SCRYPT.using(scryptParams.getSalt(), scryptParams.getCostParameter().intValue(), scryptParams.getBlockSize().intValue(), scryptParams.getParallelizationParameter().intValue(), PasswordConverter.UTF8, password);
                    byte[] byArray2 = new byte[(this.keySizeProvider.getKeySize(algorithmIdentifier2) + 7) / 8];
                    new KDF.SCryptFactory().createKDFCalculator(scryptParameters).generateBytes(byArray2);
                    SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, algorithmIdentifier2.getAlgorithm().getId());
                    cipher = this.helper.createCipher(this.keyEncAlgorithm.getId());
                    cipher.init(1, (Key)secretKeySpec, this.random);
                    PBES2Parameters pBES2Parameters = new PBES2Parameters(new KeyDerivationFunc(JceUtils.id_scrypt, scryptParams), new EncryptionScheme(this.keyEncAlgorithm, ASN1Primitive.fromByteArray(cipher.getParameters().getEncoded())));
                    algorithmIdentifier = new AlgorithmIdentifier(this.algorithm, pBES2Parameters);
                } else {
                    PBKDF2Config pBKDF2Config = (PBKDF2Config)pBKDFConfig;
                    byte[] byArray = new byte[pBKDF2Config.getSaltLength()];
                    this.random.nextBytes(byArray);
                    SecretKeyFactory secretKeyFactory = this.helper.createSecretKeyFactory(JceUtils.getAlgorithm(pBKDF2Config.getPRF().getAlgorithm()));
                    SecretKey secretKey = secretKeyFactory.generateSecret(new PBEKeySpec(password, byArray, pBKDF2Config.getIterationCount(), this.keySizeProvider.getKeySize(new AlgorithmIdentifier(this.keyEncAlgorithm))));
                    cipher = this.helper.createCipher(this.keyEncAlgorithm.getId());
                    cipher.init(1, (Key)secretKey, this.random);
                    PBES2Parameters pBES2Parameters = new PBES2Parameters(new KeyDerivationFunc(PKCSObjectIdentifiers.id_PBKDF2, new PBKDF2Params(byArray, pBKDF2Config.getIterationCount(), pBKDF2Config.getPRF())), new EncryptionScheme(this.keyEncAlgorithm, ASN1Primitive.fromByteArray(cipher.getParameters().getEncoded())));
                    algorithmIdentifier = new AlgorithmIdentifier(this.algorithm, pBES2Parameters);
                }
            } else {
                throw new OperatorCreationException("unrecognised algorithm");
            }
            return new OutputEncryptor(){

                public AlgorithmIdentifier getAlgorithmIdentifier() {
                    return algorithmIdentifier;
                }

                public OutputStream getOutputStream(OutputStream out) {
                    return new CipherOutputStream(out, cipher);
                }

                public GenericKey getKey() {
                    if (JcePKCSPBEOutputEncryptorBuilder.this.isPKCS12(algorithmIdentifier.getAlgorithm())) {
                        return new GenericKey(algorithmIdentifier, JcePKCSPBEOutputEncryptorBuilder.PKCS12PasswordToBytes(password));
                    }
                    return new GenericKey(algorithmIdentifier, JcePKCSPBEOutputEncryptorBuilder.PKCS5PasswordToBytes(password));
                }
            };
        }
        catch (Exception exception) {
            throw new OperatorCreationException("unable to create OutputEncryptor: " + exception.getMessage(), exception);
        }
    }

    private boolean isPKCS12(ASN1ObjectIdentifier algorithm) {
        return algorithm.on(PKCSObjectIdentifiers.pkcs_12PbeIds) || algorithm.on(BCObjectIdentifiers.bc_pbe_sha1_pkcs12) || algorithm.on(BCObjectIdentifiers.bc_pbe_sha256_pkcs12);
    }

    private static byte[] PKCS5PasswordToBytes(char[] password) {
        if (password != null) {
            byte[] byArray = new byte[password.length];
            for (int i2 = 0; i2 != byArray.length; ++i2) {
                byArray[i2] = (byte)password[i2];
            }
            return byArray;
        }
        return new byte[0];
    }

    private static byte[] PKCS12PasswordToBytes(char[] password) {
        if (password != null && password.length > 0) {
            byte[] byArray = new byte[(password.length + 1) * 2];
            for (int i2 = 0; i2 != password.length; ++i2) {
                byArray[i2 * 2] = (byte)(password[i2] >>> 8);
                byArray[i2 * 2 + 1] = (byte)password[i2];
            }
            return byArray;
        }
        return new byte[0];
    }
}

