/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.tsp;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1Encodable;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1EncodableVector;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Integer;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.DERBitString;
import com.aspose.html.internal.ms.core.bc.asn1.DERSequence;
import com.aspose.html.internal.ms.core.bc.asn1.DERUTF8String;
import com.aspose.html.internal.ms.core.bc.asn1.DLSequence;
import com.aspose.html.internal.ms.core.bc.asn1.cmp.PKIFreeText;
import com.aspose.html.internal.ms.core.bc.asn1.cmp.PKIStatusInfo;
import com.aspose.html.internal.ms.core.bc.asn1.cms.ContentInfo;
import com.aspose.html.internal.ms.core.bc.asn1.tsp.TimeStampResp;
import com.aspose.html.internal.ms.core.bc.asn1.x509.Extensions;
import com.aspose.html.internal.ms.core.bc.tsp.TSPException;
import com.aspose.html.internal.ms.core.bc.tsp.TSPValidationException;
import com.aspose.html.internal.ms.core.bc.tsp.TimeStampRequest;
import com.aspose.html.internal.ms.core.bc.tsp.TimeStampResponse;
import com.aspose.html.internal.ms.core.bc.tsp.TimeStampTokenGenerator;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class TimeStampResponseGenerator {
    int status;
    ASN1EncodableVector statusStrings;
    int failInfo;
    private TimeStampTokenGenerator tokenGenerator;
    private Set acceptedAlgorithms;
    private Set acceptedPolicies;
    private Set acceptedExtensions;

    public TimeStampResponseGenerator(TimeStampTokenGenerator tokenGenerator, Set acceptedAlgorithms) {
        this(tokenGenerator, acceptedAlgorithms, null, null);
    }

    public TimeStampResponseGenerator(TimeStampTokenGenerator tokenGenerator, Set acceptedAlgorithms, Set acceptedPolicies) {
        this(tokenGenerator, acceptedAlgorithms, acceptedPolicies, null);
    }

    public TimeStampResponseGenerator(TimeStampTokenGenerator tokenGenerator, Set acceptedAlgorithms, Set acceptedPolicies, Set acceptedExtensions) {
        this.tokenGenerator = tokenGenerator;
        this.acceptedAlgorithms = this.convert(acceptedAlgorithms);
        this.acceptedPolicies = this.convert(acceptedPolicies);
        this.acceptedExtensions = this.convert(acceptedExtensions);
        this.statusStrings = new ASN1EncodableVector();
    }

    private void addStatusString(String statusString) {
        this.statusStrings.add(new DERUTF8String(statusString));
    }

    private void setFailInfoField(int field) {
        this.failInfo |= field;
    }

    private PKIStatusInfo getPKIStatusInfo() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(this.status));
        if (this.statusStrings.size() > 0) {
            aSN1EncodableVector.add(PKIFreeText.getInstance(new DERSequence(this.statusStrings)));
        }
        if (this.failInfo != 0) {
            FailInfo failInfo = new FailInfo(this.failInfo);
            aSN1EncodableVector.add(failInfo);
        }
        return PKIStatusInfo.getInstance(new DERSequence(aSN1EncodableVector));
    }

    public TimeStampResponse generate(TimeStampRequest request, BigInteger serialNumber, Date genTime) throws TSPException {
        try {
            return this.generateGrantedResponse(request, serialNumber, genTime, "Operation Okay");
        }
        catch (Exception exception) {
            return this.generateRejectedResponse(exception);
        }
    }

    public TimeStampResponse generateGrantedResponse(TimeStampRequest request, BigInteger serialNumber, Date genTime) throws TSPException {
        return this.generateGrantedResponse(request, serialNumber, genTime, null);
    }

    public TimeStampResponse generateGrantedResponse(TimeStampRequest request, BigInteger serialNumber, Date genTime, String statusString) throws TSPException {
        return this.generateGrantedResponse(request, serialNumber, genTime, statusString, null);
    }

    public TimeStampResponse generateGrantedResponse(TimeStampRequest request, BigInteger serialNumber, Date genTime, String statusString, Extensions additionalExtensions) throws TSPException {
        ContentInfo contentInfo;
        if (genTime == null) {
            throw new TSPValidationException("The time source is not available.", 512);
        }
        request.validate(this.acceptedAlgorithms, this.acceptedPolicies, this.acceptedExtensions);
        this.status = 0;
        this.statusStrings = new ASN1EncodableVector();
        if (statusString != null) {
            this.addStatusString(statusString);
        }
        PKIStatusInfo pKIStatusInfo = this.getPKIStatusInfo();
        try {
            contentInfo = this.tokenGenerator.generate(request, serialNumber, genTime, additionalExtensions).toCMSSignedData().toASN1Structure();
        }
        catch (TSPException tSPException) {
            throw tSPException;
        }
        catch (Exception exception) {
            throw new TSPException("Timestamp token received cannot be converted to ContentInfo", exception);
        }
        try {
            return new TimeStampResponse(new DLSequence(new ASN1Encodable[]{pKIStatusInfo.toASN1Primitive(), contentInfo.toASN1Primitive()}));
        }
        catch (IOException iOException) {
            throw new TSPException("created badly formatted response!");
        }
    }

    public TimeStampResponse generateRejectedResponse(Exception exception) throws TSPException {
        if (exception instanceof TSPValidationException) {
            return this.generateFailResponse(2, ((TSPValidationException)exception).getFailureCode(), exception.getMessage());
        }
        return this.generateFailResponse(2, 0x40000000, exception.getMessage());
    }

    public TimeStampResponse generateFailResponse(int status, int failInfoField, String statusString) throws TSPException {
        this.status = status;
        this.statusStrings = new ASN1EncodableVector();
        this.setFailInfoField(failInfoField);
        if (statusString != null) {
            this.addStatusString(statusString);
        }
        PKIStatusInfo pKIStatusInfo = this.getPKIStatusInfo();
        TimeStampResp timeStampResp = new TimeStampResp(pKIStatusInfo, null);
        try {
            return new TimeStampResponse(timeStampResp);
        }
        catch (IOException iOException) {
            throw new TSPException("created badly formatted response!");
        }
    }

    private Set convert(Set orig) {
        if (orig == null) {
            return orig;
        }
        HashSet<ASN1ObjectIdentifier> hashSet = new HashSet<ASN1ObjectIdentifier>(orig.size());
        for (Object e2 : orig) {
            if (e2 instanceof String) {
                hashSet.add(new ASN1ObjectIdentifier((String)e2));
                continue;
            }
            hashSet.add((ASN1ObjectIdentifier)e2);
        }
        return hashSet;
    }

    class FailInfo
    extends DERBitString {
        FailInfo(int failInfoValue) {
            super(FailInfo.getBytes(failInfoValue), FailInfo.getPadBits(failInfoValue));
        }
    }
}

