/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.tsp.cms;

import com.aspose.html.internal.ms.core.bc.asn1.DERIA5String;
import com.aspose.html.internal.ms.core.bc.asn1.cms.AttributeTable;
import com.aspose.html.internal.ms.core.bc.asn1.cms.CMSObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.cms.ContentInfoParser;
import com.aspose.html.internal.ms.core.bc.asn1.cms.TimeStampedDataParser;
import com.aspose.html.internal.ms.core.bc.cms.CMSContentInfoParser;
import com.aspose.html.internal.ms.core.bc.cms.CMSException;
import com.aspose.html.internal.ms.core.bc.operator.DigestCalculator;
import com.aspose.html.internal.ms.core.bc.operator.DigestCalculatorProvider;
import com.aspose.html.internal.ms.core.bc.operator.OperatorCreationException;
import com.aspose.html.internal.ms.core.bc.tsp.TimeStampToken;
import com.aspose.html.internal.ms.core.bc.tsp.cms.ImprintDigestInvalidException;
import com.aspose.html.internal.ms.core.bc.tsp.cms.TimeStampDataUtil;
import com.aspose.html.internal.ms.core.bc.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;

public class CMSTimeStampedDataParser
extends CMSContentInfoParser {
    private TimeStampedDataParser timeStampedData;
    private TimeStampDataUtil util;

    public CMSTimeStampedDataParser(InputStream in2) throws CMSException {
        super(in2);
        this.initialize(this._contentInfo);
    }

    public CMSTimeStampedDataParser(byte[] baseData) throws CMSException {
        this(new ByteArrayInputStream(baseData));
    }

    private void initialize(ContentInfoParser contentInfo) throws CMSException {
        try {
            if (!CMSObjectIdentifiers.timestampedData.equals(contentInfo.getContentType())) {
                throw new IllegalArgumentException("Malformed content - type must be " + CMSObjectIdentifiers.timestampedData.getId());
            }
            this.timeStampedData = TimeStampedDataParser.getInstance(contentInfo.getContent(16));
        }
        catch (IOException iOException) {
            throw new CMSException("parsing exception: " + iOException.getMessage(), iOException);
        }
    }

    public byte[] calculateNextHash(DigestCalculator calculator) throws CMSException {
        return this.util.calculateNextHash(calculator);
    }

    public InputStream getContent() {
        if (this.timeStampedData.getContent() != null) {
            return this.timeStampedData.getContent().getOctetStream();
        }
        return null;
    }

    public URI getDataUri() throws URISyntaxException {
        DERIA5String dERIA5String = this.timeStampedData.getDataUri();
        if (dERIA5String != null) {
            return new URI(dERIA5String.getString());
        }
        return null;
    }

    public String getFileName() {
        return this.util.getFileName();
    }

    public String getMediaType() {
        return this.util.getMediaType();
    }

    public AttributeTable getOtherMetaData() {
        return this.util.getOtherMetaData();
    }

    public void initialiseMessageImprintDigestCalculator(DigestCalculator calculator) throws CMSException {
        this.util.initialiseMessageImprintDigestCalculator(calculator);
    }

    public DigestCalculator getMessageImprintDigestCalculator(DigestCalculatorProvider calculatorProvider) throws OperatorCreationException {
        try {
            this.parseTimeStamps();
        }
        catch (CMSException cMSException) {
            throw new OperatorCreationException("unable to extract algorithm ID: " + cMSException.getMessage(), cMSException);
        }
        return this.util.getMessageImprintDigestCalculator(calculatorProvider);
    }

    public TimeStampToken[] getTimeStampTokens() throws CMSException {
        this.parseTimeStamps();
        return this.util.getTimeStampTokens();
    }

    public void validate(DigestCalculatorProvider calculatorProvider, byte[] dataDigest) throws ImprintDigestInvalidException, CMSException {
        this.parseTimeStamps();
        this.util.validate(calculatorProvider, dataDigest);
    }

    public void validate(DigestCalculatorProvider calculatorProvider, byte[] dataDigest, TimeStampToken timeStampToken) throws ImprintDigestInvalidException, CMSException {
        this.parseTimeStamps();
        this.util.validate(calculatorProvider, dataDigest, timeStampToken);
    }

    private void parseTimeStamps() throws CMSException {
        try {
            if (this.util == null) {
                InputStream inputStream = this.getContent();
                if (inputStream != null) {
                    Streams.drain(inputStream);
                }
                this.util = new TimeStampDataUtil(this.timeStampedData);
            }
        }
        catch (IOException iOException) {
            throw new CMSException("unable to parse evidence block: " + iOException.getMessage(), iOException);
        }
    }
}

