/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.compression.zlib;

import com.aspose.html.internal.ms.System.BitConverter;
import com.aspose.html.internal.ms.System.DateTime;
import com.aspose.html.internal.ms.System.IO.MemoryStream;
import com.aspose.html.internal.ms.System.IO.Path;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.ObjectDisposedException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.Encoding;
import com.aspose.html.internal.ms.core.compression.zlib.ZlibException;
import com.aspose.html.internal.ms.core.compression.zlib.aa;
import com.aspose.time.TimeSpan;

public class GZipStream
extends Stream {
    public DateTime LastModified = DateTime.MinValue.Clone();
    private int d;
    aa a;
    private boolean e;
    private boolean f;
    private String g;
    private String h;
    private int i;
    static DateTime b = new DateTime(1970, 1, 1, 0, 0, 0, 1L);
    static Encoding c = Encoding.getEncoding("iso-8859-1");

    public String getComment() {
        return this.h;
    }

    public void setComment(String value) {
        if (this.e) {
            throw new ObjectDisposedException("GZipStream");
        }
        this.h = value;
    }

    public String getFileName() {
        return this.g;
    }

    public void setFileName(String value) {
        if (this.e) {
            throw new ObjectDisposedException("GZipStream");
        }
        this.g = value;
        if (this.g == null) {
            return;
        }
        if (this.g.indexOf("/") != -1) {
            this.g = this.g.replace("/", "\\");
        }
        if (this.g.endsWith("\\")) {
            throw new RuntimeException("Illegal filename");
        }
        if (this.g.indexOf("\\") != -1) {
            this.g = Path.getFileName(this.g);
        }
    }

    public int getCrc32() {
        return this.i;
    }

    public GZipStream(Stream stream, int mode) {
        this(stream, mode, 6, false);
    }

    public GZipStream(Stream stream, int mode, int level) {
        this(stream, mode, level, false);
    }

    public GZipStream(Stream stream, int mode, boolean leaveOpen) {
        this(stream, mode, 6, leaveOpen);
    }

    public GZipStream(Stream stream, int mode, int level, boolean leaveOpen) {
        this.a = new aa(stream, mode, level, 1952, leaveOpen);
    }

    public int getFlushMode() {
        return this.a.c;
    }

    public void setFlushMode(int value) {
        if (this.e) {
            throw new ObjectDisposedException("GZipStream");
        }
        this.a.c = value;
    }

    public int getBufferSize() {
        return this.a.i;
    }

    public void setBufferSize(int value) {
        if (this.e) {
            throw new ObjectDisposedException("GZipStream");
        }
        if (this.a.h != null) {
            throw new ZlibException("The working buffer is already set.");
        }
        if (value < 1024) {
            throw new ZlibException(StringExtensions.format("Don't be silly. {0} bytes?? Use a bigger buffer, at least {1}.", value, 1024));
        }
        this.a.i = value;
    }

    public long getTotalIn() {
        return this.a.a.TotalBytesIn;
    }

    public long getTotalOut() {
        return this.a.a.TotalBytesOut;
    }

    @Override
    protected void dispose(boolean disposing) {
        try {
            if (!this.e) {
                if (disposing && this.a != null) {
                    this.a.close();
                    this.i = this.a.a();
                }
                this.e = true;
            }
        }
        finally {
            super.dispose(disposing);
        }
    }

    @Override
    public boolean canRead() {
        if (this.e) {
            throw new ObjectDisposedException("GZipStream");
        }
        return this.a.k.canRead();
    }

    @Override
    public boolean canSeek() {
        return false;
    }

    @Override
    public boolean canWrite() {
        if (this.e) {
            throw new ObjectDisposedException("GZipStream");
        }
        return this.a.k.canWrite();
    }

    @Override
    public void flush() {
        if (this.e) {
            throw new ObjectDisposedException("GZipStream");
        }
        this.a.flush();
    }

    @Override
    public long getLength() {
        throw new NotImplementedException();
    }

    @Override
    public long getPosition() {
        if (this.a.b == 0) {
            return this.a.a.TotalBytesOut + (long)this.d;
        }
        if (this.a.b == 1) {
            return this.a.a.TotalBytesIn + (long)this.a.p;
        }
        return 0L;
    }

    @Override
    public void setPosition(long value) {
        throw new NotImplementedException();
    }

    @Override
    public int read(byte[] buffer, int offset, int count) {
        if (this.e) {
            throw new ObjectDisposedException("GZipStream");
        }
        int n2 = this.a.read(buffer, offset, count);
        if (!this.f) {
            this.f = true;
            this.setFileName(this.a.m);
            this.setComment(this.a.n);
        }
        return n2;
    }

    @Override
    public long seek(long offset, int origin) {
        throw new NotImplementedException();
    }

    @Override
    public void setLength(long value) {
        throw new NotImplementedException();
    }

    @Override
    public void write(byte[] buffer, int offset, int count) {
        if (this.e) {
            throw new ObjectDisposedException("GZipStream");
        }
        if (this.a.b == 2) {
            if (this.a.b()) {
                this.d = this.a();
            } else {
                throw new IllegalStateException();
            }
        }
        this.a.write(buffer, offset, count);
    }

    private int a() {
        byte[] byArray = this.getComment() == null ? null : c.getBytes(this.getComment());
        byte[] byArray2 = this.getFileName() == null ? null : c.getBytes(this.getFileName());
        int n2 = this.getComment() == null ? 0 : byArray.length + 1;
        int n3 = this.getFileName() == null ? 0 : byArray2.length + 1;
        int n4 = 10 + n2 + n3;
        byte[] byArray3 = new byte[n4];
        int n5 = 0;
        byArray3[n5++] = 31;
        byArray3[n5++] = -117;
        byArray3[n5++] = 8;
        int n6 = 0;
        if (this.getComment() != null) {
            n6 = (byte)(n6 ^ 0x10);
        }
        if (this.getFileName() != null) {
            n6 = (byte)(n6 ^ 8);
        }
        byArray3[n5++] = n6;
        if (this.LastModified.equals(DateTime.MinValue)) {
            DateTime.getNow().CloneTo(this.LastModified);
        }
        TimeSpan timeSpan = DateTime.op_Subtraction(this.LastModified, b).Clone();
        int n7 = (int)timeSpan.getTotalSeconds();
        System.arraycopy(BitConverter.getBytesInt32(n7), 0, byArray3, n5, 4);
        n5 += 4;
        byArray3[n5++] = 0;
        byArray3[n5++] = -1;
        if (n3 != 0) {
            System.arraycopy(byArray2, 0, byArray3, n5, n3 - 1);
            n5 += n3 - 1;
            byArray3[n5++] = 0;
        }
        if (n2 != 0) {
            System.arraycopy(byArray, 0, byArray3, n5, n2 - 1);
            n5 += n2 - 1;
            byArray3[n5++] = 0;
        }
        this.a.k.write(byArray3, 0, byArray3.length);
        return byArray3.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compressString(String s2) {
        MemoryStream memoryStream = new MemoryStream();
        try {
            GZipStream gZipStream = new GZipStream((Stream)memoryStream, 0, 9);
            aa.a(s2, (Stream)gZipStream);
            byte[] byArray = memoryStream.toArray();
            return byArray;
        }
        finally {
            if (memoryStream != null) {
                memoryStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compressBuffer(byte[] b2) {
        MemoryStream memoryStream = new MemoryStream();
        try {
            GZipStream gZipStream = new GZipStream((Stream)memoryStream, 0, 9);
            aa.a(b2, (Stream)gZipStream);
            byte[] byArray = memoryStream.toArray();
            return byArray;
        }
        finally {
            if (memoryStream != null) {
                memoryStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uncompressString(byte[] compressed) {
        MemoryStream memoryStream = new MemoryStream(compressed);
        try {
            GZipStream gZipStream = new GZipStream(memoryStream, 1);
            String string = aa.b(compressed, gZipStream);
            return string;
        }
        finally {
            if (memoryStream != null) {
                memoryStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] uncompressBuffer(byte[] compressed) {
        MemoryStream memoryStream = new MemoryStream(compressed);
        try {
            GZipStream gZipStream = new GZipStream(memoryStream, 1);
            byte[] byArray = aa.c(compressed, gZipStream);
            return byArray;
        }
        finally {
            if (memoryStream != null) {
                memoryStream.close();
            }
        }
    }
}

