/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.resources;

import com.aspose.html.internal.ms.System.BitConverter;
import com.aspose.html.internal.ms.System.IO.File;
import com.aspose.html.internal.ms.System.IO.FileStream;
import com.aspose.html.internal.ms.System.IO.MemoryStream;
import com.aspose.html.internal.ms.System.IO.Path;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.Text.Encoding;
import com.aspose.html.internal.ms.core.compression.zlib.ZlibStream;
import com.aspose.html.internal.ms.core.resources.ResourceFile;
import com.aspose.html.internal.ms.core.resources.ResourcesReader;
import java.util.ArrayList;
import java.util.List;

public class ResourcesWriter {
    public static final String Header = "PAK";

    public static void writeFiles(String[] files, Stream output) {
        ArrayList<ResourceFile> arrayList = new ArrayList<ResourceFile>();
        for (String string : files) {
            FileStream fileStream = File.openRead(string);
            arrayList.add(new ResourceFile(Path.getFileName(string), fileStream));
        }
        ResourcesWriter.writeResources(arrayList, output);
        output.flush();
    }

    public static void writeResources(List<ResourceFile> data, Stream output) {
        output.write(Encoding.getASCII().getBytes(Header), 0, Header.length());
        output.write(BitConverter.getBytesInt64(System.currentTimeMillis()), 0, 8);
        int n2 = data.size();
        output.write(BitConverter.getBytesInt32(n2), 0, 4);
        for (ResourceFile resourceFile : data) {
            output.write(BitConverter.getBytesInt32(resourceFile.getName().length()), 0, 4);
            output.write(Encoding.getUTF8().getBytes(resourceFile.getName()), 0, resourceFile.getName().length());
            ResourcesWriter.a(resourceFile.getData(), output);
        }
        output.flush();
    }

    private static void a(Stream stream, Stream stream2) {
        MemoryStream memoryStream = new MemoryStream();
        try {
            ResourcesWriter.b(stream, memoryStream);
            memoryStream.setPosition(0L);
            stream2.write(BitConverter.getBytesInt32((int)memoryStream.getLength()), 0, 4);
            ResourcesReader.a((Stream)memoryStream, stream2);
        }
        finally {
            memoryStream.close();
        }
    }

    private static void b(Stream stream, Stream stream2) {
        ZlibStream zlibStream = new ZlibStream(stream2, 0, 9, true);
        try {
            ResourcesReader.a(stream, zlibStream);
        }
        finally {
            zlibStream.close();
        }
    }
}

