/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.helpers.streams;

import com.aspose.html.internal.ms.System.IO.IOException;
import com.aspose.html.internal.ms.System.IO.MemoryStream;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.helpers.streams.LoadFromStreamAspect;
import com.aspose.html.internal.ms.helpers.streams.SaveToStreamAspect;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamUtil {
    public static final int BufferSize = 65536;

    public static MemoryStream copyStream(InputStream srcStream) {
        if (srcStream == null) {
            throw new NullPointerException("srcStream");
        }
        MemoryStream memoryStream = new MemoryStream();
        byte[] byArray = new byte[65536];
        while (true) {
            int n2 = 0;
            try {
                n2 = srcStream.read(byArray, 0, byArray.length);
            }
            catch (java.io.IOException iOException) {
                throw new IOException("exception", iOException);
            }
            if (n2 <= 0) break;
            memoryStream.write(byArray, 0, n2);
        }
        memoryStream.setPosition(0L);
        return memoryStream;
    }

    public static MemoryStream copyStream(Stream srcStream) {
        int n2;
        if (srcStream == null) {
            throw new NullPointerException("srcStream");
        }
        MemoryStream memoryStream = new MemoryStream();
        byte[] byArray = new byte[65536];
        while ((n2 = srcStream.read(byArray, 0, byArray.length)) > 0) {
            memoryStream.write(byArray, 0, n2);
        }
        memoryStream.setPosition(0L);
        return memoryStream;
    }

    public static void copyStream(Stream srcStream, OutputStream dstStream) {
        StreamUtil.copyStream(srcStream, dstStream, 0L);
    }

    public static void copyStream(Stream srcStream, OutputStream dstStream, long srcPosition) {
        int n2;
        if (srcStream == null) {
            throw new NullPointerException("srcStream");
        }
        if (dstStream == null) {
            throw new NullPointerException("dstStream");
        }
        long l2 = srcStream.getPosition();
        srcStream.setPosition(srcPosition);
        byte[] byArray = new byte[65536];
        while ((n2 = srcStream.read(byArray, 0, byArray.length)) != 0) {
            try {
                dstStream.write(byArray, 0, n2);
            }
            catch (java.io.IOException iOException) {
                throw new IOException("exception", iOException);
            }
        }
        srcStream.setPosition(l2);
    }

    public static void copyStream(Stream srcStream, Stream dstStream) {
        int n2;
        if (srcStream == null) {
            throw new NullPointerException("srcStream");
        }
        if (dstStream == null) {
            throw new NullPointerException("dstStream");
        }
        long l2 = srcStream.getPosition();
        srcStream.setPosition(0L);
        byte[] byArray = new byte[65536];
        while ((n2 = srcStream.read(byArray, 0, byArray.length)) != 0) {
            dstStream.write(byArray, 0, n2);
        }
        srcStream.setPosition(l2);
    }

    public static <T> T invoke(LoadFromStreamAspect<T> aspect) {
        return aspect.exec();
    }

    public static void invoke(SaveToStreamAspect aspect) {
        aspect.exec();
    }
}

