/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.rendering;

import com.aspose.html.Configuration;
import com.aspose.html.HTMLDocument;
import com.aspose.html.HTMLTemplateElement;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.dom.svg.SVGDocument;
import com.aspose.html.dom.z2;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericList;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.ms.lang.StringSwitchMap;
import com.aspose.html.internal.p116.z4;
import com.aspose.html.internal.p116.z5;
import com.aspose.html.internal.p129.z2;
import com.aspose.html.internal.p161.z6;
import com.aspose.html.internal.p273.z1;
import com.aspose.html.net.MessageHandler;
import com.aspose.html.net.RequestMessage;
import com.aspose.html.net.ResponseMessage;
import com.aspose.html.rendering.IDevice;
import com.aspose.html.rendering.Renderer;
import com.aspose.html.rendering.z8;
import com.aspose.html.services.INetworkService;
import com.aspose.html.z3;
import com.aspose.time.TimeSpan;
import java.io.InputStream;

public class EpubRenderer
extends Renderer<Stream> {
    private static final StringSwitchMap gStringSwitchMap = new StringSwitchMap("application/xhtml+xml", "image/svg+xml");

    @Override
    public void render(IDevice device, InputStream stream) {
        this.render(device, new z1(stream));
    }

    @Override
    public void render(IDevice device, TimeSpan timeout, Stream ... documents) {
        this.render(device, new Configuration(), timeout.Clone(), documents);
    }

    @Override
    public void render(IDevice device, TimeSpan timeout, Stream stream) {
        throw new NotSupportedException();
    }

    public final void render(IDevice device, Stream document, Configuration configuration) {
        this.render(device, document, configuration, TimeSpan.Zero.Clone());
    }

    public final void render(IDevice device, Stream document, Configuration configuration, TimeSpan timeout) {
        this.render(device, configuration, timeout.Clone(), document);
    }

    public final void render(IDevice device, IGenericList<Stream> documents, Configuration configuration) {
        this.render(device, documents, configuration, TimeSpan.Zero.Clone());
    }

    public final void render(IDevice device, IGenericList<Stream> documents, Configuration configuration, TimeSpan timeout) {
        Stream[] streamArray = new Stream[documents.size()];
        documents.copyToTArray((Stream[])streamArray, 0);
        this.render(device, configuration, timeout.Clone(), streamArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void render(IDevice device, Configuration configuration, TimeSpan timeout, Stream ... documents) {
        IDisposable iDisposable;
        Document[] documentArray;
        if (documents.length == 0) {
            return;
        }
        this.validatePageSetup(device.getOptions().getPageSetup());
        List<com.aspose.html.internal.p161.z2> list = new List<com.aspose.html.internal.p161.z2>();
        Document[] documentArray2 = new Document[documents.length];
        try {
            for (int i2 = 0; i2 < documents.length; ++i2) {
                documentArray2[i2] = new HTMLDocument(StringExtensions.Empty, StringExtensions.Empty, configuration);
                documentArray = documentArray2[i2].getBrowsingContext();
                Stream stream = documents[i2];
                z4 z4100 = new z4();
                z8 object = new z8(z4100);
                documentArray.getService(INetworkService.class).getMessageHandlers().addItem(object);
                z4100.m1(stream, (z3)documentArray);
                this.addDocumentSources((z3)documentArray, z4100, list, object, timeout.Clone());
                z5.z1 z1100 = this.getNavElement(z4100);
                if (z1100 != null) {
                    ResponseMessage responseMessage = documentArray.getNetwork().send(new RequestMessage(z1100.m2110()));
                    try {
                        Document document = documentArray.m3().m1(responseMessage);
                        try {
                            if (document.getDocumentElement() != null) {
                                Document document2 = list.get_Item(list.size() - 1).getDocument();
                                Element element = document2.querySelector("head");
                                if (element == null) {
                                    element = document2.createElementNS(z2.z8.m3862, "head");
                                    document2.getDocumentElement().appendChild(element);
                                }
                                HTMLTemplateElement hTMLTemplateElement = (HTMLTemplateElement)document2.createElementNS(z2.z8.m3862, "template");
                                hTMLTemplateElement.getContent().appendChild(document.getDocumentElement());
                                hTMLTemplateElement.setAttribute("BaseUrl", document.getBaseURI());
                                element.appendChild(hTMLTemplateElement);
                            }
                        }
                        finally {
                            if (document != null) {
                                document.dispose();
                            }
                        }
                    }
                    finally {
                        if (responseMessage != null) {
                            responseMessage.dispose();
                        }
                    }
                }
                documentArray.getService(INetworkService.class).getMessageHandlers().removeItem(object);
            }
            iDisposable = configuration.getService(com.aspose.html.services.z2.class);
            documentArray = timeout.Clone();
            iDisposable.m1(this, list.toArray(new com.aspose.html.internal.p161.z2[0]), device, (TimeSpan)documentArray);
            device.flush();
            iDisposable = list.iterator();
        }
        catch (Throwable throwable) {
            Document[] documentArray3;
            device.flush();
            IGenericEnumerator iGenericEnumerator = list.iterator();
            try {
                while (iGenericEnumerator.hasNext()) {
                    documentArray3 = (Document[])iGenericEnumerator.next();
                    documentArray3.dispose();
                }
            }
            finally {
                if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
            documentArray3 = documentArray2;
            int n2 = documentArray3.length;
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    throw throwable;
                }
                Document document = documentArray3[n3];
                if (document != null) {
                    document.dispose();
                }
                ++n3;
            }
        }
        try {
            while (iDisposable.hasNext()) {
                documentArray = (com.aspose.html.internal.p161.z2)iDisposable.next();
                documentArray.dispose();
            }
        }
        finally {
            if (Operators.is(iDisposable, IDisposable.class)) {
                iDisposable.dispose();
            }
        }
        documentArray = documentArray2;
        int n4 = documentArray.length;
        int n5 = 0;
        while (n5 < n4) {
            Document document = documentArray[n5];
            if (document != null) {
                document.dispose();
            }
            ++n5;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private z5.z1 getNavElement(z4 ocfPackage) {
        IGenericEnumerator iGenericEnumerator = ocfPackage.m2099().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                z5 z5100 = (z5)iGenericEnumerator.next();
                z5.z1 z1100 = z5100.m2107();
                if (z1100 == null) continue;
                z5.z1 z1101 = z1100;
                return z1101;
            }
        }
        finally {
            if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDocumentSources(z3 context, z4 ocfPackage, List<com.aspose.html.internal.p161.z2> documentSources, MessageHandler messageHandler, TimeSpan timeout) {
        List<com.aspose.html.internal.p161.z2> list = new List<com.aspose.html.internal.p161.z2>();
        IGenericEnumerator iGenericEnumerator = ocfPackage.m2099().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                z5.z1[] z1Array;
                z5 z5100 = (z5)iGenericEnumerator.next();
                block8: for (z5.z1 z1100 : z1Array = z5100.m2108()) {
                    String string = StringExtensions.toLower(z1100.getMediaType(), CultureInfo.getInvariantCulture());
                    switch (gStringSwitchMap.of(string)) {
                        case 0: {
                            list.addItem(this.convertXHTML(z1100, context, timeout.Clone()));
                            continue block8;
                        }
                        case 1: {
                            list.addItem(this.convertSVG(z1100, context));
                        }
                    }
                }
            }
        }
        finally {
            if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        if (list.size() != 0) {
            list.set_Item(0, new com.aspose.html.internal.p161.z1((com.aspose.html.internal.p161.z2)list.get_Item(0), messageHandler));
            list.set_Item(list.size() - 1, new com.aspose.html.internal.p161.z5((com.aspose.html.internal.p161.z2)list.get_Item(list.size() - 1), messageHandler));
        }
        documentSources.addRange(list);
    }

    private com.aspose.html.internal.p161.z2 convertSVG(z5.z1 item, z3 context) {
        ResponseMessage responseMessage = context.getNetwork().send(new RequestMessage(item.m2110()));
        SVGDocument sVGDocument = (SVGDocument)context.m3().m1(responseMessage);
        z2.m2293().m1(z2.m2293().m64(this), sVGDocument);
        return new z6(sVGDocument);
    }

    private com.aspose.html.internal.p161.z2 convertXHTML(z5.z1 item, z3 context, TimeSpan timeout) {
        ResponseMessage responseMessage = context.getNetwork().send(new RequestMessage(item.m2110()));
        HTMLDocument hTMLDocument = (HTMLDocument)context.m3().m1(responseMessage);
        hTMLDocument.getContext().addService(new com.aspose.html.internal.p226.z1((z3)hTMLDocument.getContext()), com.aspose.html.internal.p225.z1.class);
        return new com.aspose.html.internal.p161.z4(hTMLDocument, timeout.Clone());
    }
}

