/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.rendering.pdf;

import com.aspose.html.HTMLAnchorElement;
import com.aspose.html.HTMLElement;
import com.aspose.html.HTMLLIElement;
import com.aspose.html.HTMLTemplateElement;
import com.aspose.html.Url;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.dom.Node;
import com.aspose.html.drawing.Color;
import com.aspose.html.drawing.IBrush;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.Generic.Dictionary;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.internal.ms.System.Collections.Generic.KeyValuePair;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.Drawing.Drawing2D.Matrix;
import com.aspose.html.internal.ms.System.Drawing.PointF;
import com.aspose.html.internal.ms.System.Drawing.RectangleF;
import com.aspose.html.internal.ms.System.Drawing.SizeF;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Uri;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.p11.z11;
import com.aspose.html.internal.p18.z10;
import com.aspose.html.internal.p18.z13;
import com.aspose.html.internal.p18.z16;
import com.aspose.html.internal.p18.z37;
import com.aspose.html.internal.p18.z41;
import com.aspose.html.internal.p211.z4;
import com.aspose.html.internal.p217.z6;
import com.aspose.html.internal.p331.z30;
import com.aspose.html.io.ICreateStreamProvider;
import com.aspose.html.net.UrlResolver;
import com.aspose.html.rendering.Device;
import com.aspose.html.rendering.GraphicContext;
import com.aspose.html.rendering.pdf.PdfRenderingOptions;
import com.aspose.html.rendering.pdf.z12;
import com.aspose.html.rendering.pdf.z14;
import com.aspose.html.rendering.pdf.z24;
import com.aspose.html.rendering.pdf.z38;
import com.aspose.html.rendering.pdf.z5;
import java.io.OutputStream;

public class PdfDevice
extends Device<z3, PdfRenderingOptions> {
    private z14 _pdfDoc;
    private Dictionary<String, Dictionary<String, z2>> _uriIdLocationMap = new Dictionary();
    private Dictionary<String, Integer> _uriPage = new Dictionary();
    private List<z1> _internalLinks = new List();
    private UrlResolver _resolver = new UrlResolver();
    private Node bookmarks;
    private String currentBaseUri;

    public PdfDevice(ICreateStreamProvider streamProvider) {
        this(new PdfRenderingOptions(), streamProvider);
    }

    public PdfDevice(PdfRenderingOptions options, ICreateStreamProvider streamProvider) {
        super(options, streamProvider);
    }

    public PdfDevice(String file) {
        this(new PdfRenderingOptions(), file);
    }

    public PdfDevice(PdfRenderingOptions options, String file) {
        super(options, file);
    }

    public PdfDevice(Stream stream) {
        this(new PdfRenderingOptions(), stream);
    }

    public PdfDevice(OutputStream outputStream) {
        this(new PdfRenderingOptions(), outputStream);
    }

    public PdfDevice(PdfRenderingOptions options, Stream stream) {
        super(options, stream);
    }

    public PdfDevice(PdfRenderingOptions options, OutputStream outputStream) {
        super(options, outputStream);
    }

    private static RectangleF transformRect(Matrix transformationMatrix, RectangleF rect) {
        PointF[] pointFArray = (PointF[])Array.unboxing(Array.createInstance(Operators.typeOf(PointF.class), 2));
        pointFArray[0] = new PointF(rect.getLeft(), rect.getTop());
        pointFArray[1] = new PointF(rect.getRight(), rect.getBottom());
        transformationMatrix.transformPoints(pointFArray);
        return new RectangleF(msMath.min(pointFArray[0].getX(), pointFArray[1].getX()), msMath.min(pointFArray[0].getY(), pointFArray[1].getY()), msMath.abs(pointFArray[0].getX() - pointFArray[1].getX()), msMath.abs(pointFArray[0].getY() - pointFArray[1].getY()));
    }

    private static String trimBookmarksTitles(String title) {
        if (StringExtensions.isNullOrEmpty(title)) {
            return null;
        }
        return StringExtensions.trim(StringExtensions.replace(StringExtensions.replace(title, '\n', ' '), '\r', ' '));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Element getFirstChildElement(Element element, String tagName) {
        IEnumerator iEnumerator = element.getChildren().iterator();
        try {
            while (iEnumerator.hasNext()) {
                Element element2 = (Element)iEnumerator.next();
                if (!StringExtensions.equals(element2.getTagName(), tagName, (short)5)) continue;
                Element element3 = element2;
                return element3;
            }
        }
        finally {
            if (Operators.is(iEnumerator, IDisposable.class)) {
                ((IDisposable)((Object)iEnumerator)).dispose();
            }
        }
        return null;
    }

    @Override
    public void saveGraphicContext() {
        this.clearExtGraphicState();
        this._pdfDoc.m3855().m3870();
        try {
            ((z3)this.getGraphicContext()).m168(true);
            super.saveGraphicContext();
        }
        finally {
            ((z3)this.getGraphicContext()).m168(false);
        }
    }

    @Override
    public void restoreGraphicContext() {
        this.clearExtGraphicState();
        this._pdfDoc.m3855().m3871();
        super.restoreGraphicContext();
    }

    @Override
    public void addRect(RectangleF rect) {
        this._pdfDoc.m3855().addRect(rect.Clone());
    }

    @Override
    protected void initialize() {
        super.initialize();
        ((z3)this.getGraphicContext()).m1(this);
    }

    @Override
    public void beginDocument(Document document) {
        this.currentBaseUri = document.getBaseURI();
        super.beginDocument(document);
        if (this._pdfDoc == null) {
            this._pdfDoc = new z14(this.getOutputStream(), (PdfRenderingOptions)this.getOptions(), this);
        }
    }

    @Override
    public boolean beginElement(Element element, RectangleF rect) {
        Dictionary<String, z2> dictionary;
        HTMLElement hTMLElement;
        if (element != null && !StringExtensions.isNullOrEmpty(this.currentBaseUri) && !this._uriPage.containsKey(this.currentBaseUri)) {
            this._uriPage.set_Item(this.currentBaseUri, this.getPageIndex());
        }
        if ((hTMLElement = Operators.as(element, HTMLElement.class)) != null && !StringExtensions.isNullOrEmpty(hTMLElement.getId_Rename_Namesake()) && !StringExtensions.isNullOrEmpty(this.currentBaseUri)) {
            dictionary = null;
            Object[] objectArray = new Dictionary[]{dictionary};
            boolean bl2 = !this._uriIdLocationMap.tryGetValue(this.currentBaseUri, objectArray);
            dictionary = objectArray[0];
            if (bl2) {
                dictionary = new Dictionary<String, z2>();
                this._uriIdLocationMap.set_Item(this.currentBaseUri, dictionary);
            }
            Object object = null;
            Object[] objectArray2 = new z2[]{object};
            dictionary.tryGetValue(hTMLElement.getId_Rename_Namesake(), objectArray2);
            object = objectArray2[0];
            if (object == null) {
                dictionary.set_Item(hTMLElement.getId_Rename_Namesake(), new z2(this._pdfDoc.m3855().m3860(), this.transformRect(rect.Clone()).getLocation().Clone()));
            }
        }
        if ((dictionary = com.aspose.html.rendering.z1.m1(element, rect.Clone(), this.getGraphicContext())) != null) {
            this.addFormElement((z16)((Object)dictionary));
            return Operators.is(dictionary, z10.class);
        }
        if (element != null && StringExtensions.equals(element.getTagName(), "A", (short)3) && hTMLElement != null) {
            this.addHyperlink(hTMLElement, rect.Clone());
        }
        return true;
    }

    private void addHyperlink(HTMLElement element, RectangleF rect) {
        if (!element.hasAttribute("href")) {
            return;
        }
        z5 z5100 = this._pdfDoc.m3855().m1(this.transformRect(rect.Clone()).Clone(), null);
        String string = element.getAttribute("href");
        if (Uri.isWellFormedUriString(string, 1)) {
            z5100.m1(new z4(string));
        } else {
            UrlResolver urlResolver = new UrlResolver();
            String[] stringArray = StringExtensions.split(string, new char[]{'#'}, (short)1);
            if (stringArray.length < 2) {
                this._internalLinks.addItem(new z1(z5100, urlResolver.resolve(element.getBaseURI(), string), ""));
            } else {
                String string2 = stringArray[0];
                String string3 = stringArray.length == 2 ? stringArray[1] : StringExtensions.Empty;
                this._internalLinks.addItem(new z1(z5100, urlResolver.resolve(element.getBaseURI(), string2), string3));
            }
        }
    }

    @Override
    public void beginPage(SizeF size) {
        super.beginPage(size.Clone());
        this._pdfDoc.m3(size.Clone());
        this.saveGraphicContext();
        ((z3)this.getGraphicContext()).transform(new Matrix(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, size.getHeight()));
        this.initPageBackground(size.Clone());
    }

    @Override
    public void clip(int mode) {
        this._pdfDoc.m3855().clip(mode);
    }

    @Override
    public void closePath() {
        this._pdfDoc.m3855().closePath();
    }

    @Override
    public void cubicBezierTo(PointF pt1, PointF pt2, PointF pt3) {
        this._pdfDoc.m3855().cubicBezierTo(pt1.Clone(), pt2.Clone(), pt3.Clone());
    }

    @Override
    public void drawImage(byte[] data, int type, RectangleF rect) {
        this.saveGraphicContext();
        this._pdfDoc.m3855().m1(data, rect.Clone());
        this.restoreGraphicContext();
    }

    @Override
    public void endDocument() {
        if (this.getRenderingStarted()) {
            this.registerBookmarks();
        }
        super.endDocument();
    }

    @Override
    public void flush() {
        if (this.getRenderingStarted()) {
            this.addInternalLinksDestinations();
            this.addBookmarks();
            this._pdfDoc.endDocument();
            this._pdfDoc = null;
        }
        this._uriIdLocationMap.clear();
        this._internalLinks.clear();
        this._uriPage.clear();
        super.flush();
    }

    @Override
    public void endElement(Element element) {
    }

    private void addFormElement(z16 formElement) {
        if (formElement != null) {
            z41 z4110 = Operators.as(formElement, z41.class);
            if (z4110 != null) {
                this._pdfDoc.m3825().m1(z4110, this._pdfDoc.m3855());
                return;
            }
            z10 z1010 = Operators.as(formElement, z10.class);
            if (z1010 != null) {
                this._pdfDoc.m3825().m1(z1010, this._pdfDoc.m3855());
                return;
            }
            z37 z3710 = Operators.as(formElement, z37.class);
            if (z3710 != null) {
                this._pdfDoc.m3825().m1(z3710, this._pdfDoc.m3855());
                return;
            }
            com.aspose.html.internal.p18.z12 z1210 = Operators.as(formElement, com.aspose.html.internal.p18.z12.class);
            if (z1210 != null) {
                this._pdfDoc.m3825().m1(z1210, this._pdfDoc.m3855());
                return;
            }
            z13 z1310 = Operators.as(formElement, z13.class);
            if (z1310 != null) {
                this._pdfDoc.m3825().m1(z1310, this._pdfDoc.m3855());
                return;
            }
        }
    }

    @Override
    public void endPage() {
        this.restoreGraphicContext();
        this._pdfDoc.endPage();
        super.endPage();
    }

    @Override
    public void fill(int mode) {
        this._pdfDoc.m3855().fill(mode);
    }

    @Override
    public void fillText(String text, PointF pt) {
        this._pdfDoc.m3855().fillText(text, pt.Clone());
    }

    @Override
    public void lineTo(PointF pt) {
        this._pdfDoc.m3855().lineTo(pt.Clone());
    }

    @Override
    public void moveTo(PointF pt) {
        this._pdfDoc.m3855().moveTo(pt.Clone());
    }

    @Override
    public void stroke() {
        this._pdfDoc.m3855().stroke();
    }

    @Override
    public void strokeAndFill(int mode) {
        this._pdfDoc.m3855().strokeAndFill(mode);
    }

    @Override
    public void strokeText(String text, PointF pt) {
    }

    @Override
    protected String getExtension() {
        return ".pdf";
    }

    public void setExtGraphicState() {
        this._pdfDoc.m3855().m3870();
        ((z3)this.getGraphicContext()).m817(((z3)this.getGraphicContext()).m3845() + 1);
    }

    public void clearExtGraphicState() {
        while (((z3)this.getGraphicContext()).m3845() > 0) {
            ((z3)this.getGraphicContext()).m817(((z3)this.getGraphicContext()).m3845() - 1);
            this._pdfDoc.m3855().m3871();
        }
    }

    private RectangleF transformRect(RectangleF rect) {
        if (((z3)this.getGraphicContext()).getTransformationMatrix() == null || ((z3)this.getGraphicContext()).getTransformationMatrix().isIdentity()) {
            return rect;
        }
        return PdfDevice.transformRect(((z3)this.getGraphicContext()).getTransformationMatrix(), rect.Clone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNavigation(Element element, int level, z30<Element, Boolean> isNavElement, z30<Element, String> getHRef, z30<Element, String> getTitle) {
        Object object;
        Object object2;
        if (element == null) {
            return;
        }
        if (isNavElement.invoke(element).booleanValue()) {
            ++level;
            object2 = getHRef.invoke(element);
            object = PdfDevice.trimBookmarksTitles(getTitle.invoke(element));
            if (!StringExtensions.isNullOrEmpty((String)object2) && !StringExtensions.isNullOrEmpty((String)object)) {
                Url url;
                String[] stringArray = StringExtensions.split((String)object2, new char[]{'#'}, (short)1);
                String string = StringExtensions.Empty;
                if (stringArray.length < 2) {
                    url = this._resolver.resolve(element.getBaseURI(), (String)object2);
                } else {
                    url = this._resolver.resolve(element.getBaseURI(), stringArray[0]);
                    string = stringArray.length == 2 ? stringArray[1] : StringExtensions.Empty;
                }
                boolean bl2 = false;
                IGenericEnumerator iGenericEnumerator = this._internalLinks.iterator();
                try {
                    while (iGenericEnumerator.hasNext()) {
                        z1 z1100 = (z1)iGenericEnumerator.next();
                        if (url.equals(z1100.m3841())) {
                            boolean bl3;
                            Object[] objectArray;
                            KeyValuePair keyValuePair;
                            IGenericEnumerator iGenericEnumerator2;
                            if (StringExtensions.isNullOrEmpty(string)) {
                                iGenericEnumerator2 = this._uriIdLocationMap.iterator();
                                try {
                                    while (iGenericEnumerator2.hasNext()) {
                                        keyValuePair = (KeyValuePair)iGenericEnumerator2.next();
                                        int n2 = 0;
                                        objectArray = new Integer[]{n2};
                                        bl3 = z1100.m3841().equals(this._resolver.resolve((String)keyValuePair.getKey(), "")) && this._uriPage.tryGetValue((String)keyValuePair.getKey(), objectArray);
                                        n2 = (Integer)objectArray[0];
                                        if (!bl3) continue;
                                        this._pdfDoc.m3823().m1((String)object, level, new z12((String)this._pdfDoc.m3822().m3875().get_Item(n2 - 1), new PointF(0.0f, this._pdfDoc.m3822().m3874().get_Item(n2 - 1).getHeight())));
                                        bl2 = true;
                                    }
                                }
                                finally {
                                    if (Operators.is(iGenericEnumerator2, IDisposable.class)) {
                                        ((IDisposable)iGenericEnumerator2).dispose();
                                    }
                                }
                            } else if (StringExtensions.equals(string, z1100.m3842())) {
                                iGenericEnumerator2 = this._uriIdLocationMap.iterator();
                                try {
                                    while (iGenericEnumerator2.hasNext()) {
                                        keyValuePair = (KeyValuePair)iGenericEnumerator2.next();
                                        Object object3 = null;
                                        objectArray = new z2[]{object3};
                                        bl3 = z1100.m3841().equals(this._resolver.resolve((String)keyValuePair.getKey(), "")) && ((Dictionary)keyValuePair.getValue()).tryGetValue(z1100.m3842(), objectArray);
                                        object3 = objectArray[0];
                                        if (!bl3) continue;
                                        this._pdfDoc.m3823().m1((String)object, level, new z12(((z2)object3).m3843(), ((z2)object3).getLocation().Clone()));
                                        bl2 = true;
                                        break;
                                    }
                                }
                                finally {
                                    if (Operators.is(iGenericEnumerator2, IDisposable.class)) {
                                        ((IDisposable)iGenericEnumerator2).dispose();
                                    }
                                }
                            }
                        }
                        if (!bl2) continue;
                        break;
                    }
                }
                finally {
                    if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                        ((IDisposable)iGenericEnumerator).dispose();
                    }
                }
            }
        }
        object2 = element.getChildren().iterator();
        try {
            while (object2.hasNext()) {
                object = (Element)object2.next();
                this.addNavigation((Element)object, level, isNavElement, getHRef, getTitle);
            }
        }
        finally {
            if (Operators.is(object2, IDisposable.class)) {
                ((IDisposable)object2).dispose();
            }
        }
    }

    private void registerBookmarks() {
        HTMLTemplateElement hTMLTemplateElement = Operators.as(this.getCurrentDocument().querySelector("head template"), HTMLTemplateElement.class);
        if (hTMLTemplateElement == null || hTMLTemplateElement.getContent().getFirstChild() == null) {
            return;
        }
        this.bookmarks = hTMLTemplateElement.getContent().getFirstChild();
    }

    private void addBookmarks() {
        if (this.bookmarks == null) {
            return;
        }
        if (StringExtensions.equals(this.bookmarks.getLocalName(), "ncx", (short)5)) {
            this.addNavigation(Operators.as(this.bookmarks, Element.class), 0, new z30<Element, Boolean>(){

                public Boolean m24(Element element) {
                    return StringExtensions.equals(element.getTagName(), "navPoint", (short)5);
                }

                @Override
                public /* synthetic */ Object invoke(Object object) {
                    return this.m24((Element)object);
                }
            }, new z30<Element, String>(){

                public String m57(Element element) {
                    Element element2 = PdfDevice.getFirstChildElement(element, "content");
                    return element2 != null ? element2.getAttribute("src") : null;
                }

                @Override
                public /* synthetic */ Object invoke(Object object) {
                    return this.m57((Element)object);
                }
            }, new z30<Element, String>(){

                public String m57(Element element) {
                    Element element2 = PdfDevice.getFirstChildElement(element, "navLabel");
                    return element2 != null ? element2.getTextContent() : null;
                }

                @Override
                public /* synthetic */ Object invoke(Object object) {
                    return this.m57((Element)object);
                }
            });
        } else {
            this.addNavigation(Operators.as(this.bookmarks, Element.class), 0, new z30<Element, Boolean>(){

                public Boolean m24(Element element) {
                    return Operators.is(element, HTMLLIElement.class);
                }

                @Override
                public /* synthetic */ Object invoke(Object object) {
                    return this.m24((Element)object);
                }
            }, new z30<Element, String>(){

                public String m57(Element element) {
                    Element element2 = PdfDevice.getFirstChildElement(element, "a");
                    return element2 != null ? ((HTMLAnchorElement)element2).getHref() : null;
                }

                @Override
                public /* synthetic */ Object invoke(Object object) {
                    return this.m57((Element)object);
                }
            }, new z30<Element, String>(){

                public String m57(Element element) {
                    Element element2 = PdfDevice.getFirstChildElement(element, "a");
                    return element2 != null ? element2.getTextContent() : null;
                }

                @Override
                public /* synthetic */ Object invoke(Object object) {
                    return this.m57((Element)object);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addInternalLinksDestinations() {
        IGenericEnumerator iGenericEnumerator = this._internalLinks.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                z1 z1100 = (z1)iGenericEnumerator.next();
                IGenericEnumerator iGenericEnumerator2 = this._uriIdLocationMap.iterator();
                try {
                    while (iGenericEnumerator2.hasNext()) {
                        KeyValuePair keyValuePair = (KeyValuePair)iGenericEnumerator2.next();
                        Object object = null;
                        int n2 = 0;
                        if (!z1100.m3841().equals(this._resolver.resolve((String)keyValuePair.getKey(), ""))) continue;
                        Object[] objectArray = new Integer[]{n2};
                        boolean bl2 = StringExtensions.isNullOrEmpty(z1100.m3842()) && this._uriPage.tryGetValue((String)keyValuePair.getKey(), objectArray);
                        n2 = objectArray[0];
                        if (bl2) {
                            z1100.m3840().m1(new com.aspose.html.internal.p211.z2(new z12((String)this._pdfDoc.m3822().m3875().get_Item(n2 - 1), new PointF(0.0f, this._pdfDoc.m3822().m3874().get_Item(n2 - 1).getHeight()))));
                            continue;
                        }
                        Object[] objectArray2 = new z2[]{object};
                        boolean bl3 = ((Dictionary)keyValuePair.getValue()).tryGetValue(z1100.m3842(), objectArray2);
                        object = objectArray2[0];
                        if (!bl3) continue;
                        z1100.m3840().m1(new com.aspose.html.internal.p211.z2(new z12(((z2)object).m3843(), ((z2)object).getLocation().Clone())));
                    }
                }
                finally {
                    if (!Operators.is(iGenericEnumerator2, IDisposable.class)) continue;
                    ((IDisposable)iGenericEnumerator2).dispose();
                }
            }
            return;
        }
        finally {
            if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    @Override
    protected Class<z3> getGraphicContextCalss() {
        return z3.class;
    }

    public static class z3
    extends GraphicContext
    implements Cloneable {
        private Color m15761 = Color.getBlack().Clone();
        private com.aspose.html.internal.p217.z3 m15762 = com.aspose.html.internal.p217.z3.m3945();
        private Color m15763 = Color.getBlack().Clone();
        private com.aspose.html.internal.p217.z3 m15764 = com.aspose.html.internal.p217.z3.m3945();
        private float m15765 = 1.0f;
        private float m15766 = 1.0f;
        private boolean m15767;
        private int m15768;
        private float m15769;
        private z24 m15770;
        private int m15771;
        private PdfDevice m15772;
        private boolean m15773;

        public PdfDevice m3844() {
            return this.m15772;
        }

        public void m1(PdfDevice pdfDevice) {
            this.m15772 = pdfDevice;
        }

        public int m3845() {
            return this.m15771;
        }

        public void m817(int n2) {
            this.m15771 = n2;
        }

        public boolean m3846() {
            return this.m15773;
        }

        public void m168(boolean bl2) {
            this.m15773 = bl2;
        }

        public z24 m3847() {
            return this.m15770;
        }

        public void m1(z24 z2410) {
            this.m15770 = z2410;
        }

        @Override
        public IBrush getFillBrush() {
            return super.getFillBrush();
        }

        @Override
        public void setFillBrush(IBrush value) {
            this.m3844().clearExtGraphicState();
            this.m15770.m3873().m1(value, false);
            super.setFillBrush(value);
        }

        @Override
        public int getLineCap() {
            return super.getLineCap();
        }

        @Override
        public void setLineCap(int value) {
            super.setLineCap(value);
            int n2 = 0;
            switch (value) {
                case 2: {
                    n2 = 1;
                    break;
                }
                case 1: {
                    n2 = 2;
                }
            }
            this.m15770.m3872().m61("{0} J", com.aspose.html.internal.p15.z11.m56(n2));
        }

        @Override
        public int getLineJoin() {
            return super.getLineJoin();
        }

        @Override
        public void setLineJoin(int value) {
            super.setLineJoin(value);
            int n2 = 0;
            switch (value) {
                case 2: {
                    n2 = 1;
                    break;
                }
                case 1: {
                    n2 = 2;
                }
            }
            this.m15770.m3872().m61("{0} j", com.aspose.html.internal.p15.z11.m56(n2));
        }

        @Override
        public float getLineWidth() {
            return super.getLineWidth();
        }

        @Override
        public void setLineWidth(float value) {
            super.setLineWidth(value);
            this.m15770.m3872().m61("{0} w", z38.m74(value));
        }

        @Override
        public float getMiterLimit() {
            return super.getMiterLimit();
        }

        @Override
        public void setMiterLimit(float value) {
            super.setMiterLimit(value);
            this.m15770.m3872().m61("{0} M", z38.m74(value));
        }

        @Override
        public IBrush getStrokeBrush() {
            return super.getStrokeBrush();
        }

        @Override
        public void setStrokeBrush(IBrush value) {
            this.m3844().clearExtGraphicState();
            this.m15770.m3873().m1(value, true);
            super.setStrokeBrush(value);
        }

        @Override
        public void transform(Matrix matrix) {
            float[] fArray = matrix.getElements();
            this.m15770.m3872().m1(new z11(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]), "cm");
            if (super.getTransformationMatrix() != null) {
                super.getTransformationMatrix().multiply(matrix);
            } else {
                super.setTransformationMatrix(matrix.deepClone());
            }
        }

        @Override
        public Matrix getTransformationMatrix() {
            return super.getTransformationMatrix();
        }

        @Override
        public void setTransformationMatrix(Matrix value) {
            if (this.m3846()) {
                super.setTransformationMatrix(value);
            } else if (super.getTransformationMatrix() != null && !super.getTransformationMatrix().isIdentity() && super.getTransformationMatrix().isInvertible()) {
                super.getTransformationMatrix().invert();
                float[] fArray = super.getTransformationMatrix().getElements();
                this.m15770.m3872().m1(new z11(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]), "cm");
                Matrix matrix = new Matrix(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, this.m15770.getHeight());
                matrix.multiply(value);
                fArray = matrix.getElements();
                this.m15770.m3872().m1(new z11(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]), "cm");
                super.setTransformationMatrix(matrix);
            }
        }

        @Override
        public GraphicContext deepClone() {
            z3 z3100 = (z3)this.memberwiseClone();
            if (this.getTransformationMatrix() != null) {
                z3100.setTransformationMatrix(this.getTransformationMatrix().deepClone());
            }
            this.m15771 = 0;
            return z3100;
        }

        public boolean m3848() {
            return this.m15765 < 1.0f || this.m15766 < 1.0f;
        }

        public float m3849() {
            return this.m15769;
        }

        public void m72(float f2) {
            this.m15769 = f2;
        }

        private void m1(z6 z6100) {
            this.m3844().setExtGraphicState();
            this.m15770.m3872().m61("/{0} gs", z6100.m3862());
        }

        public void m1(Color color, boolean bl2) {
            if (bl2) {
                if (this.m15762 == com.aspose.html.internal.p217.z3.m3946() && Color.op_Equality(color, this.m15761)) {
                    return;
                }
                this.m15762 = com.aspose.html.internal.p217.z3.m3946();
                color.CloneTo(this.m15761);
            } else {
                if (this.m15764 == com.aspose.html.internal.p217.z3.m3946() && Color.op_Equality(color, this.m15763)) {
                    return;
                }
                this.m15764 = com.aspose.html.internal.p217.z3.m3946();
                color.CloneTo(this.m15763);
            }
            if ((color.getA() & 0xFF) < 255) {
                z6 z6100 = this.m15770.m3854().m3832().m3876();
                float f2 = (float)(color.getA() & 0xFF) / 255.0f;
                if (bl2) {
                    this.m15765 = f2;
                } else {
                    this.m15766 = f2;
                }
                z6100.m76(this.m15766);
                z6100.m75(this.m15765);
                this.m1(z6100);
                this.m15767 = true;
            } else if (this.m3848()) {
                z6 z6101 = this.m15770.m3854().m3832().m3876();
                float f3 = 1.0f;
                if (bl2) {
                    this.m15765 = 1.0f;
                } else {
                    this.m15766 = 1.0f;
                }
                z6101.m76(this.m15766);
                z6101.m75(this.m15765);
                this.m1(z6101);
            }
            this.m15770.m3872().m17("{0} {1}", z38.m12(com.aspose.html.internal.p11.z4.m1(color.Clone())), bl2 ? "RG" : "rg");
        }

        public void m1(com.aspose.html.internal.p215.z2 z2100) {
            this.m15770.m3872().m17("/{0} {1} Tf", z2100.m3862(), z38.m74(this.getFontSize()));
        }

        public void m3850() {
            this.m15770.m3872().m61("{0} Tc", z38.m74(this.getCharacterSpacing()));
        }

        public void m818(int n2) {
            if (n2 == this.m15768) {
                return;
            }
            this.m15768 = n2;
            this.m15770.m3872().m61("{0} Tr", com.aspose.html.internal.p15.z11.m56(n2));
        }

        public void m73(float f2) {
            if (f2 == this.m15769) {
                return;
            }
            this.m15769 = f2;
            this.m15770.m3872().m61("{0} TL", z38.m74(f2));
        }

        public void m1(com.aspose.html.internal.p217.z3 z3100, boolean bl2) {
            if (bl2) {
                if (z3100 == this.m15762) {
                    return;
                }
                this.m15762 = z3100;
            } else {
                if (z3100 == this.m15764) {
                    return;
                }
                this.m15764 = z3100;
            }
            this.m15770.m3872().m17("/{0} {1}", z3100.getFullName(), bl2 ? "CS" : "cs");
        }

        @Override
        protected Object memberwiseClone() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }
    }

    private static class z1 {
        private final z5 m15756;
        private final Url m15757;
        private final String m15758;

        public z1(z5 z5100, Url url, String string) {
            this.m15756 = z5100;
            this.m15758 = string;
            this.m15757 = url;
        }

        public z5 m3840() {
            return this.m15756;
        }

        public Url m3841() {
            return this.m15757;
        }

        public String m3842() {
            return this.m15758;
        }
    }

    private static class z2 {
        private final String m15759;
        private final PointF m15760 = new PointF();

        public z2(String string, PointF pointF) {
            this.m15759 = string;
            pointF.CloneTo(this.m15760);
        }

        public String m3843() {
            return this.m15759;
        }

        public PointF getLocation() {
            return this.m15760;
        }
    }
}

