/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.IO;

import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.Char;
import com.aspose.html.utils.ms.System.Environment;
import com.aspose.html.utils.ms.System.Globalization.CultureInfo;
import com.aspose.html.utils.ms.System.IO.Directory;
import com.aspose.html.utils.ms.System.IO.IOException;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Text.msStringBuilder;
import com.aspose.html.utils.ms.core.SystemUtils;
import java.io.File;
import java.security.SecureRandom;

public final class Path {
    public static char[] InvalidPathChars;
    public static char AltDirectorySeparatorChar;
    public static char DirectorySeparatorChar;
    public static char PathSeparator;
    static String a;
    public static char VolumeSeparatorChar;
    static char[] b;
    private static boolean c;
    private static String d;

    private Path() {
    }

    public static String changeExtension(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (StringExtensions.indexOfAny(string, InvalidPathChars) != -1) {
            throw new ArgumentException("Illegal characters in path.");
        }
        int n2 = Path.e(string);
        if (string2 == null) {
            return n2 < 0 ? string : StringExtensions.substring(string, 0, n2);
        }
        if (string2.length() == 0) {
            return n2 < 0 ? StringExtensions.concat(string, Character.valueOf('.')) : StringExtensions.substring(string, 0, n2 + 1);
        }
        if (string.length() != 0) {
            if (string2.length() > 0 && string2.charAt(0) != '.') {
                string2 = StringExtensions.concat(".", string2);
            }
        } else {
            string2 = StringExtensions.Empty;
        }
        if (n2 < 0) {
            return StringExtensions.concat(string, string2);
        }
        if (n2 > 0) {
            String string3 = StringExtensions.substring(string, 0, n2);
            return StringExtensions.concat(string3, string2);
        }
        return string2;
    }

    public static String getFileName(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (StringExtensions.indexOfAny(string, InvalidPathChars) != -1) {
            throw new ArgumentException("Illegal characters in path.");
        }
        int n2 = StringExtensions.lastIndexOfAny(string, b);
        if (n2 >= 0) {
            return StringExtensions.substring(string, n2 + 1);
        }
        return string;
    }

    public static String getFileNameWithoutExtension(String string) {
        return Path.changeExtension(Path.getFileName(string), null);
    }

    public static String getFullPath(String string) {
        if (string == null) {
            throw new ArgumentNullException("path");
        }
        if (StringExtensions.trim(string).length() == 0) {
            String string2 = "The specified path is empty";
            throw new ArgumentException(string2);
        }
        if (Environment.IsRunningOnWindows) {
            string = Path.b(string);
        }
        char c2 = string.charAt(string.length() - 1);
        boolean bl2 = true;
        if (string.length() >= 2 && Path.a(string.charAt(0)) && Path.a(string.charAt(1))) {
            if (string.length() == 2 || StringExtensions.indexOf(string, string.charAt(0), 2) < 0) {
                throw new ArgumentException("UNC paths should be of the form \\\\server\\share.");
            }
            if (string.charAt(0) != DirectorySeparatorChar) {
                string = StringExtensions.replace(string, AltDirectorySeparatorChar, DirectorySeparatorChar);
            }
        } else if (!Path.isPathRooted(string)) {
            if (!Environment.IsRunningOnWindows) {
                int n2 = 0;
                while ((n2 = StringExtensions.indexOf(string, '.', n2)) != -1 && ++n2 != string.length() && string.charAt(n2) != DirectorySeparatorChar && string.charAt(n2) != AltDirectorySeparatorChar) {
                }
                bl2 = n2 > 0;
            }
            string = StringExtensions.concat(Directory.getCurrentDirectory(), a, string);
        } else if (DirectorySeparatorChar == '\\' && string.length() >= 1 && Path.a(string.charAt(0)) && (string.length() == 1 || !Path.a(string.charAt(1)))) {
            String string3 = Directory.getCurrentDirectory();
            string = string3.charAt(1) == VolumeSeparatorChar ? StringExtensions.concat(StringExtensions.substring(string3, 0, 2), string) : StringExtensions.substring(string3, 0, StringExtensions.indexOf(string3, '\\', StringExtensions.indexOf(string3, "\\\\") + 1));
        }
        if (bl2) {
            string = Path.c(string);
        }
        if (Path.a(c2) && string.charAt(string.length() - 1) != DirectorySeparatorChar) {
            string = StringExtensions.plusEqOperator(string, DirectorySeparatorChar);
        }
        return string;
    }

    public static String getPathRoot(String string) {
        int n2;
        if (string == null) {
            return null;
        }
        if (StringExtensions.trim(string).length() == 0) {
            throw new ArgumentException("The specified path is not of a legal form.");
        }
        if (!Path.isPathRooted(string)) {
            return StringExtensions.Empty;
        }
        if (DirectorySeparatorChar == '/') {
            return Path.a(string.charAt(0)) ? a : StringExtensions.Empty;
        }
        if (string.length() == 1 && Path.a(string.charAt(0))) {
            return a;
        }
        if (string.length() < 2) {
            return StringExtensions.Empty;
        }
        if (Path.a(string.charAt(0)) && Path.a(string.charAt(1))) {
            for (n2 = 2; n2 < string.length() && !Path.a(string.charAt(n2)); ++n2) {
            }
            if (n2 < string.length()) {
                ++n2;
                while (n2 < string.length() && !Path.a(string.charAt(n2))) {
                    ++n2;
                }
            }
            return StringExtensions.concat(a, a, StringExtensions.replace(StringExtensions.substring(string, 2, n2 - 2), AltDirectorySeparatorChar, DirectorySeparatorChar));
        }
        if (Path.a(string.charAt(0))) {
            return a;
        }
        if (string.charAt(1) == VolumeSeparatorChar) {
            if (string.length() >= 3 && Path.a(string.charAt(2))) {
                ++n2;
            }
        } else {
            return StringExtensions.substring(Directory.getCurrentDirectory(), 0, 2);
        }
        return StringExtensions.substring(string, 0, n2);
    }

    static boolean a(char c2) {
        return c2 == DirectorySeparatorChar || c2 == AltDirectorySeparatorChar;
    }

    public static String getExtension(String string) {
        if (string == null) {
            return null;
        }
        if (StringExtensions.indexOfAny(string, InvalidPathChars) != -1) {
            throw new ArgumentException("Illegal characters in path.");
        }
        int n2 = Path.e(string);
        if (n2 > -1 && n2 < string.length() - 1) {
            return StringExtensions.substring(string, n2);
        }
        return StringExtensions.Empty;
    }

    public static String getDirectoryName(String string) {
        if (StringExtensions.equals(string, StringExtensions.Empty)) {
            throw new ArgumentException("Invalid path");
        }
        if (string == null || StringExtensions.equals(Path.getPathRoot(string), string)) {
            return null;
        }
        if (StringExtensions.trim(string).length() == 0) {
            throw new ArgumentException("Argument string consists of whitespace characters only.");
        }
        if (StringExtensions.indexOfAny(string, InvalidPathChars) > -1) {
            throw new ArgumentException("Path contains invalid characters");
        }
        int n2 = StringExtensions.lastIndexOfAny(string, b);
        if (n2 == 0) {
            ++n2;
        }
        if (n2 > 0) {
            String string2 = StringExtensions.substring(string, 0, n2);
            int n3 = string2.length();
            if (n3 >= 2 && DirectorySeparatorChar == '\\' && string2.charAt(n3 - 1) == VolumeSeparatorChar) {
                return StringExtensions.concat(string2, Character.valueOf(DirectorySeparatorChar));
            }
            return Path.a(string2);
        }
        return StringExtensions.Empty;
    }

    public static String combine(String string, String string2) {
        if (string == null) {
            throw new ArgumentNullException("path1");
        }
        if (string2 == null) {
            throw new ArgumentNullException("path2");
        }
        if (string.length() == 0) {
            return string2;
        }
        if (string2.length() == 0) {
            return string;
        }
        if (StringExtensions.indexOfAny(string, InvalidPathChars) != -1) {
            throw new ArgumentException("Illegal characters in path.");
        }
        if (StringExtensions.indexOfAny(string2, InvalidPathChars) != -1) {
            throw new ArgumentException("Illegal characters in path.");
        }
        if (Path.isPathRooted(string2)) {
            return string2;
        }
        char c2 = string.charAt(string.length() - 1);
        if (c2 != DirectorySeparatorChar && c2 != AltDirectorySeparatorChar && c2 != VolumeSeparatorChar) {
            return StringExtensions.concat(string, a, string2);
        }
        return StringExtensions.concat(string, string2);
    }

    public static String getTempPath() {
        String string;
        if (d == null && (string = SystemUtils.getJavaIoTmpDir().getAbsolutePath()).length() > 0 && string.charAt(string.length() - 1) != DirectorySeparatorChar) {
            d = StringExtensions.concat(string, Character.valueOf(DirectorySeparatorChar));
        }
        return d;
    }

    public static void setTempPath(String string) {
        d = string;
        File file = new File(d);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static boolean hasExtension(String string) {
        if (string == null || StringExtensions.trim(string).length() == 0) {
            return false;
        }
        if (StringExtensions.indexOfAny(string, InvalidPathChars) != -1) {
            throw new ArgumentException("Illegal characters in path.");
        }
        int n2 = Path.e(string);
        return 0 <= n2 && n2 < string.length() - 1;
    }

    public static boolean isPathRooted(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (StringExtensions.indexOfAny(string, InvalidPathChars) != -1) {
            throw new ArgumentException("Illegal characters in path.");
        }
        char c2 = string.charAt(0);
        return c2 == DirectorySeparatorChar || c2 == AltDirectorySeparatorChar || !c && string.length() > 1 && string.charAt(1) == VolumeSeparatorChar;
    }

    public static String getRandomFileName() {
        msStringBuilder msStringBuilder2 = new msStringBuilder(12);
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[11];
        secureRandom.nextBytes(byArray);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2;
            if (msStringBuilder2.getLength() == 8) {
                msStringBuilder2.append('.');
            }
            char c2 = (char)((n2 = (byArray[i2] & 0xFF) % 36) < 26 ? n2 + 97 : n2 - 26 + 48);
            msStringBuilder2.append(c2);
        }
        return msStringBuilder2.toString();
    }

    public static char[] getInvalidFileNameChars() {
        if (Environment.IsRunningOnWindows) {
            return new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\"', '<', '>', '|', ':', '*', '?', '\\', '/'};
        }
        return new char[]{'\u0000', '/'};
    }

    public static char[] getInvalidPathChars() {
        if (Environment.IsRunningOnWindows) {
            return new char[]{'\"', '<', '>', '|', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f'};
        }
        return new char[]{'\u0000'};
    }

    public static String getTempFileName() {
        try {
            File file = File.createTempFile("temp", ".tmp", new File(Path.getTempPath()));
            file.deleteOnExit();
            return file.getPath();
        }
        catch (java.io.IOException iOException) {
            throw new IOException("exception", iOException);
        }
    }

    static String a(String string) {
        int n2;
        int n3 = string.length();
        int n4 = 0;
        int n5 = 0;
        char c2 = string.charAt(0);
        if (n3 > 2 && c2 == '\\' && string.charAt(1) == '\\') {
            n5 = 2;
        }
        if (n3 == 1 && (c2 == DirectorySeparatorChar || c2 == AltDirectorySeparatorChar)) {
            return string;
        }
        for (int i2 = n5; i2 < n3; ++i2) {
            n2 = string.charAt(i2);
            if (n2 != DirectorySeparatorChar && n2 != AltDirectorySeparatorChar) continue;
            if (i2 + 1 == n3) {
                ++n4;
                continue;
            }
            n2 = string.charAt(i2 + 1);
            if (n2 != DirectorySeparatorChar && n2 != AltDirectorySeparatorChar) continue;
            ++n4;
        }
        if (n4 == 0) {
            return string;
        }
        char[] cArray = new char[n3 - n4];
        if (n5 != 0) {
            cArray[0] = 92;
            cArray[1] = 92;
        }
        int n6 = n5;
        for (n2 = n5; n2 < n3 && n6 < cArray.length; ++n2) {
            char c3 = string.charAt(n2);
            if (c3 != DirectorySeparatorChar && c3 != AltDirectorySeparatorChar) {
                cArray[n6++] = c3;
                continue;
            }
            if (n6 + 1 == cArray.length) continue;
            cArray[n6++] = DirectorySeparatorChar;
            while (n2 < n3 - 1 && ((c3 = string.charAt(n2 + 1)) == DirectorySeparatorChar || c3 == AltDirectorySeparatorChar)) {
                ++n2;
            }
        }
        return StringExtensions.newString(cArray);
    }

    private static int e(String string) {
        int n2;
        int n3;
        if (string != null && (n3 = StringExtensions.lastIndexOf(string, '.')) > (n2 = StringExtensions.lastIndexOfAny(string, b))) {
            return n3;
        }
        return -1;
    }

    static String b(String string) {
        if (string.length() < 2) {
            return string;
        }
        if (string.charAt(1) != ':' || !Char.isLetter(string.charAt(0))) {
            return string;
        }
        String string2 = Directory.getCurrentDirectory();
        if (string.length() == 2) {
            string = string2.charAt(0) == string.charAt(0) ? string2 : StringExtensions.plusEqOperator(string, '\\');
        } else if (string.charAt(2) != DirectorySeparatorChar && string.charAt(2) != AltDirectorySeparatorChar) {
            string = string2.charAt(0) == string.charAt(0) ? Path.combine(string2, StringExtensions.substring(string, 2, string.length() - 2)) : StringExtensions.concat(StringExtensions.substring(string, 0, 2), a, StringExtensions.substring(string, 2, string.length() - 2));
        }
        return string;
    }

    static String c(String string) {
        if (string == null) {
            return string;
        }
        if (Environment.IsRunningOnWindows) {
            string = StringExtensions.trim(string);
        }
        if (string.length() == 0) {
            return string;
        }
        String string2 = Path.getPathRoot(string);
        String[] stringArray = StringExtensions.split(string, DirectorySeparatorChar, AltDirectorySeparatorChar);
        int n2 = 0;
        boolean bl2 = Environment.IsRunningOnWindows && string2.length() > 2 && Path.a(string2.charAt(0)) && Path.a(string2.charAt(1));
        int n3 = bl2 ? 3 : 0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (Environment.IsRunningOnWindows) {
                stringArray[i2] = StringExtensions.trimEnd(stringArray[i2], new char[0]);
            }
            if (".".equals(stringArray[i2]) || i2 != 0 && stringArray[i2].length() == 0) continue;
            if ("..".equals(stringArray[i2])) {
                if (n2 <= n3) continue;
                --n2;
                continue;
            }
            stringArray[n2++] = stringArray[i2];
        }
        if (n2 == 0 || n2 == 1 && "".equals(stringArray[0])) {
            return string2;
        }
        String string3 = StringExtensions.join(a, stringArray, 0, n2);
        if (Environment.IsRunningOnWindows) {
            if (bl2) {
                string3 = StringExtensions.concat(a, string3);
            }
            if (!Path.a(string2, string3)) {
                string3 = StringExtensions.concat(string2, string3);
            }
            if (bl2) {
                return string3;
            }
            if (!Path.a(string.charAt(0)) && Path.a(string2, string)) {
                if (string3.length() <= 2 && !StringExtensions.endsWith(string3, a)) {
                    string3 = StringExtensions.plusEqOperator(string3, DirectorySeparatorChar);
                }
                return string3;
            }
            String string4 = Directory.getCurrentDirectory();
            if (string4.length() > 1 && string4.charAt(1) == VolumeSeparatorChar) {
                if (string3.length() == 0 || Path.a(string3.charAt(0))) {
                    string3 = StringExtensions.plusEqOperator(string3, '\\');
                }
                return StringExtensions.concat(StringExtensions.substring(string4, 0, 2), string3);
            }
            if (Path.a(string4.charAt(string4.length() - 1)) && Path.a(string3.charAt(0))) {
                return StringExtensions.concat(string4, StringExtensions.substring(string3, 1));
            }
            return StringExtensions.concat(string4, string3);
        }
        return string3;
    }

    static boolean a(String string, String string2) {
        if (string.length() < 2 || string2.length() < 2) {
            return false;
        }
        if (Path.a(string.charAt(0)) && Path.a(string.charAt(1))) {
            String string3;
            if (!Path.a(string2.charAt(0)) || !Path.a(string2.charAt(1))) {
                return false;
            }
            String string4 = Path.d(string);
            return StringExtensions.compare(string4, string3 = Path.d(string2), true, CultureInfo.getInvariantCulture()) == 0;
        }
        if (!Char.equals(string.charAt(0), string2.charAt(0))) {
            return false;
        }
        if (string2.charAt(1) != VolumeSeparatorChar) {
            return false;
        }
        if (string.length() > 2 && string2.length() > 2) {
            return Path.a(string.charAt(2)) && Path.a(string2.charAt(2));
        }
        return true;
    }

    static String d(String string) {
        int n2;
        for (n2 = 2; n2 < string.length() && !Path.a(string.charAt(n2)); ++n2) {
        }
        if (n2 < string.length()) {
            ++n2;
            while (n2 < string.length() && !Path.a(string.charAt(n2))) {
                ++n2;
            }
        }
        return StringExtensions.replace(StringExtensions.substring(string, 2, n2 - 2), AltDirectorySeparatorChar, DirectorySeparatorChar);
    }

    static {
        DirectorySeparatorChar = (char)(Environment.IsRunningOnWindows ? 92 : 47);
        AltDirectorySeparatorChar = (char)(Environment.IsRunningOnWindows ? 47 : 92);
        VolumeSeparatorChar = (char)(Environment.IsRunningOnWindows ? 58 : 47);
        PathSeparator = (char)(Environment.IsRunningOnWindows ? 59 : 59);
        InvalidPathChars = Path.getInvalidPathChars();
        a = Char.toString(DirectorySeparatorChar);
        b = new char[]{DirectorySeparatorChar, AltDirectorySeparatorChar, VolumeSeparatorChar};
        c = DirectorySeparatorChar == VolumeSeparatorChar;
    }
}

