/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Net;

import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.EnumExtensions;
import com.aspose.html.utils.ms.System.Int32Extensions;
import com.aspose.html.utils.ms.System.Net.Sockets.AddressFamily;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.lang.Operators;

public class SocketAddress {
    private byte[] a;

    public SocketAddress(int n2, int n3) {
        if (n3 < 2) {
            throw new ArgumentOutOfRangeException("size is too small");
        }
        this.a = new byte[n3];
        this.a[0] = (byte)n2;
        this.a[1] = Operators.castToByte(n2 >> 8, 9);
    }

    public SocketAddress(int n2) {
        this(n2, 32);
    }

    public int getFamily() {
        return Operators.castToInt32(this.a[0], 6) + (Operators.castToInt32(this.a[1], 6) << 8);
    }

    public int getSize() {
        return Array.boxing(this.a).getLength();
    }

    public byte get_Item(int n2) {
        return this.a[n2];
    }

    public void set_Item(int n2, byte by2) {
        this.a[n2] = by2;
    }

    public String toString() {
        String string = EnumExtensions.toString(AddressFamily.class, Operators.castToInt32(this.a[0], 6));
        int n2 = Array.boxing(this.a).getLength();
        String string2 = StringExtensions.concat(string, ":", Int32Extensions.toString(n2), ":{");
        for (int i2 = 2; i2 < n2; ++i2) {
            int n3 = Operators.castToInt32(this.a[i2], 6);
            string2 = StringExtensions.concat(string2, Int32Extensions.toString(n3));
            if (i2 >= n2 - 1) continue;
            string2 = StringExtensions.concat(string2, ",");
        }
        string2 = StringExtensions.concat(string2, "}");
        return string2;
    }

    public boolean equals(Object object) {
        SocketAddress socketAddress = Operators.as(object, SocketAddress.class);
        if (socketAddress != null && Array.boxing(socketAddress.a).getLength() == Array.boxing(this.a).getLength()) {
            byte[] byArray = socketAddress.a;
            for (int i2 = 0; i2 < Array.boxing(this.a).getLength(); ++i2) {
                if (Operators.castToInt32(byArray[i2], 6) == Operators.castToInt32(this.a[i2], 6)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n2 = 0;
        for (int i2 = 0; i2 < Array.boxing(this.a).getLength(); ++i2) {
            n2 += Operators.castToInt32(this.a[i2], 6) + i2;
        }
        return n2;
    }
}

