/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Security.Cryptography.Pkcs;

import com.aspose.html.NotImplementedException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.ByteExtensions;
import com.aspose.html.utils.ms.System.InvalidOperationException;
import com.aspose.html.utils.ms.System.NotSupportedException;
import com.aspose.html.utils.ms.System.Security.Cryptography.CryptoConfig;
import com.aspose.html.utils.ms.System.Security.Cryptography.CryptographicAttributeObjectCollection;
import com.aspose.html.utils.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.utils.ms.System.Security.Cryptography.Oid;
import com.aspose.html.utils.ms.System.Security.Cryptography.Pkcs.AlgorithmIdentifier;
import com.aspose.html.utils.ms.System.Security.Cryptography.Pkcs.CmsRecipient;
import com.aspose.html.utils.ms.System.Security.Cryptography.Pkcs.CmsRecipientCollection;
import com.aspose.html.utils.ms.System.Security.Cryptography.Pkcs.ContentInfo;
import com.aspose.html.utils.ms.System.Security.Cryptography.Pkcs.KeyTransRecipientInfo;
import com.aspose.html.utils.ms.System.Security.Cryptography.Pkcs.RecipientInfo;
import com.aspose.html.utils.ms.System.Security.Cryptography.Pkcs.RecipientInfoCollection;
import com.aspose.html.utils.ms.System.Security.Cryptography.Pkcs.SubjectIdentifier;
import com.aspose.html.utils.ms.System.Security.Cryptography.SHA1;
import com.aspose.html.utils.ms.System.Security.Cryptography.X509Certificates.X509Certificate2;
import com.aspose.html.utils.ms.System.Security.Cryptography.X509Certificates.X509Certificate2Collection;
import com.aspose.html.utils.ms.System.Security.Cryptography.X509Certificates.X509Store;
import com.aspose.html.utils.ms.System.Security.Cryptography.Xml.X509IssuerSerial;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Text.msStringBuilder;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.ASN1;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates.X509Certificate;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates.X509Extension;
import com.aspose.html.utils.ms.core.bc.asn1.ASN1Integer;
import com.aspose.html.utils.ms.core.bc.asn1.ASN1Null;
import com.aspose.html.utils.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.utils.ms.core.bc.asn1.ASN1OctetString;
import com.aspose.html.utils.ms.core.bc.asn1.ASN1Set;
import com.aspose.html.utils.ms.core.bc.asn1.cms.EnvelopedData;
import com.aspose.html.utils.ms.core.bc.asn1.cms.IssuerAndSerialNumber;
import com.aspose.html.utils.ms.core.bc.asn1.cms.RecipientIdentifier;
import com.aspose.html.utils.ms.core.bc.asn1.x500.X500Name;
import com.aspose.html.utils.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.utils.ms.core.bc.cert.jcajce.JcaX509CertificateConverter;
import com.aspose.html.utils.ms.core.bc.cms.CMSEnvelopedData;
import com.aspose.html.utils.ms.core.bc.cms.CMSEnvelopedDataGenerator;
import com.aspose.html.utils.ms.core.bc.cms.CMSException;
import com.aspose.html.utils.ms.core.bc.cms.CMSProcessableByteArray;
import com.aspose.html.utils.ms.core.bc.cms.KeyTransRecipientId;
import com.aspose.html.utils.ms.core.bc.cms.RecipientInformation;
import com.aspose.html.utils.ms.core.bc.cms.jcajce.JceCMSContentEncryptorBuilder;
import com.aspose.html.utils.ms.core.bc.cms.jcajce.JceKeyTransEnvelopedRecipient;
import com.aspose.html.utils.ms.core.bc.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import com.aspose.html.utils.ms.core.bc.operator.OutputEncryptor;
import com.aspose.html.utils.ms.core.bc.security.a;
import com.aspose.html.utils.ms.core.bc.util.encoders.Hex;
import com.aspose.html.utils.ms.lang.Operators;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.SecureRandom;

public final class EnvelopedCms {
    private ContentInfo a;
    private AlgorithmIdentifier b;
    private X509Certificate2Collection c;
    private RecipientInfoCollection d;
    private CryptographicAttributeObjectCollection e;
    private int f;
    private int g;
    private X509Store h = new X509Store(5, 1);
    private CMSEnvelopedData i;
    private CMSEnvelopedDataGenerator j;

    public EnvelopedCms() {
        this(1, new ContentInfo(new Oid("1.2.840.113549.1.7.1"), new byte[0]), new AlgorithmIdentifier(new Oid("1.2.840.113549.3.7")));
    }

    public EnvelopedCms(ContentInfo contentInfo) {
        this(1, contentInfo, new AlgorithmIdentifier(new Oid("1.2.840.113549.3.7")));
    }

    public EnvelopedCms(ContentInfo contentInfo, AlgorithmIdentifier algorithmIdentifier) {
        this(1, contentInfo, algorithmIdentifier);
    }

    public EnvelopedCms(int n2, ContentInfo contentInfo) {
        this(n2, contentInfo, new AlgorithmIdentifier(new Oid("1.2.840.113549.3.7")));
    }

    public EnvelopedCms(int n2, ContentInfo contentInfo, AlgorithmIdentifier algorithmIdentifier) {
        if (contentInfo == null) {
            throw new ArgumentNullException("contentInfo");
        }
        if (contentInfo.getContent() == null) {
            throw new ArgumentNullException("contentInfo.Content");
        }
        if (algorithmIdentifier == null) {
            throw new ArgumentNullException("encryptionAlgorithm");
        }
        this.g = n2 == 2 ? 2 : 0;
        this.f = n2;
        this.a = contentInfo;
        this.b = algorithmIdentifier;
        this.b.setParameters(new byte[0]);
        this.c = new X509Certificate2Collection();
        this.e = new CryptographicAttributeObjectCollection();
        this.d = new RecipientInfoCollection();
        this.j = new CMSEnvelopedDataGenerator();
    }

    public X509Certificate2Collection getCertificates() {
        return this.c;
    }

    public AlgorithmIdentifier getContentEncryptionAlgorithm() {
        if (this.b == null) {
            this.b = new AlgorithmIdentifier();
        }
        return this.b;
    }

    public ContentInfo getContentInfo() {
        if (this.a == null) {
            Oid oid = new Oid("1.2.840.113549.1.7.1");
            this.a = new ContentInfo(oid, new byte[0]);
        }
        return this.a;
    }

    public RecipientInfoCollection getRecipientInfos() {
        return this.d;
    }

    public CryptographicAttributeObjectCollection getUnprotectedAttributes() {
        return this.e;
    }

    public int getVersion() {
        return this.g;
    }

    private X509IssuerSerial a(String string, byte[] byArray) {
        X509IssuerSerial x509IssuerSerial = new X509IssuerSerial();
        x509IssuerSerial.setIssuerName(string);
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        for (byte by2 : byArray) {
            msStringBuilder2.append(ByteExtensions.toString(by2, "X2"));
        }
        x509IssuerSerial.setSerialNumber(msStringBuilder2.toString());
        return x509IssuerSerial;
    }

    public void decode(byte[] byArray) {
        if (byArray == null) {
            throw new ArgumentNullException("encodedMessage");
        }
        try {
            this.i = new CMSEnvelopedData(byArray);
            EnvelopedData envelopedData = EnvelopedData.getInstance(this.i.toASN1Structure().getContent());
            this.a = new ContentInfo(new Oid(envelopedData.getEncryptedContentInfo().getContentType().getId()), envelopedData.getEncryptedContentInfo().getEncryptedContent().getOctets());
            this.b.setParameters(this.i.getContentEncryptionAlgorithm().getParameters().toASN1Primitive().getEncoded());
            ASN1Set aSN1Set = envelopedData.getRecipientInfos();
            for (int i2 = 0; i2 != aSN1Set.size(); ++i2) {
                Object object;
                com.aspose.html.utils.ms.core.bc.asn1.cms.RecipientInfo recipientInfo = com.aspose.html.utils.ms.core.bc.asn1.cms.RecipientInfo.getInstance(aSN1Set.getObjectAt(i2));
                if (!Operators.is(recipientInfo.getInfo(), com.aspose.html.utils.ms.core.bc.asn1.cms.KeyTransRecipientInfo.class)) continue;
                int n2 = recipientInfo.getVersion().getValue().intValue();
                com.aspose.html.utils.ms.core.bc.asn1.cms.KeyTransRecipientInfo keyTransRecipientInfo = (com.aspose.html.utils.ms.core.bc.asn1.cms.KeyTransRecipientInfo)recipientInfo.getInfo();
                byte[] byArray2 = keyTransRecipientInfo.getEncryptedKey().getOctets();
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(new Oid(keyTransRecipientInfo.getKeyEncryptionAlgorithm().getAlgorithm().getId()));
                if (!Operators.is(keyTransRecipientInfo.getKeyEncryptionAlgorithm().getParameters(), ASN1Null.class)) {
                    algorithmIdentifier.setParameters(keyTransRecipientInfo.getKeyEncryptionAlgorithm().getParameters().toASN1Primitive().getEncoded());
                }
                RecipientIdentifier recipientIdentifier = keyTransRecipientInfo.getRecipientIdentifier();
                SubjectIdentifier subjectIdentifier = null;
                if (Operators.is(recipientIdentifier.getId(), IssuerAndSerialNumber.class)) {
                    object = ((IssuerAndSerialNumber)recipientIdentifier.getId()).getName();
                    ASN1Integer aSN1Integer = ((IssuerAndSerialNumber)recipientIdentifier.getId()).getSerialNumber();
                    X509IssuerSerial x509IssuerSerial = this.a(((X500Name)object).toString(), aSN1Integer.getValue().toByteArray()).Clone();
                    subjectIdentifier = new SubjectIdentifier(1, Operators.boxing(x509IssuerSerial));
                } else {
                    subjectIdentifier = new SubjectIdentifier(2, StringExtensions.toUpper(Hex.toHexString(((ASN1OctetString)recipientIdentifier.getId()).getOctets())));
                    n2 = 2;
                }
                object = new KeyTransRecipientInfo(byArray2, algorithmIdentifier, subjectIdentifier, n2);
                this.d.add((RecipientInfo)object);
            }
            this.e = com.aspose.html.utils.ms.core.bc.security.a.a(this.i.getUnprotectedAttributes());
            this.g = 0;
        }
        catch (Exception exception) {
            throw new CryptographicException(exception.getMessage());
        }
    }

    public void doDecrypt(RecipientInfo recipientInfo, X509Certificate2Collection x509Certificate2Collection) {
        if (this.i == null) {
            throw new InvalidOperationException("EnvelopedCms.Decode should be called before EnvelopedCms.Decrypt() or any other Decrypt method.");
        }
        RecipientInformation recipientInformation = null;
        X509Certificate2 x509Certificate2 = null;
        try {
            this.h.open(1);
            if (x509Certificate2Collection != null) {
                this.h.addRange(x509Certificate2Collection);
            }
            if (this.h.getCertificates().size() == 0) {
                throw new CryptographicException("Certificate's Store are empty!");
            }
            this.h.close();
            for (RecipientInformation recipientInformation2 : this.i.getRecipientInfos().getRecipients()) {
                if (!(recipientInformation2.getRID() instanceof KeyTransRecipientId)) {
                    throw new NotImplementedException("Find Certificate");
                }
                KeyTransRecipientId keyTransRecipientId = (KeyTransRecipientId)recipientInformation2.getRID();
                if (recipientInfo != null) {
                    if (recipientInfo.getRecipientIdentifier().getType() == 1) {
                        if (!StringExtensions.equals(Operators.unboxing(recipientInfo.getRecipientIdentifier().getValue(), X509IssuerSerial.class).getIssuerName(), keyTransRecipientId.getIssuer().toString()) || !StringExtensions.equals(StringExtensions.toUpper(Operators.unboxing(recipientInfo.getRecipientIdentifier().getValue(), X509IssuerSerial.class).getSerialNumber()), StringExtensions.toUpper(Hex.toHexString(keyTransRecipientId.getSerialNumber().toByteArray())))) continue;
                        recipientInformation = recipientInformation2;
                    } else {
                        if (recipientInfo.getRecipientIdentifier().getValue() != keyTransRecipientId.getSubjectKeyIdentifier()) continue;
                        recipientInformation = recipientInformation2;
                    }
                    x509Certificate2 = this.a(recipientInformation2);
                    if (x509Certificate2 != null) {
                        this.a = this.a(recipientInformation, x509Certificate2);
                    }
                    return;
                }
                recipientInformation = recipientInformation2;
                x509Certificate2 = this.a(recipientInformation2);
                if (x509Certificate2 == null) continue;
                this.a = this.a(recipientInformation, x509Certificate2);
                return;
            }
        }
        catch (RuntimeException runtimeException) {
            throw new CryptographicException(runtimeException.getMessage());
        }
        catch (CMSException cMSException) {
            throw new CryptographicException(cMSException.getMessage());
        }
        throw new CryptographicException("Appropriate certificate was not found");
    }

    private ContentInfo a(RecipientInformation recipientInformation, X509Certificate2 x509Certificate2) throws CMSException {
        PrivateKey privateKey = com.aspose.html.utils.ms.core.bc.security.a.a(x509Certificate2.getPrivateKey()).getPrivate();
        return new ContentInfo(recipientInformation.getContent(new JceKeyTransEnvelopedRecipient(privateKey)));
    }

    private X509Certificate2 a(RecipientInformation recipientInformation) {
        X509Certificate2 x509Certificate2 = null;
        this.h.open(0);
        if (!(recipientInformation.getRID() instanceof KeyTransRecipientId)) {
            throw new NotImplementedException("Find Certificate");
        }
        KeyTransRecipientId keyTransRecipientId = (KeyTransRecipientId)recipientInformation.getRID();
        if (keyTransRecipientId.getSerialNumber() != null && keyTransRecipientId.getIssuer() != null) {
            for (X509Certificate2 x509Certificate22 : this.h.getCertificates()) {
                if (!X500Name.getInstance(x509Certificate22.getInternalCertificate().getIssuerName().getBytes()).equals(X500Name.getInstance(keyTransRecipientId.getIssuer())) || !StringExtensions.equals(StringExtensions.toUpper(x509Certificate22.get_SerialNumber()), StringExtensions.toUpper(Hex.toHexString(keyTransRecipientId.getSerialNumber().toByteArray())))) continue;
                x509Certificate2 = x509Certificate22;
                break;
            }
        } else {
            byte[] byArray = keyTransRecipientId.getSubjectKeyIdentifier();
            for (X509Certificate2 x509Certificate23 : this.h.getCertificates()) {
                byte[] byArray2 = EnvelopedCms.a(x509Certificate23.getInternalCertificate());
                if ((byArray.length != byArray2.length || !EnvelopedCms.a(byArray, 0, byArray2, 0, byArray2.length)) && (byArray.length - 2 != byArray2.length || !EnvelopedCms.a(byArray, 2, byArray2, 0, byArray2.length))) continue;
                x509Certificate2 = x509Certificate23;
                break;
            }
        }
        this.h.close();
        return x509Certificate2;
    }

    public void decrypt() {
        this.doDecrypt(null, null);
    }

    private static boolean a(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            if (byArray[n2 + i2] == byArray2[n3 + i2]) continue;
            return false;
        }
        return true;
    }

    private static byte[] a(X509Certificate x509Certificate) {
        X509Extension x509Extension = x509Certificate.getExtensions().get_Item("2.5.29.14");
        if (x509Extension != null) {
            ASN1 aSN1 = new ASN1(x509Extension.getValue().getValue());
            return aSN1.getValue();
        }
        ASN1 aSN1 = new ASN1(48);
        ASN1 aSN12 = aSN1.add(new ASN1(48));
        aSN12.add(new ASN1(CryptoConfig.encodeOID(x509Certificate.getKeyAlgorithm())));
        aSN12.add(new ASN1(x509Certificate.getKeyAlgorithmParameters()));
        byte[] byArray = x509Certificate.getPublicKey();
        byte[] byArray2 = new byte[byArray.length + 1];
        Array.copy(Array.boxing(byArray), 0, Array.boxing(byArray2), 1, byArray.length);
        aSN1.add(new ASN1(3, byArray2));
        SHA1 sHA1 = SHA1.create();
        return sHA1.computeHash(aSN1.getBytes());
    }

    public void decrypt(RecipientInfo recipientInfo) {
        if (recipientInfo == null) {
            throw new ArgumentNullException("recipientInfo");
        }
        this.doDecrypt(recipientInfo, null);
    }

    public void decrypt(RecipientInfo recipientInfo, X509Certificate2Collection x509Certificate2Collection) {
        if (recipientInfo == null) {
            throw new ArgumentNullException("recipientInfo");
        }
        if (x509Certificate2Collection == null) {
            throw new ArgumentNullException("extraStore");
        }
        this.doDecrypt(recipientInfo, x509Certificate2Collection);
    }

    public void decrypt(X509Certificate2Collection x509Certificate2Collection) {
        if (x509Certificate2Collection == null) {
            throw new ArgumentNullException("extraStore");
        }
        this.doDecrypt(null, x509Certificate2Collection);
    }

    public byte[] encode() {
        if (this.i == null) {
            throw new InvalidOperationException("The CMS message is not encrypted.");
        }
        try {
            return this.a.getContent();
        }
        catch (RuntimeException runtimeException) {
            throw new CryptographicException(runtimeException.getMessage());
        }
    }

    public void encrypt() {
        if (this.a == null || this.a.getContent() == null || this.a.getContent().length == 0) {
            throw new CryptographicException("no content to encrypt");
        }
        throw new NotSupportedException("This requires that the current process is running in user interactive mode. Try to use Encrypt(CmsRecipient) method.");
    }

    public void encrypt(CmsRecipient cmsRecipient) {
        if (cmsRecipient == null) {
            throw new ArgumentNullException("recipient");
        }
        try {
            X509CertificateHolder x509CertificateHolder = com.aspose.html.utils.ms.core.bc.security.a.a(cmsRecipient.getCertificate());
            this.j.addRecipientInfoGenerator(new JceKeyTransRecipientInfoGenerator(new JcaX509CertificateConverter().getCertificate(x509CertificateHolder)));
            this.a();
        }
        catch (Exception exception) {
            throw new CryptographicException(exception.getMessage());
        }
    }

    public void encrypt(CmsRecipientCollection cmsRecipientCollection) {
        if (cmsRecipientCollection == null) {
            throw new ArgumentNullException("recipients");
        }
        try {
            for (CmsRecipient cmsRecipient : cmsRecipientCollection) {
                X509CertificateHolder x509CertificateHolder = com.aspose.html.utils.ms.core.bc.security.a.a(cmsRecipient.getCertificate());
                this.j.addRecipientInfoGenerator(new JceKeyTransRecipientInfoGenerator(new JcaX509CertificateConverter().getCertificate(x509CertificateHolder)));
            }
            this.a();
        }
        catch (Exception exception) {
            throw new CryptographicException(exception.getMessage());
        }
    }

    private void a() {
        if (this.a == null || this.a.getContent() == null || this.a.getContent().length == 0) {
            throw new CryptographicException("no content to encrypt");
        }
        CMSProcessableByteArray cMSProcessableByteArray = new CMSProcessableByteArray(this.a.getContent());
        try {
            JceCMSContentEncryptorBuilder jceCMSContentEncryptorBuilder = new JceCMSContentEncryptorBuilder(new ASN1ObjectIdentifier(this.b.getOid().getValue()));
            jceCMSContentEncryptorBuilder.setSecureRandom(new SecureRandom());
            OutputEncryptor outputEncryptor = jceCMSContentEncryptorBuilder.build();
            this.i = this.j.generate(cMSProcessableByteArray, outputEncryptor);
            this.a = new ContentInfo(this.i.getEncoded());
        }
        catch (IOException iOException) {
            throw new CryptographicException(iOException.getMessage());
        }
        catch (CMSException cMSException) {
            throw new CryptographicException(cMSException.getMessage());
        }
    }
}

