/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.System.Xml;

import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.ArgumentNullException;
import com.aspose.html.utils.ms.System.Array;
import com.aspose.html.utils.ms.System.Collections.ArrayList;
import com.aspose.html.utils.ms.System.Collections.IEnumerable;
import com.aspose.html.utils.ms.System.Collections.IEnumerator;
import com.aspose.html.utils.ms.System.Globalization.CultureInfo;
import com.aspose.html.utils.ms.System.ICloneable;
import com.aspose.html.utils.ms.System.IO.StringWriter;
import com.aspose.html.utils.ms.System.InvalidOperationException;
import com.aspose.html.utils.ms.System.NullReferenceException;
import com.aspose.html.utils.ms.System.ObjectExtensions;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.Text.msStringBuilder;
import com.aspose.html.utils.ms.System.Xml.IHasXmlChildNode;
import com.aspose.html.utils.ms.System.Xml.IHasXmlNode;
import com.aspose.html.utils.ms.System.Xml.IXPathNavigable;
import com.aspose.html.utils.ms.System.Xml.IXmlSchemaInfo;
import com.aspose.html.utils.ms.System.Xml.XPathExpression;
import com.aspose.html.utils.ms.System.Xml.XPathNavigator;
import com.aspose.html.utils.ms.System.Xml.XPathNodeIterator;
import com.aspose.html.utils.ms.System.Xml.XmlAttribute;
import com.aspose.html.utils.ms.System.Xml.XmlAttributeCollection;
import com.aspose.html.utils.ms.System.Xml.XmlDocument;
import com.aspose.html.utils.ms.System.Xml.XmlDocumentFragment;
import com.aspose.html.utils.ms.System.Xml.XmlDomTextWriter;
import com.aspose.html.utils.ms.System.Xml.XmlElement;
import com.aspose.html.utils.ms.System.Xml.XmlEntityReference;
import com.aspose.html.utils.ms.System.Xml.XmlException;
import com.aspose.html.utils.ms.System.Xml.XmlIteratorNodeList;
import com.aspose.html.utils.ms.System.Xml.XmlLinkedNode;
import com.aspose.html.utils.ms.System.Xml.XmlNamespaceManager;
import com.aspose.html.utils.ms.System.Xml.XmlNodeList;
import com.aspose.html.utils.ms.System.Xml.XmlNodeListChildren;
import com.aspose.html.utils.ms.System.Xml.XmlWriter;
import com.aspose.html.utils.ms.lang.StringSwitchMap;

public abstract class XmlNode
implements IEnumerable,
ICloneable,
IXPathNavigable {
    static EmptyNodeList emptyList = new EmptyNodeList();
    private XmlDocument a;
    private XmlNode b;
    private XmlNodeListChildren c;
    private static final StringSwitchMap d = new StringSwitchMap("preserve", "default", "xml", "xmlns", "http://www.w3.org/XML/1998/namespace", "http://www.w3.org/2000/xmlns/");

    XmlNode(XmlDocument xmlDocument) {
        this.a = xmlDocument;
    }

    public XmlAttributeCollection getAttributes() {
        return null;
    }

    public String getBaseURI() {
        return this.getParentNode() != null ? this.getParentNode().getChildrenBaseURI() : StringExtensions.Empty;
    }

    String getChildrenBaseURI() {
        return this.getBaseURI();
    }

    public XmlNodeList getChildNodes() {
        if (!(this instanceof IHasXmlChildNode)) {
            return emptyList;
        }
        if (this.c == null) {
            this.c = new XmlNodeListChildren((IHasXmlChildNode)((Object)this));
        }
        return this.c;
    }

    public XmlNode getFirstChild() {
        XmlLinkedNode xmlLinkedNode = this instanceof IHasXmlChildNode ? ((IHasXmlChildNode)((Object)this)).getLastLinkedChild() : null;
        return xmlLinkedNode != null ? xmlLinkedNode.getNextLinkedSibling() : null;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    public String getInnerText() {
        switch (this.getNodeType()) {
            case 3: 
            case 4: 
            case 13: 
            case 14: {
                return this.getValue();
            }
        }
        if (this.getFirstChild() == null) {
            return StringExtensions.Empty;
        }
        if (this.getFirstChild() == this.getLastChild()) {
            return this.getFirstChild().getNodeType() != 8 && this.getFirstChild().getNodeType() != 7 ? this.getFirstChild().getInnerText() : StringExtensions.Empty;
        }
        msStringBuilder msStringBuilder2 = null;
        msStringBuilder[] msStringBuilderArray = new msStringBuilder[]{msStringBuilder2};
        this.a(msStringBuilderArray);
        msStringBuilder2 = msStringBuilderArray[0];
        return msStringBuilder2 == null ? StringExtensions.Empty : msStringBuilder2.toString();
    }

    public void setInnerText(String string) {
        if (!(this instanceof XmlDocumentFragment)) {
            throw new InvalidOperationException("This node is read only. Cannot be modified.");
        }
        this.removeAll();
        this.appendChild(this.getOwnerDocument().createTextNode(string));
    }

    private void a(msStringBuilder[] msStringBuilderArray) {
        for (XmlNode xmlNode = this.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            switch (xmlNode.getNodeType()) {
                case 3: 
                case 4: 
                case 13: 
                case 14: {
                    if (msStringBuilderArray[0] == null) {
                        msStringBuilderArray[0] = new msStringBuilder();
                    }
                    msStringBuilderArray[0].append(xmlNode.getValue());
                }
            }
            xmlNode.a(msStringBuilderArray);
        }
    }

    public String getInnerXml() {
        StringWriter stringWriter = new StringWriter();
        XmlDomTextWriter xmlDomTextWriter = new XmlDomTextWriter(stringWriter);
        this.writeContentTo(xmlDomTextWriter);
        return stringWriter.getStringBuilder().toString();
    }

    public void setInnerXml(String string) {
        throw new InvalidOperationException("This node is readonly or doesn't have any children.");
    }

    public boolean isReadOnly() {
        XmlNode xmlNode = this;
        do {
            switch (xmlNode.getNodeType()) {
                case 5: 
                case 6: {
                    return true;
                }
                case 2: {
                    xmlNode = ((XmlAttribute)xmlNode).getOwnerElement();
                    break;
                }
                default: {
                    xmlNode = xmlNode.getParentNode();
                }
            }
        } while (xmlNode != null);
        return false;
    }

    public XmlElement get_Item(String string) {
        XmlNodeList xmlNodeList = this.getChildNodes();
        for (Object e2 : xmlNodeList) {
            XmlNode xmlNode = (XmlNode)e2;
            if (xmlNode.getNodeType() != 1 || !StringExtensions.equals(xmlNode.getName(), string)) continue;
            return (XmlElement)xmlNode;
        }
        return null;
    }

    public XmlElement get_Item(String string, String string2) {
        XmlNodeList xmlNodeList = this.getChildNodes();
        for (Object e2 : xmlNodeList) {
            XmlNode xmlNode = (XmlNode)e2;
            if (xmlNode.getNodeType() != 1 || !StringExtensions.equals(xmlNode.getLocalName(), string) || !StringExtensions.equals(xmlNode.getNamespaceURI(), string2)) continue;
            return (XmlElement)xmlNode;
        }
        return null;
    }

    public XmlNode getLastChild() {
        IHasXmlChildNode iHasXmlChildNode = this instanceof IHasXmlChildNode ? (IHasXmlChildNode)((Object)this) : null;
        return iHasXmlChildNode == null ? null : iHasXmlChildNode.getLastLinkedChild();
    }

    public abstract String getLocalName();

    public abstract String getName();

    public String getNamespaceURI() {
        return StringExtensions.Empty;
    }

    public XmlNode getNextSibling() {
        return null;
    }

    public abstract int getNodeType();

    int getXPathNodeType() {
        throw new InvalidOperationException(StringExtensions.concat("Can not get XPath node type from ", ObjectExtensions.getType(this).toString()));
    }

    public String getOuterXml() {
        StringWriter stringWriter = new StringWriter();
        XmlDomTextWriter xmlDomTextWriter = new XmlDomTextWriter(stringWriter);
        this.writeTo(xmlDomTextWriter);
        return stringWriter.toString();
    }

    public XmlDocument getOwnerDocument() {
        return this.a;
    }

    public XmlNode getParentNode() {
        return this.b;
    }

    public String getPrefix() {
        return StringExtensions.Empty;
    }

    public void setPrefix(String string) {
    }

    public XmlNode getPreviousSibling() {
        return null;
    }

    public String getValue() {
        return null;
    }

    public void setValue(String string) {
        throw new InvalidOperationException("This node does not have a value");
    }

    String getXmlLang() {
        if (this.getAttributes() != null) {
            for (int i2 = 0; i2 < this.getAttributes().size(); ++i2) {
                XmlAttribute xmlAttribute = this.getAttributes().get_ItemOf(i2);
                if (!"xml:lang".equals(xmlAttribute.getName())) continue;
                return xmlAttribute.getValue();
            }
        }
        return this.getParentNode() != null ? this.getParentNode().getXmlLang() : this.getOwnerDocument().getXmlLang();
    }

    int getXmlSpace() {
        if (this.getAttributes() != null) {
            for (int i2 = 0; i2 < this.getAttributes().size(); ++i2) {
                XmlAttribute xmlAttribute = this.getAttributes().get_ItemOf(i2);
                if (!"xml:space".equals(xmlAttribute.getName())) continue;
                switch (d.of(xmlAttribute.getValue())) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 1;
                    }
                }
                break;
            }
        }
        return this.getParentNode() != null ? this.getParentNode().getXmlSpace() : this.getOwnerDocument().getXmlSpace();
    }

    public IXmlSchemaInfo getSchemaInfo() {
        return null;
    }

    void setSchemaInfo(IXmlSchemaInfo iXmlSchemaInfo) {
    }

    public XmlNode appendChild(XmlNode xmlNode) {
        return this.insertBefore(xmlNode, null);
    }

    XmlNode appendChild(XmlNode xmlNode, boolean bl2) {
        return this.insertBefore(xmlNode, null, bl2, true);
    }

    @Override
    public XmlNode deepClone() {
        return this.cloneNode(true);
    }

    public abstract XmlNode cloneNode(boolean var1);

    @Override
    public XPathNavigator createNavigator() {
        return this.getOwnerDocument().createNavigator(this);
    }

    public IEnumerator iterator() {
        return this.getChildNodes().iterator();
    }

    public String getNamespaceOfPrefix(String string) {
        XmlNode xmlNode;
        if (string == null) {
            throw new ArgumentNullException("prefix");
        }
        switch (d.of(string)) {
            case 2: {
                return "http://www.w3.org/XML/1998/namespace";
            }
            case 3: {
                return "http://www.w3.org/2000/xmlns/";
            }
        }
        switch (this.getNodeType()) {
            case 2: {
                xmlNode = ((XmlAttribute)this).getOwnerElement();
                if (xmlNode != null) break;
                return StringExtensions.Empty;
            }
            case 1: {
                xmlNode = this;
                break;
            }
            default: {
                xmlNode = this.getParentNode();
            }
        }
        while (xmlNode != null) {
            if (StringExtensions.equals(xmlNode.getPrefix(), string)) {
                return xmlNode.getNamespaceURI();
            }
            if (xmlNode.getNodeType() == 1 && ((XmlElement)xmlNode).hasAttributes()) {
                int n2 = xmlNode.getAttributes().size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    XmlAttribute xmlAttribute = xmlNode.getAttributes().get_ItemOf(i2);
                    if ((!StringExtensions.equals(string, xmlAttribute.getLocalName()) || !"xmlns".equals(xmlAttribute.getPrefix())) && (!"xmlns".equals(xmlAttribute.getName()) || !StringExtensions.equals(string, StringExtensions.Empty))) continue;
                    return xmlAttribute.getValue();
                }
            }
            xmlNode = xmlNode.getParentNode();
        }
        return StringExtensions.Empty;
    }

    public String getPrefixOfNamespace(String string) {
        XmlNode xmlNode;
        switch (d.of(string)) {
            case 4: {
                return "xml";
            }
            case 5: {
                return "xmlns";
            }
        }
        switch (this.getNodeType()) {
            case 2: {
                xmlNode = ((XmlAttribute)this).getOwnerElement();
                break;
            }
            case 1: {
                xmlNode = this;
                break;
            }
            default: {
                xmlNode = this.getParentNode();
            }
        }
        while (xmlNode != null) {
            if (xmlNode.getNodeType() == 1 && ((XmlElement)xmlNode).hasAttributes()) {
                for (int i2 = 0; i2 < xmlNode.getAttributes().size(); ++i2) {
                    XmlAttribute xmlAttribute = xmlNode.getAttributes().get_ItemOf(i2);
                    if ("xmlns".equals(xmlAttribute.getPrefix()) && StringExtensions.equals(xmlAttribute.getValue(), string)) {
                        return xmlAttribute.getLocalName();
                    }
                    if (!"xmlns".equals(xmlAttribute.getName()) || !StringExtensions.equals(xmlAttribute.getValue(), string)) continue;
                    return StringExtensions.Empty;
                }
            }
            xmlNode = xmlNode.getParentNode();
        }
        return StringExtensions.Empty;
    }

    public XmlNode insertAfter(XmlNode xmlNode, XmlNode xmlNode2) {
        XmlNode xmlNode3 = null;
        if (xmlNode2 != null) {
            xmlNode3 = xmlNode2.getNextSibling();
        } else if (this.getFirstChild() != null) {
            xmlNode3 = this.getFirstChild();
        }
        return this.insertBefore(xmlNode, xmlNode3);
    }

    public XmlNode insertBefore(XmlNode xmlNode, XmlNode xmlNode2) {
        return this.insertBefore(xmlNode, xmlNode2, true, true);
    }

    boolean isAncestor(XmlNode xmlNode) {
        for (XmlNode xmlNode2 = this.getParentNode(); xmlNode2 != null; xmlNode2 = xmlNode2.getParentNode()) {
            if (xmlNode2 != xmlNode) continue;
            return true;
        }
        return false;
    }

    XmlNode insertBefore(XmlNode xmlNode, XmlNode xmlNode2, boolean bl2, boolean bl3) {
        XmlDocument xmlDocument;
        if (bl2) {
            this.a(xmlNode, xmlNode2);
        }
        if (xmlNode == xmlNode2) {
            return xmlNode;
        }
        IHasXmlChildNode iHasXmlChildNode = (IHasXmlChildNode)((Object)this);
        XmlDocument xmlDocument2 = xmlDocument = this.getNodeType() == 9 ? (XmlDocument)this : this.getOwnerDocument();
        if (bl3) {
            xmlDocument.onNodeInserting(xmlNode, this);
        }
        if (xmlNode.getParentNode() != null) {
            xmlNode.getParentNode().removeChild(xmlNode, bl2);
        }
        if (xmlNode.getNodeType() == 11) {
            XmlNode xmlNode3 = null;
            while (xmlNode.getFirstChild() != null) {
                XmlNode xmlNode4 = this.insertBefore(xmlNode.getFirstChild(), xmlNode2);
                xmlNode3 = xmlNode3 != null ? xmlNode3 : xmlNode4;
            }
            return xmlNode3;
        }
        XmlLinkedNode xmlLinkedNode = (XmlLinkedNode)xmlNode;
        xmlLinkedNode.b = this;
        if (xmlNode2 == null) {
            if (iHasXmlChildNode.getLastLinkedChild() != null) {
                XmlLinkedNode xmlLinkedNode2 = (XmlLinkedNode)this.getFirstChild();
                iHasXmlChildNode.getLastLinkedChild().setNextLinkedSibling(xmlLinkedNode);
                iHasXmlChildNode.setLastLinkedChild(xmlLinkedNode);
                xmlLinkedNode.setNextLinkedSibling(xmlLinkedNode2);
            } else {
                iHasXmlChildNode.setLastLinkedChild(xmlLinkedNode);
                iHasXmlChildNode.getLastLinkedChild().setNextLinkedSibling(xmlLinkedNode);
            }
        } else {
            XmlLinkedNode xmlLinkedNode3;
            XmlNode xmlNode5 = xmlNode2.getPreviousSibling();
            XmlLinkedNode xmlLinkedNode4 = xmlLinkedNode3 = xmlNode5 instanceof XmlLinkedNode ? (XmlLinkedNode)xmlNode5 : null;
            if (xmlLinkedNode3 == null) {
                iHasXmlChildNode.getLastLinkedChild().setNextLinkedSibling(xmlLinkedNode);
            } else {
                xmlLinkedNode3.setNextLinkedSibling(xmlLinkedNode);
            }
            xmlLinkedNode.setNextLinkedSibling(xmlNode2 instanceof XmlLinkedNode ? (XmlLinkedNode)xmlNode2 : null);
        }
        switch (xmlNode.getNodeType()) {
            case 5: {
                ((XmlEntityReference)xmlNode).setReferencedEntityContent();
                break;
            }
            case 6: {
                break;
            }
        }
        if (bl3) {
            xmlDocument.onNodeInserted(xmlNode, xmlNode.getParentNode());
        }
        return xmlNode;
    }

    private void a(XmlNode xmlNode, XmlNode xmlNode2) {
        XmlDocument xmlDocument;
        XmlDocument xmlDocument2 = xmlDocument = this.getNodeType() == 9 ? (XmlDocument)this : this.getOwnerDocument();
        if (this.getNodeType() != 1 && this.getNodeType() != 2 && this.getNodeType() != 9 && this.getNodeType() != 11) {
            throw new InvalidOperationException(StringExtensions.format("Node cannot be appended to current node {0}.", this.getNodeType()));
        }
        block0 : switch (this.getNodeType()) {
            case 2: {
                switch (xmlNode.getNodeType()) {
                    case 3: 
                    case 5: {
                        break block0;
                    }
                }
                throw new InvalidOperationException(StringExtensions.format("Cannot insert specified type of node {0} as a child of this node {1}.", xmlNode.getNodeType(), this.getNodeType()));
            }
            case 1: {
                switch (xmlNode.getNodeType()) {
                    case 2: 
                    case 6: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 17: {
                        throw new InvalidOperationException("Cannot insert specified type of node as a child of this node.");
                    }
                }
            }
        }
        if (this.isReadOnly()) {
            throw new InvalidOperationException("The node is readonly.");
        }
        if (xmlNode.getOwnerDocument() != xmlDocument) {
            throw new ArgumentException("Can't append a node created by another document.");
        }
        if (xmlNode2 != null && xmlNode2.getParentNode() != this) {
            throw new ArgumentException("The reference node is not a child of this node.");
        }
        if (this == xmlDocument && xmlDocument.getDocumentElement() != null && xmlNode instanceof XmlElement && xmlNode != xmlDocument.getDocumentElement()) {
            throw new XmlException("multiple document element not allowed.");
        }
        if (xmlNode == this || this.isAncestor(xmlNode)) {
            throw new ArgumentException("Cannot insert a node or any ancestor of that node as a child of itself.");
        }
    }

    public void normalize() {
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        int n2 = this.getChildNodes().getCount();
        int n3 = 0;
        block3: for (int i2 = 0; i2 < n2; ++i2) {
            XmlNode xmlNode = this.getChildNodes().get_ItemOf(i2);
            switch (xmlNode.getNodeType()) {
                case 3: 
                case 13: 
                case 14: {
                    msStringBuilder2.append(xmlNode.getValue());
                    continue block3;
                }
                default: {
                    xmlNode.normalize();
                    this.a(n3, i2, msStringBuilder2);
                    n3 = i2 + 1;
                }
            }
        }
        if (n3 < n2) {
            this.a(n3, n2, msStringBuilder2);
        }
    }

    private void a(int n2, int n3, msStringBuilder msStringBuilder2) {
        int n4;
        int n5 = -1;
        for (n4 = n2; n4 < n3; ++n4) {
            XmlNode xmlNode = this.getChildNodes().get_ItemOf(n4);
            if (xmlNode.getNodeType() == 3) {
                n5 = n4;
                break;
            }
            if (xmlNode.getNodeType() != 14) continue;
            n5 = n4;
        }
        if (n5 >= 0) {
            for (n4 = n2; n4 < n5; ++n4) {
                this.removeChild(this.getChildNodes().get_ItemOf(n2));
            }
            n4 = n3 - n5 - 1;
            for (int i2 = 0; i2 < n4; ++i2) {
                this.removeChild(this.getChildNodes().get_ItemOf(n2 + 1));
            }
        }
        if (n5 >= 0) {
            this.getChildNodes().get_ItemOf(n2).setValue(msStringBuilder2.toString());
        }
        msStringBuilder2.setLength(0);
    }

    public XmlNode prependChild(XmlNode xmlNode) {
        return this.insertAfter(xmlNode, null);
    }

    public void removeAll() {
        if (this.getAttributes() != null) {
            this.getAttributes().removeAll();
        }
        XmlNode xmlNode = null;
        XmlNode xmlNode2 = this.getFirstChild();
        while (xmlNode2 != null) {
            xmlNode = xmlNode2.getNextSibling();
            this.removeChild(xmlNode2);
            xmlNode2 = xmlNode;
        }
    }

    public XmlNode removeChild(XmlNode xmlNode) {
        return this.removeChild(xmlNode, true);
    }

    private void a() {
        if (this.getNodeType() != 2 && this.getNodeType() != 1 && this.getNodeType() != 9 && this.getNodeType() != 11) {
            throw new ArgumentException(StringExtensions.format("This {0} node cannot remove its child.", this.getNodeType()));
        }
        if (this.isReadOnly()) {
            throw new ArgumentException(StringExtensions.format("This {0} node is read only.", this.getNodeType()));
        }
    }

    XmlNode removeChild(XmlNode xmlNode, boolean bl2) {
        IHasXmlChildNode iHasXmlChildNode;
        XmlDocument xmlDocument;
        if (xmlNode == null) {
            throw new NullReferenceException();
        }
        XmlDocument xmlDocument2 = xmlDocument = this.getNodeType() == 9 ? (XmlDocument)this : this.getOwnerDocument();
        if (xmlNode.getParentNode() != this) {
            throw new ArgumentException("The node to be removed is not a child of this node.");
        }
        if (bl2) {
            xmlDocument.onNodeRemoving(xmlNode, xmlNode.getParentNode());
        }
        if (bl2) {
            this.a();
        }
        if (ObjectExtensions.referenceEquals((iHasXmlChildNode = (IHasXmlChildNode)((Object)this)).getLastLinkedChild(), iHasXmlChildNode.getLastLinkedChild().getNextLinkedSibling()) && ObjectExtensions.referenceEquals(iHasXmlChildNode.getLastLinkedChild(), xmlNode)) {
            iHasXmlChildNode.setLastLinkedChild(null);
        } else {
            XmlLinkedNode xmlLinkedNode = (XmlLinkedNode)xmlNode;
            XmlLinkedNode xmlLinkedNode2 = iHasXmlChildNode.getLastLinkedChild();
            XmlLinkedNode xmlLinkedNode3 = (XmlLinkedNode)this.getFirstChild();
            while (!ObjectExtensions.referenceEquals(xmlLinkedNode2.getNextLinkedSibling(), iHasXmlChildNode.getLastLinkedChild()) && !ObjectExtensions.referenceEquals(xmlLinkedNode2.getNextLinkedSibling(), xmlLinkedNode)) {
                xmlLinkedNode2 = xmlLinkedNode2.getNextLinkedSibling();
            }
            if (!ObjectExtensions.referenceEquals(xmlLinkedNode2.getNextLinkedSibling(), xmlLinkedNode)) {
                throw new ArgumentException();
            }
            xmlLinkedNode2.setNextLinkedSibling(xmlLinkedNode.getNextLinkedSibling());
            if (xmlLinkedNode.getNextLinkedSibling() == xmlLinkedNode3) {
                iHasXmlChildNode.setLastLinkedChild(xmlLinkedNode2);
            }
            xmlLinkedNode.setNextLinkedSibling(null);
        }
        if (bl2) {
            xmlDocument.onNodeRemoved(xmlNode, xmlNode.getParentNode());
        }
        xmlNode.b = null;
        return xmlNode;
    }

    public XmlNode replaceChild(XmlNode xmlNode, XmlNode xmlNode2) {
        if (xmlNode2.getParentNode() != this) {
            throw new ArgumentException("The node to be removed is not a child of this node.");
        }
        if (xmlNode == this || this.isAncestor(xmlNode)) {
            throw new InvalidOperationException("Cannot insert a node or any ancestor of that node as a child of itself.");
        }
        XmlNode xmlNode3 = xmlNode2.getNextSibling();
        this.removeChild(xmlNode2);
        this.insertBefore(xmlNode, xmlNode3);
        return xmlNode2;
    }

    XmlElement getAttributeOwnerElement() {
        return (XmlElement)this.b;
    }

    void setAttributeOwnerElement(XmlElement xmlElement) {
        this.b = xmlElement;
    }

    void searchDescendantElements(String string, boolean bl2, ArrayList arrayList) {
        for (XmlNode xmlNode = this.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            if (xmlNode.getNodeType() != 1) continue;
            if (bl2 || StringExtensions.equals(xmlNode.getName(), string)) {
                arrayList.addItem(xmlNode);
            }
            xmlNode.searchDescendantElements(string, bl2, arrayList);
        }
    }

    void searchDescendantElements(String string, boolean bl2, String string2, boolean bl3, ArrayList arrayList) {
        for (XmlNode xmlNode = this.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            if (xmlNode.getNodeType() != 1) continue;
            if ((bl2 || StringExtensions.equals(xmlNode.getLocalName(), string)) && (bl3 || StringExtensions.equals(xmlNode.getNamespaceURI(), string2))) {
                arrayList.addItem(xmlNode);
            }
            xmlNode.searchDescendantElements(string, bl2, string2, bl3, arrayList);
        }
    }

    public XmlNodeList selectNodes(String string) {
        return this.selectNodes(string, null);
    }

    public XmlNodeList selectNodes(String string, XmlNamespaceManager xmlNamespaceManager) {
        XPathNavigator xPathNavigator = this.createNavigator();
        XPathExpression xPathExpression = xPathNavigator.compile(string);
        if (xmlNamespaceManager != null) {
            xPathExpression.setContext(xmlNamespaceManager);
        }
        XPathNodeIterator xPathNodeIterator = xPathNavigator.select(xPathExpression);
        return new XmlIteratorNodeList(this instanceof XmlDocument ? (XmlDocument)this : this.a, xPathNodeIterator);
    }

    public XmlNode selectSingleNode(String string) {
        return this.selectSingleNode(string, null);
    }

    public XmlNode selectSingleNode(String string, XmlNamespaceManager xmlNamespaceManager) {
        XPathNodeIterator xPathNodeIterator;
        XPathNavigator xPathNavigator = this.createNavigator();
        XPathExpression xPathExpression = xPathNavigator.compile(string);
        if (xmlNamespaceManager != null) {
            xPathExpression.setContext(xmlNamespaceManager);
        }
        if (!(xPathNodeIterator = xPathNavigator.select(xPathExpression)).moveNext()) {
            return null;
        }
        return ((IHasXmlNode)((Object)xPathNodeIterator.getCurrent())).getNode();
    }

    public boolean supports(String string, String string2) {
        return StringExtensions.compare(string, "xml", true, CultureInfo.getInvariantCulture()) == 0 && (StringExtensions.compare(string2, "1.0", true, CultureInfo.getInvariantCulture()) == 0 || StringExtensions.compare(string2, "2.0", true, CultureInfo.getInvariantCulture()) == 0);
    }

    public abstract void writeContentTo(XmlWriter var1);

    public abstract void writeTo(XmlWriter var1);

    XmlNamespaceManager constructNamespaceManager() {
        XmlNode xmlNode;
        XmlDocument xmlDocument = this instanceof XmlDocument ? (XmlDocument)this : this.getOwnerDocument();
        XmlNamespaceManager xmlNamespaceManager = new XmlNamespaceManager(xmlDocument.getNameTable());
        XmlElement xmlElement = null;
        switch (this.getNodeType()) {
            case 2: {
                xmlElement = ((XmlAttribute)this).getOwnerElement();
                break;
            }
            case 1: {
                xmlElement = this instanceof XmlElement ? (XmlElement)this : null;
                break;
            }
            default: {
                xmlNode = this.getParentNode();
                XmlElement xmlElement2 = xmlElement = xmlNode instanceof XmlElement ? (XmlElement)xmlNode : null;
            }
        }
        while (xmlElement != null) {
            for (int i2 = 0; i2 < xmlElement.getAttributes().size(); ++i2) {
                XmlAttribute xmlAttribute = xmlElement.getAttributes().get_ItemOf(i2);
                if ("xmlns".equals(xmlAttribute.getPrefix())) {
                    if (StringExtensions.equals(xmlNamespaceManager.lookupNamespace(xmlAttribute.getLocalName()), xmlAttribute.getValue())) continue;
                    xmlNamespaceManager.addNamespace(xmlAttribute.getLocalName(), xmlAttribute.getValue());
                    continue;
                }
                if (!"xmlns".equals(xmlAttribute.getName()) || StringExtensions.equals(xmlNamespaceManager.lookupNamespace(StringExtensions.Empty), xmlAttribute.getValue())) continue;
                xmlNamespaceManager.addNamespace(StringExtensions.Empty, xmlAttribute.getValue());
            }
            xmlNode = xmlElement.getParentNode();
            xmlElement = xmlNode instanceof XmlElement ? (XmlElement)xmlNode : null;
        }
        return xmlNamespaceManager;
    }

    static class EmptyNodeList
    extends XmlNodeList {
        static IEnumerator emptyEnumerator = Array.boxing(new Object[0]).iterator();

        private EmptyNodeList() {
        }

        @Override
        public int getCount() {
            return 0;
        }

        @Override
        public IEnumerator iterator() {
            return emptyEnumerator;
        }

        @Override
        public XmlNode item(int n2) {
            return null;
        }
    }
}

