/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.dithering;

import com.aspose.html.utils.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.ColorPaletteHelper;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.Point;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.RgbEntriesPaletteHash;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.dithering.FloydSteinbergDithering;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.dithering.ThreshholdDithering;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialArgb32PixelLoader;

public abstract class DitheringBase
implements IPartialArgb32PixelLoader {
    protected boolean SkipEmptyColor;
    protected final Rectangle DesiredRectangle;
    protected int ColorToSkip;
    protected int ColorToSkipArgb;
    protected int SubstituteColor;
    protected int SubstituteColorArgb;
    protected final IPartialArgb32PixelLoader FinalProcessor;
    protected final IColorPalette Palette;
    protected final RgbEntriesPaletteHash PaletteHash;
    private final int a;
    private final int b;

    protected DitheringBase(int n2, int n3, int n4, Rectangle rectangle, IPartialArgb32PixelLoader iPartialArgb32PixelLoader, IColorPalette iColorPalette) {
        block6: {
            block5: {
                this.SkipEmptyColor = false;
                this.DesiredRectangle = new Rectangle();
                this.ColorToSkip = 0;
                this.ColorToSkipArgb = 0;
                this.SubstituteColorArgb = 0;
                this.FinalProcessor = iPartialArgb32PixelLoader;
                this.a = n2;
                this.b = n3;
                rectangle.CloneTo(this.DesiredRectangle);
                if (iColorPalette != null) break block5;
                switch (n4) {
                    case 1: {
                        this.Palette = ColorPaletteHelper.createMonochrome();
                        break block6;
                    }
                    case 4: {
                        this.Palette = ColorPaletteHelper.create4BitGrayscale(false);
                        break block6;
                    }
                    case 8: {
                        this.Palette = ColorPaletteHelper.create8BitGrayscale(false);
                        break block6;
                    }
                    default: {
                        throw new ArgumentOutOfRangeException("bits");
                    }
                }
            }
            this.Palette = iColorPalette;
        }
        this.PaletteHash = new RgbEntriesPaletteHash(this.Palette);
    }

    protected DitheringBase(int n2, int n3, int n4, Rectangle rectangle, IPartialArgb32PixelLoader iPartialArgb32PixelLoader, boolean bl2, int n5, int n6, IColorPalette iColorPalette) {
        this(n2, n3, n4, rectangle.Clone(), iPartialArgb32PixelLoader, iColorPalette);
        this.SkipEmptyColor = bl2;
        this.ColorToSkip = n5;
        this.ColorToSkipArgb = n5;
        this.SubstituteColor = n6;
        this.SubstituteColorArgb = n6;
    }

    public int getWidth() {
        return this.a;
    }

    public int getHeight() {
        return this.b;
    }

    public static DitheringBase getDithering(int n2, int n3, IColorPalette iColorPalette, int n4, int n5, Rectangle rectangle, IPartialArgb32PixelLoader iPartialArgb32PixelLoader, boolean bl2, int n6, int n7) {
        DitheringBase ditheringBase;
        switch (n2) {
            case 0: {
                ditheringBase = new ThreshholdDithering(n4, n5, rectangle.Clone(), n3, iPartialArgb32PixelLoader, bl2, n6, n7);
                break;
            }
            case 1: {
                ditheringBase = new FloydSteinbergDithering(n4, n5, rectangle.Clone(), n3, iColorPalette, iPartialArgb32PixelLoader, bl2, n6, n7);
                break;
            }
            default: {
                throw new ArgumentOutOfRangeException("ditheringMethod");
            }
        }
        return ditheringBase;
    }

    public static DitheringBase getDithering(int n2, int n3, IColorPalette iColorPalette, int n4, int n5, Rectangle rectangle, IPartialArgb32PixelLoader iPartialArgb32PixelLoader) {
        return DitheringBase.getDithering(n2, n3, iColorPalette, n4, n5, rectangle.Clone(), iPartialArgb32PixelLoader, false, 0, 0);
    }

    @Override
    public abstract void process(Rectangle var1, int[] var2, Point var3, Point var4);

    protected int switchColor(int n2) {
        int n3 = n2;
        if (this.SkipEmptyColor && n2 == this.ColorToSkipArgb) {
            n3 = this.SubstituteColorArgb;
        }
        return n3;
    }
}

