/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.readers;

import com.aspose.html.utils.ms.System.Int32Extensions;
import com.aspose.html.utils.ms.System.InvalidOperationException;
import com.aspose.html.utils.ms.System.OutOfMemoryException;
import com.aspose.html.utils.ms.System.StringExtensions;
import com.aspose.html.utils.ms.System.msMath;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.ArrayHelper;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.BufferHelper;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.LoadOptions;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.PartialProcessor;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.Point;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.ValueResult;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffCodec;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffCodecDataReader;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.IRawDataToColorConverter;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.ccitt.StripReader;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffStream;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.imageoptions.TiffOptions;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialArgb32PixelLoader;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialProcessor;

abstract class TiffSimpleCompressReader
extends TiffCodecDataReader {
    private static int a;
    private final LoadOptions b;
    private int c;
    private boolean d;
    private int e;
    private int f;
    private int g;

    public TiffSimpleCompressReader(TiffOptions tiffOptions, int n2, int n3, LoadOptions loadOptions) {
        super(tiffOptions, n2, n3);
        this.b = loadOptions;
    }

    public static int getMaxAllowedAllocation() {
        return a;
    }

    public static void setMaxAllowedAllocation(int n2) {
        a = n2;
    }

    public int getBitsPerSample() {
        return this.c;
    }

    public void setBitsPerSample(int n2) {
        this.c = n2;
    }

    public boolean getPackBits() {
        return this.d;
    }

    public void setPackBits(boolean bl2) {
        this.d = bl2;
    }

    public int getPredictor() {
        return this.e;
    }

    public void setPredictor(int n2) {
        this.e = n2;
    }

    public int getRowSize() {
        return this.f;
    }

    public void setRowSize(int n2) {
        this.f = n2;
    }

    public int getSamplesPerPixel() {
        return this.g;
    }

    public void setSamplesPerPixel(int n2) {
        this.g = n2;
    }

    @Override
    public void decode(TiffStream tiffStream, Rectangle rectangle, IPartialArgb32PixelLoader iPartialArgb32PixelLoader) {
        PartialLoader partialLoader = new PartialLoader(this, tiffStream, iPartialArgb32PixelLoader, rectangle.Clone());
        PartialProcessor.process(rectangle.Clone(), partialLoader);
    }

    protected abstract void initializeDecoderForStrip(StripReader var1);

    protected abstract ValueResult decodeStripData(byte[] var1, int var2);

    static class PartialLoader
    implements IPartialProcessor {
        private final TiffSimpleCompressReader a;
        private final IPartialArgb32PixelLoader b;
        private final StripReader c;
        private final int d;
        private final Rectangle e = new Rectangle();
        private final int f;
        private final int[][] g;
        private final LoadOptions h;
        private int i;
        private IRawDataToColorConverter j;
        private int k;
        private boolean l;

        public PartialLoader(TiffSimpleCompressReader tiffSimpleCompressReader, TiffStream tiffStream, IPartialArgb32PixelLoader iPartialArgb32PixelLoader, Rectangle rectangle) {
            rectangle.CloneTo(this.e);
            this.b = iPartialArgb32PixelLoader;
            this.a = tiffSimpleCompressReader;
            long[] lArray = tiffSimpleCompressReader.getOptions().getStripOffsets();
            this.d = tiffSimpleCompressReader.getRowsPerStrip();
            int n2 = this.a.getOptions().getBitsPerPixel();
            this.f = (this.a.getWidth() * n2 + 7) / 8;
            this.c = new StripReader(tiffStream.getStream(), tiffSimpleCompressReader.getOptions(), tiffSimpleCompressReader.getHeight(), lArray.length, this.d);
            this.g = TiffCodec.buildLutTable(tiffSimpleCompressReader.getOptions());
            this.h = tiffSimpleCompressReader.b;
        }

        @Override
        public void process(Rectangle rectangle) {
            int n2 = rectangle.getWidth() * rectangle.getHeight();
            if (a > 0 && n2 > a) {
                throw new OutOfMemoryException();
            }
            int[] nArray = ArrayHelper.getColors(n2);
            int n3 = 0;
            int n4 = this.f * this.d;
            n4 = n4 == n2 * 4 ? this.f : n4;
            byte[] byArray = BufferHelper.allocate(n4);
            try {
                while (n3 < n2) {
                    int n5;
                    int n6;
                    int n7;
                    int n8 = 0;
                    int n9 = n3 / rectangle.getWidth() + rectangle.getTop();
                    if (n9 < this.i) {
                        if (this.j != null) {
                            int[] nArray2 = new int[]{n3};
                            this.j.fillLeftValues(nArray, nArray2);
                            n3 = nArray2[0];
                            if (n3 == n2) continue;
                        }
                        int n10 = this.h.getDataBackgroundColor();
                        n7 = this.c.getNextStripLineIndex(n9);
                        n6 = (n7 - rectangle.getTop()) * rectangle.getWidth();
                        int n11 = n2 - n3;
                        n5 = msMath.min(n6 - n3, n11);
                        for (int i2 = 0; i2 < n5; ++i2) {
                            nArray[n3++] = n10;
                        }
                        this.l = true;
                        continue;
                    }
                    boolean bl2 = false;
                    if (this.j != null) {
                        n8 = this.j.getProcessedBytes();
                        bl2 = this.j.hasIncompleteData();
                    }
                    if (this.l || n8 == this.k && !bl2) {
                        n7 = this.c.seekToLineStrip(n9);
                        this.a.initializeDecoderForStrip(this.c);
                        this.j = this.a.createConverter(this.a.getOptions(), this.g, this.e.Clone());
                        this.k = msMath.min(this.a.getHeight() - n7, this.d) * this.f;
                        this.j.setInitialRowIndex(n7);
                        this.l = false;
                    }
                    int[] nArray3 = new int[]{n3};
                    this.j.fillLeftValues(nArray, nArray3);
                    n3 = nArray3[0];
                    if (n3 >= n2) continue;
                    n6 = msMath.min(this.j.getProcessedBytes() + byArray.length, this.k) - this.j.getProcessedBytes();
                    ValueResult valueResult = this.a.decodeStripData(byArray, n6).Clone();
                    n5 = valueResult.Value;
                    nArray3[0] = n3;
                    this.j.convert(byArray, n5, nArray, nArray3);
                    n3 = nArray3[0];
                    if (valueResult.Success) continue;
                    if (this.h != null && this.h.getDataRecoveryMode() != 0) {
                        this.i = this.c.getNextStripLineIndex(n9);
                        this.l = true;
                        continue;
                    }
                    throw new InvalidOperationException(StringExtensions.concat("TiffImageException: The strip ", Int32Extensions.toString(this.c.getStripIndex()), " has corrupt data and cannot be decoded. Error: ", valueResult.ErrorMessage));
                }
                this.b.process(rectangle.Clone(), nArray, rectangle.getLocation().Clone(), new Point(rectangle.getRight(), rectangle.getBottom()));
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new OutOfMemoryException("FrameworkException: Fatal error", outOfMemoryError);
            }
        }
    }
}

