/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement;

import com.aspose.html.utils.Stream;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.ByteConverter;
import com.aspose.html.utils.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffStream;

public final class TiffBigEndianStream
extends TiffStream {
    public TiffBigEndianStream(Stream stream) {
        super(stream);
    }

    public TiffBigEndianStream(Stream stream, boolean bl2) {
        super(stream, bl2);
    }

    @Override
    protected double[] processReadDataDouble(byte[] byArray) {
        double[] dArray = new double[byArray.length / 8];
        for (int i2 = 0; i2 < byArray.length / 8; ++i2) {
            dArray[i2] = ByteConverter.fromBigEndianToDouble(byArray, i2 * 8);
        }
        return dArray;
    }

    @Override
    protected float[] processReadDataFloat(byte[] byArray) {
        float[] fArray = new float[byArray.length / 4];
        for (int i2 = 0; i2 < byArray.length / 4; ++i2) {
            fArray[i2] = ByteConverter.fromBigEndianToSingle(byArray, i2 * 4);
        }
        return fArray;
    }

    @Override
    protected int[] processReadDataLong(byte[] byArray) {
        int[] nArray = new int[byArray.length / 4];
        for (int i2 = 0; i2 < byArray.length / 4; ++i2) {
            nArray[i2] = ByteConverter.fromBigEndianToInt32(byArray, i2 * 4);
        }
        return nArray;
    }

    @Override
    protected short[] processReadDataShort(byte[] byArray) {
        short[] sArray = new short[byArray.length / 2];
        for (int i2 = 0; i2 < byArray.length / 2; ++i2) {
            sArray[i2] = ByteConverter.fromBigEndianToInt16(byArray, i2 * 2);
        }
        return sArray;
    }

    @Override
    protected long[] processReadDataULong(byte[] byArray) {
        long[] lArray = new long[byArray.length / 4];
        for (int i2 = 0; i2 < byArray.length / 4; ++i2) {
            lArray[i2] = (long)ByteConverter.fromBigEndianToInt32(byArray, i2 * 4) & 0xFFFFFFFFL;
        }
        return lArray;
    }

    @Override
    protected int[] processReadDataUShort(byte[] byArray) {
        int[] nArray = new int[byArray.length / 2];
        for (int i2 = 0; i2 < byArray.length / 2; ++i2) {
            nArray[i2] = ByteConverter.fromBigEndianToInt16(byArray, i2 * 2) & 0xFFFF;
        }
        return nArray;
    }

    @Override
    protected void processWriteDataLong(int[] nArray, byte[] byArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            ByteConverter.writeBigEndianBytesInt32(nArray[i2], byArray, i2 * 4);
        }
    }

    @Override
    protected void processWriteDataULong(long[] lArray, byte[] byArray) {
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            ByteConverter.writeBigEndianBytesUInt32(lArray[i2], byArray, i2 * 4);
        }
    }

    @Override
    protected void processWriteDataShort(short[] sArray, byte[] byArray) {
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            ByteConverter.writeBigEndianBytesInt16(sArray[i2], byArray, i2 * 2);
        }
    }

    @Override
    protected void processWriteDataUShort(int[] nArray, byte[] byArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            ByteConverter.writeBigEndianBytesUInt16(nArray[i2], byArray, i2 * 2);
        }
    }

    @Override
    protected void processWriteDataFloat(float[] fArray, byte[] byArray) {
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            ByteConverter.writeBigEndianBytesSingle(fArray[i2], byArray, i2 * 4);
        }
    }

    @Override
    protected void processWriteDataDouble(double[] dArray, byte[] byArray) {
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            ByteConverter.writeBigEndianBytesDouble(dArray[i2], byArray, i2 * 8);
        }
    }
}

