/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates.extensions;

import com.aspose.html.utils.ms.System.ArgumentException;
import com.aspose.html.utils.ms.System.Convert;
import com.aspose.html.utils.ms.System.Environment;
import com.aspose.html.utils.ms.System.Globalization.CultureInfo;
import com.aspose.html.utils.ms.System.IFormatProvider;
import com.aspose.html.utils.ms.System.Int32Extensions;
import com.aspose.html.utils.ms.System.Text.msStringBuilder;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.ASN1;
import com.aspose.html.utils.ms.core.System.Security.Cryptography.X509Certificates.X509Extension;

public class KeyUsageExtension
extends X509Extension {
    private int a;

    public KeyUsageExtension(ASN1 aSN1) {
        super(aSN1);
    }

    public KeyUsageExtension(X509Extension x509Extension) {
        super(x509Extension);
    }

    public KeyUsageExtension() {
        this.extnOid = "2.5.29.15";
    }

    @Override
    public void decode() {
        ASN1 aSN1 = new ASN1(this.extnValue.getValue());
        if (aSN1.getTag() != 3) {
            throw new ArgumentException("Invalid KeyUsage extension");
        }
        int n2 = 1;
        while (n2 < aSN1.getValue().length) {
            this.a = (this.a << 8) + aSN1.getValue()[n2++];
        }
    }

    @Override
    public void encode() {
        this.extnValue = new ASN1(4);
        int n2 = this.a;
        byte by2 = 16;
        if ((n2 & 0xFFFF) > 0) {
            by2 = 15;
            while ((by2 & 0xFF) > 0 && (n2 & 0xFFFF & 0x8000) != 32768) {
                n2 <<= 1;
                by2 = (byte)(by2 - 1);
            }
            if (this.a > 255) {
                by2 = (byte)((by2 & 0xFF) - 8);
                this.extnValue.add(new ASN1(3, new byte[]{by2, (byte)this.a, (byte)(this.a >> 8)}));
            } else {
                this.extnValue.add(new ASN1(3, new byte[]{by2, (byte)this.a}));
            }
        } else {
            this.extnValue.add(new ASN1(3, new byte[]{7, 0}));
        }
    }

    public int getKeyUsage() {
        return this.a;
    }

    public void setKeyUsage(int n2) {
        this.a = Convert.toInt32(n2, (IFormatProvider)CultureInfo.getInvariantCulture());
    }

    @Override
    public String getName() {
        return "Key Usage";
    }

    public boolean support(int n2) {
        int n3 = Convert.toInt32(n2, (IFormatProvider)CultureInfo.getInvariantCulture());
        return (n3 & this.a) == n3;
    }

    @Override
    public String toString() {
        String string = " , ";
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        if (this.support(128)) {
            msStringBuilder2.append("Digital Signature");
        }
        if (this.support(64)) {
            if (msStringBuilder2.getLength() > 0) {
                msStringBuilder2.append(string);
            }
            msStringBuilder2.append("Non-Repudiation");
        }
        if (this.support(32)) {
            if (msStringBuilder2.getLength() > 0) {
                msStringBuilder2.append(string);
            }
            msStringBuilder2.append("Key Encipherment");
        }
        if (this.support(16)) {
            if (msStringBuilder2.getLength() > 0) {
                msStringBuilder2.append(string);
            }
            msStringBuilder2.append("Data Encipherment");
        }
        if (this.support(8)) {
            if (msStringBuilder2.getLength() > 0) {
                msStringBuilder2.append(string);
            }
            msStringBuilder2.append("Key Agreement");
        }
        if (this.support(4)) {
            if (msStringBuilder2.getLength() > 0) {
                msStringBuilder2.append(string);
            }
            msStringBuilder2.append("Certificate Signing");
        }
        if (this.support(2)) {
            if (msStringBuilder2.getLength() > 0) {
                msStringBuilder2.append(string);
            }
            msStringBuilder2.append("CRL Signing");
        }
        if (this.support(1)) {
            if (msStringBuilder2.getLength() > 0) {
                msStringBuilder2.append(string);
            }
            msStringBuilder2.append("Encipher Only ");
        }
        if (this.support(2048)) {
            if (msStringBuilder2.getLength() > 0) {
                msStringBuilder2.append(string);
            }
            msStringBuilder2.append("Decipher Only");
        }
        msStringBuilder2.append("(");
        msStringBuilder2.append(Int32Extensions.toString(this.a, "X2", CultureInfo.getInvariantCulture()));
        msStringBuilder2.append(")");
        msStringBuilder2.append(Environment.NewLine);
        return msStringBuilder2.toString();
    }
}

