/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.cms;

import com.aspose.html.utils.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.utils.ms.core.bc.asn1.cms.CMSObjectIdentifiers;
import com.aspose.html.utils.ms.core.bc.cms.CMSException;
import com.aspose.html.utils.ms.core.bc.cms.CMSReadable;
import com.aspose.html.utils.ms.core.bc.cms.CMSTypedData;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CMSProcessableFile
implements CMSReadable,
CMSTypedData {
    private static final int DEFAULT_BUF_SIZE = 32768;
    private final ASN1ObjectIdentifier type;
    private final File file;
    private final byte[] buf;

    public CMSProcessableFile(File file) {
        this(file, 32768);
    }

    public CMSProcessableFile(File file, int n2) {
        this(CMSObjectIdentifiers.data, file, n2);
    }

    public CMSProcessableFile(ASN1ObjectIdentifier aSN1ObjectIdentifier, File file, int n2) {
        this.type = aSN1ObjectIdentifier;
        this.file = file;
        this.buf = new byte[n2];
    }

    public InputStream getInputStream() throws IOException, CMSException {
        return new BufferedInputStream(new FileInputStream(this.file), 32768);
    }

    public void write(OutputStream outputStream) throws IOException, CMSException {
        int n2;
        FileInputStream fileInputStream = new FileInputStream(this.file);
        while ((n2 = fileInputStream.read(this.buf, 0, this.buf.length)) > 0) {
            outputStream.write(this.buf, 0, n2);
        }
        fileInputStream.close();
    }

    public Object getContent() {
        return this.file;
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.type;
    }
}

