/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.cms.jcajce;

import com.aspose.html.utils.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.utils.ms.core.bc.operator.InputExpander;
import com.aspose.html.utils.ms.core.bc.operator.InputExpanderProvider;
import com.aspose.html.utils.ms.core.bc.util.io.StreamOverflowException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;

public class ZlibExpanderProvider
implements InputExpanderProvider {
    private final long limit;

    public ZlibExpanderProvider() {
        this.limit = -1L;
    }

    public ZlibExpanderProvider(long l2) {
        this.limit = l2;
    }

    public InputExpander get(final AlgorithmIdentifier algorithmIdentifier) {
        return new InputExpander(){

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return algorithmIdentifier;
            }

            public InputStream getInputStream(InputStream inputStream) {
                FilterInputStream filterInputStream = new InflaterInputStream(inputStream);
                if (ZlibExpanderProvider.this.limit >= 0L) {
                    filterInputStream = new LimitedInputStream(filterInputStream, ZlibExpanderProvider.this.limit);
                }
                return filterInputStream;
            }
        };
    }

    static class LimitedInputStream
    extends FilterInputStream {
        private long remaining;

        public LimitedInputStream(InputStream inputStream, long l2) {
            super(inputStream);
            this.remaining = l2;
        }

        public int read() throws IOException {
            int n2;
            if (this.remaining >= 0L && ((n2 = this.in.read()) < 0 || --this.remaining >= 0L)) {
                return n2;
            }
            throw new StreamOverflowException("expanded byte limit exceeded");
        }

        public int read(byte[] byArray, int n2, int n3) throws IOException {
            if (n3 < 1) {
                return super.read(byArray, n2, n3);
            }
            if (this.remaining < 1L) {
                this.read();
                return -1;
            }
            int n4 = this.remaining > (long)n3 ? n3 : (int)this.remaining;
            int n5 = this.in.read(byArray, n2, n4);
            if (n5 > 0) {
                this.remaining -= (long)n5;
            }
            return n5;
        }
    }
}

