/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.general;

import com.aspose.html.utils.ms.core.bc.crypto.internal.params.AsymmetricKeyParameter;
import com.aspose.html.utils.ms.core.bc.util.Arrays;
import com.aspose.html.utils.ms.core.bc.util.io.Streams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

final class Ed25519PublicKeyParameters
extends AsymmetricKeyParameter {
    public static final int KEY_SIZE = 32;
    private final byte[] data = new byte[32];

    public Ed25519PublicKeyParameters(byte[] byArray, int n2) {
        super(false);
        System.arraycopy(byArray, n2, this.data, 0, 32);
    }

    public Ed25519PublicKeyParameters(InputStream inputStream) throws IOException {
        super(false);
        if (32 != Streams.readFully(inputStream, this.data)) {
            throw new EOFException("EOF encountered in middle of Ed25519 public key");
        }
    }

    public void encode(byte[] byArray, int n2) {
        System.arraycopy(this.data, 0, byArray, n2, 32);
    }

    public byte[] getEncoded() {
        return Arrays.clone(this.data);
    }
}

