/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.general;

import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsSHS;
import com.aspose.html.utils.ms.core.bc.crypto.general.Ed448PrivateKeyParameters;
import com.aspose.html.utils.ms.core.bc.crypto.general.Ed448PublicKeyParameters;
import com.aspose.html.utils.ms.core.bc.crypto.general.Register;
import com.aspose.html.utils.ms.core.bc.crypto.internal.CipherParameters;
import com.aspose.html.utils.ms.core.bc.crypto.internal.Signer;
import com.aspose.html.utils.ms.core.bc.crypto.internal.Xof;
import com.aspose.html.utils.ms.core.bc.math.ec.rfc8032.Ed448;
import com.aspose.html.utils.ms.core.bc.util.Arrays;
import java.io.ByteArrayOutputStream;

class Ed448Signer
implements Signer {
    private final Buffer buffer = new Buffer();
    private final byte[] context;
    private boolean forSigning;
    private Ed448PrivateKeyParameters privateKey;
    private Ed448PublicKeyParameters publicKey;

    public Ed448Signer(byte[] byArray) {
        this.context = Arrays.clone(byArray);
    }

    public void init(boolean bl2, CipherParameters cipherParameters) {
        this.forSigning = bl2;
        if (bl2) {
            this.privateKey = (Ed448PrivateKeyParameters)cipherParameters;
            this.publicKey = this.privateKey.generatePublicKey();
        } else {
            this.privateKey = null;
            this.publicKey = (Ed448PublicKeyParameters)cipherParameters;
        }
        this.reset();
    }

    public void update(byte by2) {
        this.buffer.write(by2);
    }

    public void update(byte[] byArray, int n2, int n3) {
        this.buffer.write(byArray, n2, n3);
    }

    public byte[] generateSignature() {
        if (!this.forSigning || null == this.privateKey) {
            throw new IllegalStateException("Ed448Signer not initialised for signature generation.");
        }
        return this.buffer.generateSignature(this.privateKey, this.publicKey, this.context);
    }

    public boolean verifySignature(byte[] byArray) {
        if (this.forSigning || null == this.publicKey) {
            throw new IllegalStateException("Ed448Signer not initialised for verification");
        }
        return this.buffer.verifySignature(this.publicKey, this.context, byArray);
    }

    public void reset() {
        this.buffer.reset();
    }

    static class Buffer
    extends ByteArrayOutputStream {
        private final Ed448 ed448 = new Ed448(){

            public Xof createXof() {
                return (Xof)Register.createDigest(FipsSHS.Algorithm.SHAKE256);
            }
        };

        private Buffer() {
        }

        synchronized byte[] generateSignature(Ed448PrivateKeyParameters ed448PrivateKeyParameters, Ed448PublicKeyParameters ed448PublicKeyParameters, byte[] byArray) {
            byte[] byArray2 = new byte[114];
            ed448PrivateKeyParameters.sign(0, ed448PublicKeyParameters, byArray, this.buf, 0, this.count, byArray2, 0);
            this.reset();
            return byArray2;
        }

        synchronized boolean verifySignature(Ed448PublicKeyParameters ed448PublicKeyParameters, byte[] byArray, byte[] byArray2) {
            byte[] byArray3 = ed448PublicKeyParameters.getEncoded();
            boolean bl2 = this.ed448.verify(byArray2, 0, byArray3, 0, byArray, this.buf, 0, this.count);
            this.reset();
            return bl2;
        }

        public synchronized void reset() {
            Arrays.fill(this.buf, 0, this.count, (byte)0);
            this.count = 0;
        }
    }
}

