/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.utils.ms.core.bc.crypto.general;

import com.aspose.html.utils.ms.core.bc.crypto.Algorithm;
import com.aspose.html.utils.ms.core.bc.crypto.AuthenticationParametersWithIV;
import com.aspose.html.utils.ms.core.bc.crypto.IllegalKeyException;
import com.aspose.html.utils.ms.core.bc.crypto.ParametersWithIV;
import com.aspose.html.utils.ms.core.bc.crypto.SymmetricKey;
import com.aspose.html.utils.ms.core.bc.crypto.SymmetricSecretKey;
import com.aspose.html.utils.ms.core.bc.crypto.fips.FipsTripleDES;
import com.aspose.html.utils.ms.core.bc.crypto.general.CipherUtils;
import com.aspose.html.utils.ms.core.bc.crypto.general.FipsRegister;
import com.aspose.html.utils.ms.core.bc.crypto.general.GeneralAlgorithm;
import com.aspose.html.utils.ms.core.bc.crypto.general.GeneralAuthParameters;
import com.aspose.html.utils.ms.core.bc.crypto.general.GeneralParameters;
import com.aspose.html.utils.ms.core.bc.crypto.general.GeneralParametersWithIV;
import com.aspose.html.utils.ms.core.bc.crypto.general.GuardedAEADOperatorFactory;
import com.aspose.html.utils.ms.core.bc.crypto.general.GuardedKeyWrapOperatorFactory;
import com.aspose.html.utils.ms.core.bc.crypto.general.GuardedMACOperatorFactory;
import com.aspose.html.utils.ms.core.bc.crypto.general.GuardedSymmetricKeyGenerator;
import com.aspose.html.utils.ms.core.bc.crypto.general.GuardedSymmetricOperatorFactory;
import com.aspose.html.utils.ms.core.bc.crypto.general.Mode;
import com.aspose.html.utils.ms.core.bc.crypto.general.Padding;
import com.aspose.html.utils.ms.core.bc.crypto.general.PrivilegedUtils;
import com.aspose.html.utils.ms.core.bc.crypto.general.Utils;
import com.aspose.html.utils.ms.core.bc.crypto.internal.BufferedBlockCipher;
import com.aspose.html.utils.ms.core.bc.crypto.internal.Mac;
import com.aspose.html.utils.ms.core.bc.crypto.internal.ValidatedSymmetricKey;
import com.aspose.html.utils.ms.core.bc.crypto.internal.Wrapper;
import com.aspose.html.utils.ms.core.bc.crypto.internal.modes.AEADBlockCipher;
import java.security.SecureRandom;

public final class TripleDES {
    public static final Algorithm ALGORITHM = FipsTripleDES.ALGORITHM;
    public static final AuthParameters CBC_MAC = new AuthParameters(new GeneralAlgorithm(FipsTripleDES.ALGORITHM.getName(), (Enum)Mode.CBCMAC));
    public static final AuthParameters CBC_MACwithISO7816_4 = new AuthParameters(new GeneralAlgorithm(FipsTripleDES.ALGORITHM.getName(), (Enum)Mode.CBCMAC, Padding.ISO7816_4));
    public static final AuthParameters CFB8_MAC = new AuthParameters(new GeneralAlgorithm(FipsTripleDES.ALGORITHM.getName(), (Enum)Mode.CFB8MAC));
    public static final Parameters OpenPGPCFB = new Parameters(new GeneralAlgorithm(FipsTripleDES.ALGORITHM.getName(), (Enum)Mode.OpenPGPCFB));
    public static final AuthParameters EAX = new AuthParameters(new GeneralAlgorithm(FipsTripleDES.ALGORITHM.getName(), (Enum)Mode.EAX));
    public static final Parameters RFC3217_WRAP = new Parameters(new GeneralAlgorithm(FipsTripleDES.ALGORITHM.getName(), (Enum)Mode.RFC3217_WRAP));
    public static final Parameters RFC3211_WRAP = new Parameters(new GeneralAlgorithm(FipsTripleDES.ALGORITHM.getName(), (Enum)Mode.RFC3211_WRAP));

    private TripleDES() {
    }

    private static void validateKeySize(int n2) {
        if (n2 != 112 && n2 != 168 && n2 != 128 && n2 != 192) {
            throw new IllegalKeyException("DESEDE key must be of length 128 or 192 bits");
        }
    }

    private static ValidatedSymmetricKey validateKey(SymmetricKey symmetricKey, Algorithm algorithm) {
        ValidatedSymmetricKey validatedSymmetricKey = PrivilegedUtils.getValidatedKey(symmetricKey);
        TripleDES.validateKeySize(validatedSymmetricKey.getKeySizeInBits());
        Utils.checkKeyAlgorithm(validatedSymmetricKey, FipsTripleDES.ALGORITHM, algorithm);
        return validatedSymmetricKey;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AEADOperatorFactory
    extends GuardedAEADOperatorFactory<AuthParameters> {
        @Override
        protected AEADBlockCipher createAEADCipher(boolean bl2, SymmetricKey symmetricKey, AuthParameters authParameters) {
            return CipherUtils.createStandardAEADCipher(bl2, TripleDES.validateKey(symmetricKey, authParameters.getAlgorithm()), FipsRegister.getProvider(FipsTripleDES.ALGORITHM), (AuthenticationParametersWithIV)authParameters);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AuthParameters
    extends GeneralAuthParameters<AuthParameters> {
        private AuthParameters(GeneralAlgorithm generalAlgorithm, byte[] byArray, int n2) {
            super(generalAlgorithm, 8, byArray, n2);
        }

        public AuthParameters(GeneralAlgorithm generalAlgorithm) {
            this(generalAlgorithm, null, Utils.getDefaultMacSize(generalAlgorithm, 64));
        }

        @Override
        protected AuthParameters create(GeneralAlgorithm generalAlgorithm, byte[] byArray, int n2) {
            return new AuthParameters(generalAlgorithm, byArray, n2);
        }
    }

    public static final class KeyGenerator
    extends GuardedSymmetricKeyGenerator {
        private final GeneralAlgorithm algorithm;
        private final FipsTripleDES.KeyGenerator keyGen;

        public KeyGenerator(GeneralParameters generalParameters, int n2, SecureRandom secureRandom) {
            this.algorithm = (GeneralAlgorithm)generalParameters.getAlgorithm();
            this.keyGen = new FipsTripleDES.KeyGenerator(n2, secureRandom);
        }

        public SymmetricKey doGenerateKey() {
            return new SymmetricSecretKey(this.algorithm, this.keyGen.generateKey().getKeyBytes());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyWrapOperatorFactory
    extends GuardedKeyWrapOperatorFactory<Parameters, SymmetricKey> {
        @Override
        protected Wrapper createWrapper(boolean bl2, SymmetricKey symmetricKey, Parameters parameters, SecureRandom secureRandom) {
            return CipherUtils.createStandardWrapper(bl2, TripleDES.validateKey(symmetricKey, parameters.getAlgorithm()), FipsRegister.getProvider(FipsTripleDES.ALGORITHM), parameters, secureRandom);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MACOperatorFactory
    extends GuardedMACOperatorFactory<AuthParameters> {
        @Override
        protected Mac createMAC(SymmetricKey symmetricKey, AuthParameters authParameters) {
            return CipherUtils.createStandardMac(TripleDES.validateKey(symmetricKey, authParameters.getAlgorithm()), FipsRegister.getProvider(FipsTripleDES.ALGORITHM), (GeneralAuthParameters)authParameters);
        }

        @Override
        protected int calculateMACSize(AuthParameters authParameters) {
            return Utils.bitsToBytes(authParameters.macLenInBits);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OperatorFactory
    extends GuardedSymmetricOperatorFactory<Parameters> {
        @Override
        protected BufferedBlockCipher createCipher(boolean bl2, SymmetricKey symmetricKey, Parameters parameters, SecureRandom secureRandom) {
            return CipherUtils.createStandardCipher(bl2, TripleDES.validateKey(symmetricKey, parameters.getAlgorithm()), FipsRegister.getProvider(FipsTripleDES.ALGORITHM), (ParametersWithIV)parameters, secureRandom);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Parameters
    extends GeneralParametersWithIV<Parameters> {
        private Parameters(GeneralAlgorithm generalAlgorithm, byte[] byArray) {
            super(generalAlgorithm, 8, generalAlgorithm.checkIv(byArray, 8));
        }

        public Parameters(GeneralAlgorithm generalAlgorithm) {
            this(generalAlgorithm, null);
        }

        @Override
        protected Parameters create(GeneralAlgorithm generalAlgorithm, byte[] byArray) {
            return new Parameters(generalAlgorithm, byArray);
        }
    }
}

