/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.util.Date;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.StreamUtil;
import org.bouncycastle.util.Strings;

public class DERGeneralizedTime
extends ASN1GeneralizedTime {
    public DERGeneralizedTime(byte[] byArray) {
        super(byArray);
    }

    public DERGeneralizedTime(Date date) {
        super(date);
    }

    public DERGeneralizedTime(String string) {
        super(string);
    }

    private byte[] getDERTime() {
        if (this.time[this.time.length - 1] == 90) {
            if (!this.hasMinutes()) {
                byte[] byArray = new byte[this.time.length + 4];
                System.arraycopy(this.time, 0, byArray, 0, this.time.length - 1);
                System.arraycopy(Strings.toByteArray("0000Z"), 0, byArray, this.time.length - 1, 5);
                return byArray;
            }
            if (!this.hasSeconds()) {
                byte[] byArray = new byte[this.time.length + 2];
                System.arraycopy(this.time, 0, byArray, 0, this.time.length - 1);
                System.arraycopy(Strings.toByteArray("00Z"), 0, byArray, this.time.length - 1, 3);
                return byArray;
            }
            if (this.hasFractionalSeconds()) {
                int n2;
                for (n2 = this.time.length - 2; n2 > 0 && this.time[n2] == 48; --n2) {
                }
                if (this.time[n2] == 46) {
                    byte[] byArray = new byte[n2 + 1];
                    System.arraycopy(this.time, 0, byArray, 0, n2);
                    byArray[n2] = 90;
                    return byArray;
                }
                byte[] byArray = new byte[n2 + 2];
                System.arraycopy(this.time, 0, byArray, 0, n2 + 1);
                byArray[n2 + 1] = 90;
                return byArray;
            }
            return this.time;
        }
        return this.time;
    }

    int encodedLength() {
        int n2 = this.getDERTime().length;
        return 1 + StreamUtil.calculateBodyLength(n2) + n2;
    }

    void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        aSN1OutputStream.writeEncoded(24, this.getDERTime());
    }
}

