/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.StreamUtil;

public class DERSet
extends ASN1Set {
    private int bodyLength = -1;

    public DERSet() {
    }

    public DERSet(ASN1Encodable aSN1Encodable) {
        super(aSN1Encodable);
    }

    public DERSet(ASN1EncodableVector aSN1EncodableVector) {
        super(aSN1EncodableVector, true);
    }

    public DERSet(ASN1Encodable[] aSN1EncodableArray) {
        super(aSN1EncodableArray, true);
    }

    DERSet(ASN1EncodableVector aSN1EncodableVector, boolean bl2) {
        super(aSN1EncodableVector, bl2);
    }

    private int getBodyLength() throws IOException {
        if (this.bodyLength < 0) {
            int n2 = 0;
            Enumeration enumeration = this.getObjects();
            while (enumeration.hasMoreElements()) {
                Object e2 = enumeration.nextElement();
                n2 += ((ASN1Encodable)e2).toASN1Primitive().toDERObject().encodedLength();
            }
            this.bodyLength = n2;
        }
        return this.bodyLength;
    }

    int encodedLength() throws IOException {
        int n2 = this.getBodyLength();
        return 1 + StreamUtil.calculateBodyLength(n2) + n2;
    }

    void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        ASN1OutputStream aSN1OutputStream2 = aSN1OutputStream.getDERSubStream();
        int n2 = this.getBodyLength();
        aSN1OutputStream.write(49);
        aSN1OutputStream.writeLength(n2);
        Enumeration enumeration = this.getObjects();
        while (enumeration.hasMoreElements()) {
            Object e2 = enumeration.nextElement();
            aSN1OutputStream2.writeObject((ASN1Encodable)e2);
        }
    }
}

