/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.fips.FipsOperationError;
import org.bouncycastle.crypto.internal.Permissions;
import org.bouncycastle.util.Arrays;

public final class SymmetricSecretKey
implements Destroyable,
SymmetricKey {
    private final boolean approvedModeOnly;
    private int hashCode;
    private Algorithm algorithm;
    private byte[] bytes;
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);

    public SymmetricSecretKey(Algorithm algorithm, byte[] byArray) {
        this.approvedModeOnly = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.algorithm = algorithm;
        this.hashCode = this.calculateHashCode();
        this.bytes = (byte[])byArray.clone();
    }

    public SymmetricSecretKey(Parameters parameters, byte[] byArray) {
        this.approvedModeOnly = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.algorithm = parameters.getAlgorithm();
        this.hashCode = this.calculateHashCode();
        this.bytes = (byte[])byArray.clone();
    }

    public Algorithm getAlgorithm() {
        this.checkDestroyed();
        return this.algorithm;
    }

    private void zeroize() {
        for (int i2 = 0; i2 != this.bytes.length; ++i2) {
            this.bytes[i2] = 0;
        }
        this.bytes = null;
        this.algorithm = null;
        this.hashCode = 0;
    }

    public byte[] getKeyBytes() {
        this.checkApprovedOnlyModeStatus();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(Permissions.CanOutputSecretKey);
        }
        byte[] byArray = Arrays.clone(this.bytes);
        this.checkDestroyed();
        return byArray;
    }

    public boolean equals(Object object) {
        this.checkApprovedOnlyModeStatus();
        if (this == object) {
            return true;
        }
        if (!(object instanceof SymmetricSecretKey)) {
            return false;
        }
        SymmetricSecretKey symmetricSecretKey = (SymmetricSecretKey)object;
        symmetricSecretKey.checkApprovedOnlyModeStatus();
        return this.algorithm != null && this.algorithm.equals(symmetricSecretKey.algorithm) && Arrays.constantTimeAreEqual(this.bytes, symmetricSecretKey.bytes);
    }

    public int hashCode() {
        this.checkApprovedOnlyModeStatus();
        return this.hashCode;
    }

    private int calculateHashCode() {
        this.checkApprovedOnlyModeStatus();
        int n2 = this.getAlgorithm().hashCode();
        n2 = 31 * n2 + Arrays.hashCode(this.bytes);
        return n2;
    }

    final void checkApprovedOnlyModeStatus() {
        if (this.approvedModeOnly != CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsOperationError("attempt to use key created in " + (this.approvedModeOnly ? "approved mode" : "unapproved mode") + " in alternate mode.");
        }
    }

    public void destroy() throws DestroyFailedException {
        if (this.hasBeenDestroyed.compareAndSet(false, true)) {
            this.zeroize();
        }
    }

    public boolean isDestroyed() {
        return this.hasBeenDestroyed.get();
    }

    private void checkDestroyed() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("key has been destroyed");
        }
    }
}

