/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.general.Mode;
import org.bouncycastle.crypto.general.Padding;

public class GeneralAlgorithm
implements Algorithm {
    private final Enum basicVariation;
    private final Enum additionalVariation;
    private final String name;

    GeneralAlgorithm(String string) {
        this(string, null, null);
    }

    GeneralAlgorithm(String string, Enum enum_) {
        this(string, enum_, null);
    }

    GeneralAlgorithm(GeneralAlgorithm generalAlgorithm, Enum enum_) {
        this(generalAlgorithm.getName(), enum_, null);
    }

    GeneralAlgorithm(GeneralAlgorithm generalAlgorithm, Enum enum_, Padding padding) {
        this(generalAlgorithm.getName(), enum_, padding);
    }

    GeneralAlgorithm(String string, Enum enum_, Padding padding) {
        this.basicVariation = enum_;
        this.additionalVariation = padding;
        this.name = enum_ instanceof Mode ? string + "/" + ((Mode)enum_).getBaseMode().getCode() + (padding != null ? "/" + padding.getBasePadding().getCode() : "") : string;
    }

    Enum basicVariation() {
        return this.basicVariation;
    }

    Enum additionalVariation() {
        return this.additionalVariation;
    }

    public String getName() {
        return this.name;
    }

    public final boolean requiresAlgorithmParameters() {
        return this.basicVariation instanceof Mode && ((Mode)this.basicVariation).getBaseMode().expectsIV() || this.name.equals("ChaCha20");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GeneralAlgorithm)) {
            return false;
        }
        GeneralAlgorithm generalAlgorithm = (GeneralAlgorithm)object;
        if (!this.isEqual(this.additionalVariation, generalAlgorithm.additionalVariation)) {
            return false;
        }
        if (!this.isEqual(this.basicVariation, generalAlgorithm.basicVariation)) {
            return false;
        }
        return this.name.equals(generalAlgorithm.name);
    }

    private boolean isEqual(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public int hashCode() {
        int n2 = this.name.hashCode();
        n2 = 31 * n2 + (this.basicVariation != null ? this.basicVariation.hashCode() : 0);
        n2 = 31 * n2 + (this.additionalVariation != null ? this.additionalVariation.hashCode() : 0);
        return n2;
    }

    byte[] checkIv(byte[] byArray, int n2) {
        return ((Mode)this.basicVariation()).checkIv(byArray, n2);
    }

    byte[] createDefaultIvIfNecessary(int n2, SecureRandom secureRandom) {
        return ((Mode)this.basicVariation()).createDefaultIvIfNecessary(n2, secureRandom);
    }

    byte[] createIvIfNecessary(int n2, SecureRandom secureRandom) {
        return ((Mode)this.basicVariation()).createIvIfNecessary(n2, secureRandom);
    }
}

