/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.modes.gcm;

import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.crypto.internal.modes.gcm.GCMExponentiator;
import org.bouncycastle.crypto.internal.modes.gcm.GCMUtil;
import org.bouncycastle.util.Arrays;

public class Tables1kGCMExponentiator
implements GCMExponentiator {
    private List lookupPowX2;

    public void init(byte[] byArray) {
        int[] nArray = GCMUtil.asInts(byArray);
        if (this.lookupPowX2 != null && Arrays.areEqual(nArray, (int[])this.lookupPowX2.get(0))) {
            return;
        }
        this.lookupPowX2 = new ArrayList(8);
        this.lookupPowX2.add(nArray);
    }

    public void exponentiateX(long l2, byte[] byArray) {
        int[] nArray = GCMUtil.oneAsInts();
        int n2 = 0;
        while (l2 > 0L) {
            if ((l2 & 1L) != 0L) {
                GCMUtil.multiply(nArray, this.getMultiplier(n2));
            }
            ++n2;
            l2 >>>= 1;
        }
        GCMUtil.asBytes(nArray, byArray);
    }

    private int[] getMultiplier(int n2) {
        this.ensureAvailable(n2);
        return (int[])this.lookupPowX2.get(n2);
    }

    private void ensureAvailable(int n2) {
        int n3 = this.lookupPowX2.size();
        if (n3 <= n2) {
            int[] nArray = (int[])this.lookupPowX2.get(n3 - 1);
            do {
                nArray = Arrays.clone(nArray);
                GCMUtil.multiply(nArray, nArray);
                this.lookupPowX2.add(nArray);
            } while (++n3 <= n2);
        }
    }
}

