/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.util;

import java.security.SecureRandom;
import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.EntropySourceProvider;
import org.bouncycastle.crypto.fips.FipsSecureRandom;
import org.bouncycastle.crypto.general.GeneralSecureRandom;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;

public class BasicEntropySourceProvider
implements EntropySourceProvider {
    private final SecureRandom _sr;
    private final boolean _predictionResistant;

    public BasicEntropySourceProvider(SecureRandom secureRandom, boolean bl2) {
        this._sr = secureRandom;
        this._predictionResistant = bl2;
    }

    public EntropySource get(final int n2) {
        return new EntropySource(){

            public boolean isPredictionResistant() {
                return BasicEntropySourceProvider.this._predictionResistant;
            }

            public byte[] getEntropy() {
                if (BasicEntropySourceProvider.this._sr instanceof FipsSecureRandom || BasicEntropySourceProvider.this._sr instanceof GeneralSecureRandom || BasicEntropySourceProvider.this._sr.getProvider() instanceof BouncyCastleFipsProvider) {
                    byte[] byArray = new byte[(n2 + 7) / 8];
                    BasicEntropySourceProvider.this._sr.nextBytes(byArray);
                    return byArray;
                }
                return BasicEntropySourceProvider.this._sr.generateSeed((n2 + 7) / 8);
            }

            public int entropySize() {
                return n2;
            }
        };
    }
}

