/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.internal;

import java.util.Random;
import org.bouncycastle.math.internal.Nat;

public abstract class Mod {
    public static int inverse32(int n2) {
        int n3 = n2;
        n3 *= 2 - n2 * n3;
        n3 *= 2 - n2 * n3;
        n3 *= 2 - n2 * n3;
        n3 *= 2 - n2 * n3;
        return n3;
    }

    public static void invert(int[] nArray, int[] nArray2, int[] nArray3) {
        int n2 = nArray.length;
        if (Nat.isZero(n2, nArray2)) {
            throw new IllegalArgumentException("'x' cannot be 0");
        }
        if (Nat.isOne(n2, nArray2)) {
            System.arraycopy(nArray2, 0, nArray3, 0, n2);
            return;
        }
        int[] nArray4 = Nat.copy(n2, nArray2);
        int[] nArray5 = Nat.create(n2);
        nArray5[0] = 1;
        int n3 = 0;
        if ((nArray4[0] & 1) == 0) {
            n3 = Mod.inversionStep(nArray, nArray4, n2, nArray5, n3);
        }
        if (Nat.isOne(n2, nArray4)) {
            Mod.inversionResult(nArray, n3, nArray5, nArray3);
            return;
        }
        int[] nArray6 = Nat.copy(n2, nArray);
        int[] nArray7 = Nat.create(n2);
        int n4 = 0;
        int n5 = n2;
        while (true) {
            if (nArray4[n5 - 1] == 0 && nArray6[n5 - 1] == 0) {
                --n5;
                continue;
            }
            if (Nat.gte(n5, nArray4, nArray6)) {
                Nat.subFrom(n5, nArray6, nArray4);
                n3 += Nat.subFrom(n2, nArray7, nArray5) - n4;
                n3 = Mod.inversionStep(nArray, nArray4, n5, nArray5, n3);
                if (!Nat.isOne(n5, nArray4)) continue;
                Mod.inversionResult(nArray, n3, nArray5, nArray3);
                return;
            }
            Nat.subFrom(n5, nArray4, nArray6);
            n4 += Nat.subFrom(n2, nArray5, nArray7) - n3;
            n4 = Mod.inversionStep(nArray, nArray6, n5, nArray7, n4);
            if (Nat.isOne(n5, nArray6)) break;
        }
        Mod.inversionResult(nArray, n4, nArray7, nArray3);
    }

    public static int[] random(int[] nArray) {
        int n2 = nArray.length;
        Random random = new Random();
        int[] nArray2 = Nat.create(n2);
        int n3 = nArray[n2 - 1];
        n3 |= n3 >>> 1;
        n3 |= n3 >>> 2;
        n3 |= n3 >>> 4;
        n3 |= n3 >>> 8;
        n3 |= n3 >>> 16;
        do {
            for (int i2 = 0; i2 != n2; ++i2) {
                nArray2[i2] = random.nextInt();
            }
            int n4 = n2 - 1;
            nArray2[n4] = nArray2[n4] & n3;
        } while (Nat.gte(n2, nArray2, nArray));
        return nArray2;
    }

    public static void add(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n2 = nArray.length;
        int n3 = Nat.add(n2, nArray2, nArray3, nArray4);
        if (n3 != 0) {
            Nat.subFrom(n2, nArray, nArray4);
        }
    }

    public static void subtract(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n2 = nArray.length;
        int n3 = Nat.sub(n2, nArray2, nArray3, nArray4);
        if (n3 != 0) {
            Nat.addTo(n2, nArray, nArray4);
        }
    }

    private static void inversionResult(int[] nArray, int n2, int[] nArray2, int[] nArray3) {
        if (n2 < 0) {
            Nat.add(nArray.length, nArray2, nArray, nArray3);
        } else {
            System.arraycopy(nArray2, 0, nArray3, 0, nArray.length);
        }
    }

    private static int inversionStep(int[] nArray, int[] nArray2, int n2, int[] nArray3, int n3) {
        int n4 = nArray.length;
        int n5 = 0;
        while (nArray2[0] == 0) {
            Nat.shiftDownWord(n2, nArray2, 0);
            n5 += 32;
        }
        int n6 = Mod.getTrailingZeroes(nArray2[0]);
        if (n6 > 0) {
            Nat.shiftDownBits(n2, nArray2, n6, 0);
            n5 += n6;
        }
        for (n6 = 0; n6 < n5; ++n6) {
            if ((nArray3[0] & 1) != 0) {
                n3 = n3 < 0 ? (n3 += Nat.addTo(n4, nArray, nArray3)) : (n3 += Nat.subFrom(n4, nArray, nArray3));
            }
            Nat.shiftDownBit(n4, nArray3, n3);
        }
        return n3;
    }

    private static int getTrailingZeroes(int n2) {
        int n3 = 0;
        while ((n2 & 1) == 0) {
            n2 >>>= 1;
            ++n3;
        }
        return n3;
    }
}

