/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging;

import com.aspose.imaging.Point;
import com.aspose.imaging.RectangleF;
import com.aspose.imaging.Size;
import com.aspose.imaging.internal.li.aV;
import com.aspose.imaging.internal.li.bC;
import com.aspose.imaging.internal.qm.d;
import com.aspose.imaging.internal.qm.i;
import com.aspose.imaging.system.SerializableAttribute;

@SerializableAttribute
public class Rectangle
extends i<Rectangle> {
    static final String RectangleFormat = "{{X={0}, Y={1}, Width={2}, Height={3}}}";
    private static final Rectangle a = new Rectangle();
    private int b;
    private int c;
    private int d;
    private int e;

    public Rectangle() {
    }

    public Rectangle(int n2, int n3, int n4, int n5) {
        this.d = n2;
        this.e = n3;
        this.c = n4;
        this.b = n5;
    }

    public Rectangle(Point point, Size size) {
        this.d = point.getX();
        this.e = point.getY();
        this.c = size.getWidth();
        this.b = size.getHeight();
    }

    public static Rectangle getEmpty() {
        return a.Clone();
    }

    public Point getLocation() {
        return new Point(this.d, this.e);
    }

    public void setLocation(Point point) {
        this.d = point.getX();
        this.e = point.getY();
    }

    public Size getSize() {
        return new Size(this.c, this.b);
    }

    public void setSize(Size size) {
        this.c = size.getWidth();
        this.b = size.getHeight();
    }

    public int getX() {
        return this.d;
    }

    public void setX(int n2) {
        this.d = n2;
    }

    public int getY() {
        return this.e;
    }

    public void setY(int n2) {
        this.e = n2;
    }

    public int getWidth() {
        return this.c;
    }

    public void setWidth(int n2) {
        this.c = n2;
    }

    public int getHeight() {
        return this.b;
    }

    public void setHeight(int n2) {
        this.b = n2;
    }

    public int getLeft() {
        return this.d;
    }

    public void setLeft(int n2) {
        int n3 = n2 - this.d;
        this.d = n2;
        this.c -= n3;
    }

    public int getTop() {
        return this.e;
    }

    public void setTop(int n2) {
        int n3 = n2 - this.e;
        this.e = n2;
        this.b -= n3;
    }

    public int getRight() {
        return this.d + this.c;
    }

    public void setRight(int n2) {
        int n3 = n2 - this.getRight();
        this.c += n3;
    }

    public int getBottom() {
        return this.e + this.b;
    }

    public void setBottom(int n2) {
        int n3 = n2 - this.getBottom();
        this.b += n3;
    }

    public boolean isEmpty() {
        return this.b == 0 && this.c == 0 && this.d == 0 && this.e == 0;
    }

    public boolean a() {
        return this.b > 0 && this.c > 0 && (this.d + this.c > 0 || this.e + this.b > 0);
    }

    public static Rectangle fromPoints(Point point, Point point2) {
        int n2 = bC.d(point.getX(), point2.getX());
        int n3 = bC.b(point.getX(), point2.getX());
        int n4 = bC.d(point.getY(), point2.getY());
        int n5 = bC.b(point.getY(), point2.getY());
        return Rectangle.fromLeftTopRightBottom(n2, n4, n3, n5);
    }

    public static Rectangle ceiling(RectangleF rectangleF) {
        return new Rectangle(com.aspose.imaging.internal.qm.d.e(bC.b((double)rectangleF.getX())), com.aspose.imaging.internal.qm.d.e(bC.b((double)rectangleF.getY())), com.aspose.imaging.internal.qm.d.e(bC.b((double)rectangleF.getWidth())), com.aspose.imaging.internal.qm.d.e(bC.b((double)rectangleF.getHeight())));
    }

    public static Rectangle truncate(RectangleF rectangleF) {
        return new Rectangle(com.aspose.imaging.internal.qm.d.e(rectangleF.getX()), com.aspose.imaging.internal.qm.d.e(rectangleF.getY()), com.aspose.imaging.internal.qm.d.e(rectangleF.getWidth()), com.aspose.imaging.internal.qm.d.e(rectangleF.getHeight()));
    }

    public static Rectangle round(RectangleF rectangleF) {
        return new Rectangle(com.aspose.imaging.internal.qm.d.e(bC.d(rectangleF.getX())), com.aspose.imaging.internal.qm.d.e(bC.d(rectangleF.getY())), com.aspose.imaging.internal.qm.d.e(bC.d(rectangleF.getWidth())), com.aspose.imaging.internal.qm.d.e(bC.d(rectangleF.getHeight())));
    }

    public static Rectangle inflate(Rectangle rectangle, int n2, int n3) {
        Rectangle rectangle2 = rectangle.Clone();
        rectangle2.inflate(n2, n3);
        return rectangle2;
    }

    public static Rectangle intersect(Rectangle rectangle, Rectangle rectangle2) {
        int n2 = bC.b(rectangle.d, rectangle2.d);
        int n3 = bC.d(rectangle.d + rectangle.c, rectangle2.d + rectangle2.c);
        int n4 = bC.b(rectangle.e, rectangle2.e);
        int n5 = bC.d(rectangle.e + rectangle.b, rectangle2.e + rectangle2.b);
        if (n3 >= n2 && n5 >= n4) {
            return new Rectangle(n2, n4, n3 - n2, n5 - n4);
        }
        return a.Clone();
    }

    public static Rectangle union(Rectangle rectangle, Rectangle rectangle2) {
        int n2 = bC.d(rectangle.d, rectangle2.d);
        int n3 = bC.b(rectangle.d + rectangle.c, rectangle2.d + rectangle2.c);
        int n4 = bC.d(rectangle.e, rectangle2.e);
        int n5 = bC.b(rectangle.e + rectangle.b, rectangle2.e + rectangle2.b);
        return new Rectangle(n2, n4, n3 - n2, n5 - n4);
    }

    public static boolean op_Equality(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle.d == rectangle2.d && rectangle.e == rectangle2.e && rectangle.c == rectangle2.c && rectangle.b == rectangle2.b;
    }

    public static boolean op_Inequality(Rectangle rectangle, Rectangle rectangle2) {
        return !Rectangle.op_Equality(rectangle, rectangle2);
    }

    public static Rectangle fromLeftTopRightBottom(int n2, int n3, int n4, int n5) {
        return new Rectangle(n2, n3, n4 - n2, n5 - n3);
    }

    public boolean contains(int n2, int n3) {
        return this.d <= n2 && n2 < this.d + this.c && this.e <= n3 && n3 < this.e + this.b;
    }

    public boolean contains(Point point) {
        return this.contains(point.getX(), point.getY());
    }

    public boolean contains(Rectangle rectangle) {
        return this.d <= rectangle.d && rectangle.d + rectangle.c <= this.d + this.c && this.e <= rectangle.e && rectangle.e + rectangle.b <= this.e + this.b;
    }

    public void inflate(int n2, int n3) {
        this.d -= n2;
        this.e -= n3;
        this.c += 2 * n2;
        this.b += 2 * n3;
    }

    public void inflate(Size size) {
        this.inflate(size.getWidth(), size.getHeight());
    }

    public void intersect(Rectangle rectangle) {
        Rectangle rectangle2 = Rectangle.intersect(rectangle, this);
        this.d = rectangle2.d;
        this.e = rectangle2.e;
        this.c = rectangle2.c;
        this.b = rectangle2.b;
    }

    public boolean intersectsWith(Rectangle rectangle) {
        return rectangle.d < this.d + this.c && this.d < rectangle.d + rectangle.c && rectangle.e < this.e + this.b && this.e < rectangle.e + rectangle.b;
    }

    public void offset(Point point) {
        this.offset(point.getX(), point.getY());
    }

    public void offset(int n2, int n3) {
        this.d += n2;
        this.e += n3;
    }

    public void normalize() {
        if (this.c < 0) {
            this.d += this.c;
            this.c = -this.c;
        }
        if (this.b < 0) {
            this.e += this.b;
            this.b = -this.b;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Rectangle)) {
            return false;
        }
        Rectangle rectangle = (Rectangle)object;
        return rectangle.d == this.d && rectangle.e == this.e && rectangle.c == this.c && rectangle.b == this.b;
    }

    public int hashCode() {
        return this.d ^ (this.e << 13 | this.e >> 19) ^ (this.c << 26 | this.c >> 6) ^ (this.b << 7 | this.b >> 25);
    }

    public String toString() {
        return aV.a(com.aspose.imaging.internal.lw.i.h(), RectangleFormat, this.d, this.e, this.c, this.b);
    }

    @Override
    public void CloneTo(Rectangle rectangle) {
        rectangle.b = this.b;
        rectangle.c = this.c;
        rectangle.d = this.d;
        rectangle.e = this.e;
    }

    @Override
    public Rectangle Clone() {
        Rectangle rectangle = new Rectangle();
        this.CloneTo(rectangle);
        return rectangle;
    }

    public static boolean isEquals(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == rectangle2) {
            return true;
        }
        if (rectangle == null) {
            return false;
        }
        return rectangle.equals(rectangle2);
    }
}

