/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.ico;

import com.aspose.imaging.IMultipageImageExt;
import com.aspose.imaging.Image;
import com.aspose.imaging.RasterCachedImage;
import com.aspose.imaging.RasterCachedMultipageImage;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.coreexceptions.OperationInterruptedException;
import com.aspose.imaging.fileformats.bmp.BmpImage;
import com.aspose.imaging.fileformats.ico.a;
import com.aspose.imaging.fileformats.ico.b;
import com.aspose.imaging.fileformats.ico.c;
import com.aspose.imaging.fileformats.ico.d;
import com.aspose.imaging.fileformats.png.PngImage;
import com.aspose.imaging.imageoptions.IcoOptions;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.iP.e;
import com.aspose.imaging.internal.li.g;
import com.aspose.imaging.multithreading.IInterruptMonitor;
import com.aspose.imaging.multithreading.InterruptMonitor;
import com.aspose.imaging.system.IDisposable;
import com.aspose.imaging.system.collections.Generic.Dictionary;
import com.aspose.imaging.system.collections.Generic.IGenericEnumerator;
import com.aspose.imaging.system.collections.Generic.List;
import com.aspose.imaging.system.io.MemoryStream;
import com.aspose.imaging.system.io.Stream;
import java.io.OutputStream;

public class IcoImage
extends RasterCachedMultipageImage
implements IMultipageImageExt {
    private final List<Image> i = new List();
    private com.aspose.imaging.internal.fn.b[] j;

    public IcoImage(int n2, int n3, IcoOptions icoOptions) {
        this();
        if (n2 <= 0 || n3 <= 0) {
            throw new ArgumentException("width and height must be > 0.");
        }
        if (icoOptions == null) {
            throw new ArgumentNullException("options");
        }
        RasterCachedImage rasterCachedImage = icoOptions.getFormat() == 2L ? new BmpImage(n2, n3, icoOptions.getBitsPerPixel() & 0xFFFF, icoOptions.getPalette()) : new PngImage(n2, n3, icoOptions.c());
        this.i.addItem(rasterCachedImage);
    }

    public IcoImage(Image image, IcoOptions icoOptions) {
        this();
        this.addPage(image, icoOptions);
    }

    IcoImage(com.aspose.imaging.internal.fn.b[] bArray) {
        this();
        this.j = bArray;
    }

    IcoImage(Image[] imageArray) {
        this();
        if (imageArray == null) {
            throw new ArgumentNullException("images");
        }
        this.i.addRange(com.aspose.imaging.internal.li.g.a(imageArray));
        IcoImage icoImage = this;
        this.i.forEach(new a(this, icoImage));
    }

    public static IcoImage a(Image[] imageArray) {
        return new IcoImage(imageArray);
    }

    public static IcoImage a(com.aspose.imaging.internal.fn.b[] bArray) {
        return new IcoImage(bArray);
    }

    private IcoImage() {
        super.a(new com.aspose.imaging.internal.fp.a(this));
    }

    @Override
    public long getFileFormat() {
        return 256L;
    }

    @Override
    public int getPageCount() {
        this.b(com.aspose.imaging.internal.iP.e.a());
        int n2 = this.i.size();
        if (n2 > 0) {
            return n2;
        }
        return this.s().length;
    }

    @Override
    public Image[] getPages() {
        this.b(com.aspose.imaging.internal.iP.e.a());
        return this.s();
    }

    @Override
    public Image n() {
        this.b(com.aspose.imaging.internal.iP.e.a());
        Image[] imageArray = this.getPages();
        return imageArray.length > 0 ? imageArray[0] : null;
    }

    @Override
    public boolean hasAlpha() {
        this.b(com.aspose.imaging.internal.iP.e.a());
        return com.aspose.imaging.internal.li.g.a(this.getPages(), new b(this));
    }

    public final com.aspose.imaging.internal.fn.b[] r() {
        return this.j;
    }

    @Override
    public boolean f() {
        return com.aspose.imaging.internal.li.g.a(this.getPages(), new c(this));
    }

    @Override
    public final void addPage(RasterImage rasterImage) {
        this.addPage(rasterImage, new IcoOptions());
    }

    public final void addPage(Image image) {
        this.addPage(image, new IcoOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPage(Image image, IcoOptions icoOptions) {
        super.verifyNotDisposed();
        if (image == null || icoOptions == null) {
            throw new ArgumentNullException(image == null ? "page" : "icoOptions");
        }
        Object object = this.c;
        synchronized (object) {
            this.s();
            Image image2 = com.aspose.imaging.internal.fo.c.b(image, icoOptions);
            image2.a(this);
            this.i.addItem(image2);
        }
        this.b(com.aspose.imaging.internal.iP.e.a());
    }

    public final void removePage(int n2) {
        super.verifyNotDisposed();
        if (n2 < 0 || n2 >= this.getPageCount()) {
            throw new ArgumentOutOfRangeException("index", "Page index is out of range. Note that ICO image must contain at least single entry.");
        }
        this.i.get_Item(n2).dispose();
        this.i.removeAt(n2);
        this.b(com.aspose.imaging.internal.iP.e.a());
    }

    @Override
    protected void saveData(Stream stream) {
        super.verifyNotDisposed();
        Dictionary<com.aspose.imaging.internal.fn.b, MemoryStream> dictionary = com.aspose.imaging.internal.fo.c.b(this);
        IcoImage.a(stream, dictionary);
    }

    @Override
    protected void updateDimensions(int n2, int n3) {
    }

    public static boolean b(StreamContainer streamContainer) {
        com.aspose.imaging.internal.fn.a a2 = com.aspose.imaging.internal.fn.a.a(streamContainer);
        com.aspose.imaging.internal.fn.b b2 = com.aspose.imaging.internal.fn.b.a(streamContainer);
        return com.aspose.imaging.internal.fn.a.a(a2) && (b2.e() & 0xFF) == 0;
    }

    protected static void write(OutputStream outputStream, Dictionary<com.aspose.imaging.internal.fn.b, MemoryStream> dictionary) {
        IcoImage.a(Stream.fromJava(outputStream), dictionary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void a(Stream stream, Dictionary<com.aspose.imaging.internal.fn.b, MemoryStream> dictionary) {
        IInterruptMonitor iInterruptMonitor = InterruptMonitor.getThreadLocalInstance();
        if (com.aspose.imaging.internal.qm.d.b((Object)iInterruptMonitor, IInterruptMonitor.class) && iInterruptMonitor.isInterrupted()) {
            throw new OperationInterruptedException("The operation has been interrupted.");
        }
        if (dictionary.size() == 0) {
            throw new ArgumentException("ICO image must contain at least a single image entry.", "entries");
        }
        stream.setPosition(0L);
        stream.write(new com.aspose.imaging.internal.fn.a(dictionary.size()).a(), 0, 6);
        com.aspose.imaging.internal.fo.c.a(dictionary);
        IGenericEnumerator iGenericEnumerator = ((Dictionary.KeyCollection)dictionary.getKeys()).iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                com.aspose.imaging.internal.fn.b b2 = (com.aspose.imaging.internal.fn.b)iGenericEnumerator.next();
                stream.write(b2.a(), 0, 16);
            }
        }
        finally {
            if (com.aspose.imaging.internal.qm.d.a(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        for (MemoryStream memoryStream : dictionary.getValues()) {
            try {
                memoryStream.writeTo(stream);
            }
            finally {
                if (memoryStream == null) continue;
                memoryStream.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image[] s() {
        Object object = this.c;
        synchronized (object) {
            List<Image> list = this.i;
            if (list.size() == 0 && this.r() != null) {
                list.addRange(com.aspose.imaging.internal.fo.c.a(this));
                IcoImage icoImage = this;
                list.forEach(new d(this, icoImage));
                this.j = null;
            }
            return list.toArray((Image[])new Image[0]);
        }
    }
}

