/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.tiff.tifftagtypes;

import com.aspose.imaging.fileformats.tiff.TiffDataType;
import com.aspose.imaging.fileformats.tiff.filemanagement.TiffStreamReader;
import com.aspose.imaging.fileformats.tiff.filemanagement.TiffStreamWriter;
import com.aspose.imaging.fileformats.tiff.tifftagtypes.TiffCommonArrayType;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.aI.n;
import com.aspose.imaging.internal.ad.b;
import com.aspose.imaging.internal.li.g;

public final class TiffFloatType
extends TiffCommonArrayType {
    private float[] a;

    public TiffFloatType(int n2) {
        super(n2);
    }

    public float[] getValues() {
        return this.a;
    }

    public void setValues(float[] fArray) {
        this.a = fArray;
    }

    @Override
    public byte getElementSize() {
        return 4;
    }

    @Override
    public g getValuesContainer() {
        return g.a((Object)this.a);
    }

    @Override
    public int getTagType() {
        return 11;
    }

    @Override
    public Object getValue() {
        return this.a;
    }

    @Override
    public void setValue(Object object) {
        if (object != null && !(object instanceof float[])) {
            throw new ArgumentException("Only float array is supported.");
        }
        this.a = (float[])object;
    }

    @Override
    public long writeAdditionalData(TiffStreamWriter tiffStreamWriter) {
        if (tiffStreamWriter == null) {
            throw new ArgumentNullException("dataStream");
        }
        byte by2 = new b(tiffStreamWriter).c();
        long l2 = super.getDataSize();
        float[] fArray = this.getValues();
        if (l2 > (long)(by2 & 0xFF)) {
            if (fArray == null || fArray.length < 1) {
                fArray = new float[]{0.0f};
            }
            tiffStreamWriter.writeFloatArray(fArray);
            return super.getDataSize();
        }
        return 0L;
    }

    @Override
    protected void readData(TiffStreamReader tiffStreamReader, long l2, long l3) {
        long l4 = TiffFloatType.a(l3, (long)this.getElementSize());
        if (l4 == (long)(new b(tiffStreamReader).c() & 0xFF)) {
            this.a = tiffStreamReader.readFloatArray(l2, l3);
        } else {
            long l5 = tiffStreamReader.a(l2);
            if (l5 + l4 <= tiffStreamReader.getLength()) {
                this.a = tiffStreamReader.readFloatArray(l5, l3);
            }
        }
    }

    @Override
    protected TiffDataType createInstance() {
        return new TiffFloatType(this.getTagId());
    }

    @Override
    protected void copyInstanceData(TiffDataType tiffDataType) {
        ((TiffFloatType)tiffDataType).a = n.a(this.a);
        super.copyInstanceData(tiffDataType);
    }

    @Override
    protected void writeTagValue(TiffStreamWriter tiffStreamWriter) {
        tiffStreamWriter.writeFloatArray(this.a);
        TiffFloatType.a(tiffStreamWriter, super.getDataSize());
    }
}

