/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.bc;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;

public class PbkdMacIntegrityCheck
extends ASN1Object {
    private final AlgorithmIdentifier a;
    private final KeyDerivationFunc b;
    private final ASN1OctetString c;

    public PbkdMacIntegrityCheck(AlgorithmIdentifier algorithmIdentifier, KeyDerivationFunc keyDerivationFunc, byte[] byArray) {
        this.a = algorithmIdentifier;
        this.b = keyDerivationFunc;
        this.c = new DEROctetString(Arrays.clone(byArray));
    }

    private PbkdMacIntegrityCheck(ASN1Sequence aSN1Sequence) {
        this.a = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
        this.b = KeyDerivationFunc.getInstance(aSN1Sequence.getObjectAt(1));
        this.c = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(2));
    }

    public static PbkdMacIntegrityCheck getInstance(Object object) {
        if (object instanceof PbkdMacIntegrityCheck) {
            return (PbkdMacIntegrityCheck)object;
        }
        if (object != null) {
            return new PbkdMacIntegrityCheck(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public AlgorithmIdentifier getMacAlgorithm() {
        return this.a;
    }

    public KeyDerivationFunc getPbkdAlgorithm() {
        return this.b;
    }

    public byte[] getMac() {
        return Arrays.clone(this.c.getOctets());
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        return new DERSequence(aSN1EncodableVector);
    }
}

