/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.cmc;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.cmc.BodyPartID;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;

public class DecryptedPOP
extends ASN1Object {
    private final BodyPartID a;
    private final AlgorithmIdentifier b;
    private final byte[] c;

    public DecryptedPOP(BodyPartID bodyPartID, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        this.a = bodyPartID;
        this.b = algorithmIdentifier;
        this.c = Arrays.clone(byArray);
    }

    private DecryptedPOP(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 3) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.a = BodyPartID.getInstance(aSN1Sequence.getObjectAt(0));
        this.b = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
        this.c = Arrays.clone(ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(2)).getOctets());
    }

    public static DecryptedPOP getInstance(Object object) {
        if (object instanceof DecryptedPOP) {
            return (DecryptedPOP)object;
        }
        if (object != null) {
            return new DecryptedPOP(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public BodyPartID getBodyPartID() {
        return this.a;
    }

    public AlgorithmIdentifier getThePOPAlgID() {
        return this.b;
    }

    public byte[] getThePOP() {
        return Arrays.clone(this.c);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(new DEROctetString(this.c));
        return new DERSequence(aSN1EncodableVector);
    }
}

