/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.cmc;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1GeneralizedTime;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DERUTF8String;
import com.aspose.imaging.internal.bouncycastle.asn1.x500.X500Name;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.CRLReason;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class RevokeRequest
extends ASN1Object {
    private final X500Name a;
    private final ASN1Integer b;
    private final CRLReason c;
    private ASN1GeneralizedTime d;
    private ASN1OctetString e;
    private DERUTF8String f;

    public RevokeRequest(X500Name x500Name, ASN1Integer aSN1Integer, CRLReason cRLReason, ASN1GeneralizedTime aSN1GeneralizedTime, ASN1OctetString aSN1OctetString, DERUTF8String dERUTF8String) {
        this.a = x500Name;
        this.b = aSN1Integer;
        this.c = cRLReason;
        this.d = aSN1GeneralizedTime;
        this.e = aSN1OctetString;
        this.f = dERUTF8String;
    }

    private RevokeRequest(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() < 3 || aSN1Sequence.size() > 6) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.a = X500Name.getInstance(aSN1Sequence.getObjectAt(0));
        this.b = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(1));
        this.c = CRLReason.getInstance(aSN1Sequence.getObjectAt(2));
        int n2 = 3;
        if (aSN1Sequence.size() > n2 && aSN1Sequence.getObjectAt(n2).toASN1Primitive() instanceof ASN1GeneralizedTime) {
            this.d = ASN1GeneralizedTime.getInstance(aSN1Sequence.getObjectAt(n2++));
        }
        if (aSN1Sequence.size() > n2 && aSN1Sequence.getObjectAt(n2).toASN1Primitive() instanceof ASN1OctetString) {
            this.e = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(n2++));
        }
        if (aSN1Sequence.size() > n2 && aSN1Sequence.getObjectAt(n2).toASN1Primitive() instanceof DERUTF8String) {
            this.f = DERUTF8String.getInstance(aSN1Sequence.getObjectAt(n2));
        }
    }

    public static RevokeRequest getInstance(Object object) {
        if (object instanceof RevokeRequest) {
            return (RevokeRequest)object;
        }
        if (object != null) {
            return new RevokeRequest(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public X500Name getName() {
        return this.a;
    }

    public BigInteger getSerialNumber() {
        return this.b.getValue();
    }

    public CRLReason getReason() {
        return this.c;
    }

    public ASN1GeneralizedTime getInvalidityDate() {
        return this.d;
    }

    public void setInvalidityDate(ASN1GeneralizedTime aSN1GeneralizedTime) {
        this.d = aSN1GeneralizedTime;
    }

    public ASN1OctetString getPassphrase() {
        return this.e;
    }

    public void setPassphrase(ASN1OctetString aSN1OctetString) {
        this.e = aSN1OctetString;
    }

    public DERUTF8String getComment() {
        return this.f;
    }

    public void setComment(DERUTF8String dERUTF8String) {
        this.f = dERUTF8String;
    }

    public byte[] getPassPhrase() {
        if (this.e != null) {
            return Arrays.clone(this.e.getOctets());
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        if (this.d != null) {
            aSN1EncodableVector.add(this.d);
        }
        if (this.e != null) {
            aSN1EncodableVector.add(this.e);
        }
        if (this.f != null) {
            aSN1EncodableVector.add(this.f);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

