/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.cmp;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.cmp.CertifiedKeyPair;
import com.aspose.imaging.internal.bouncycastle.asn1.cmp.PKIStatusInfo;

public class CertResponse
extends ASN1Object {
    private ASN1Integer a;
    private PKIStatusInfo b;
    private CertifiedKeyPair c;
    private ASN1OctetString d;

    private CertResponse(ASN1Sequence aSN1Sequence) {
        this.a = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0));
        this.b = PKIStatusInfo.getInstance(aSN1Sequence.getObjectAt(1));
        if (aSN1Sequence.size() >= 3) {
            if (aSN1Sequence.size() == 3) {
                ASN1Encodable aSN1Encodable = aSN1Sequence.getObjectAt(2);
                if (aSN1Encodable instanceof ASN1OctetString) {
                    this.d = ASN1OctetString.getInstance(aSN1Encodable);
                } else {
                    this.c = CertifiedKeyPair.getInstance(aSN1Encodable);
                }
            } else {
                this.c = CertifiedKeyPair.getInstance(aSN1Sequence.getObjectAt(2));
                this.d = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(3));
            }
        }
    }

    public static CertResponse getInstance(Object object) {
        if (object instanceof CertResponse) {
            return (CertResponse)object;
        }
        if (object != null) {
            return new CertResponse(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public CertResponse(ASN1Integer aSN1Integer, PKIStatusInfo pKIStatusInfo) {
        this(aSN1Integer, pKIStatusInfo, null, null);
    }

    public CertResponse(ASN1Integer aSN1Integer, PKIStatusInfo pKIStatusInfo, CertifiedKeyPair certifiedKeyPair, ASN1OctetString aSN1OctetString) {
        if (aSN1Integer == null) {
            throw new IllegalArgumentException("'certReqId' cannot be null");
        }
        if (pKIStatusInfo == null) {
            throw new IllegalArgumentException("'status' cannot be null");
        }
        this.a = aSN1Integer;
        this.b = pKIStatusInfo;
        this.c = certifiedKeyPair;
        this.d = aSN1OctetString;
    }

    public ASN1Integer getCertReqId() {
        return this.a;
    }

    public PKIStatusInfo getStatus() {
        return this.b;
    }

    public CertifiedKeyPair getCertifiedKeyPair() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        if (this.c != null) {
            aSN1EncodableVector.add(this.c);
        }
        if (this.d != null) {
            aSN1EncodableVector.add(this.d);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

