/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.cms;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Set;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.BERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.BERTaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.EncryptedContentInfo;

public class EncryptedData
extends ASN1Object {
    private ASN1Integer a;
    private EncryptedContentInfo b;
    private ASN1Set c;

    public static EncryptedData getInstance(Object object) {
        if (object instanceof EncryptedData) {
            return (EncryptedData)object;
        }
        if (object != null) {
            return new EncryptedData(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public EncryptedData(EncryptedContentInfo encryptedContentInfo) {
        this(encryptedContentInfo, null);
    }

    public EncryptedData(EncryptedContentInfo encryptedContentInfo, ASN1Set aSN1Set) {
        this.a = new ASN1Integer(aSN1Set == null ? 0L : 2L);
        this.b = encryptedContentInfo;
        this.c = aSN1Set;
    }

    private EncryptedData(ASN1Sequence aSN1Sequence) {
        this.a = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0));
        this.b = EncryptedContentInfo.getInstance(aSN1Sequence.getObjectAt(1));
        if (aSN1Sequence.size() == 3) {
            this.c = ASN1Set.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(2), false);
        }
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.b;
    }

    public ASN1Set getUnprotectedAttrs() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        if (this.c != null) {
            aSN1EncodableVector.add(new BERTaggedObject(false, 1, this.c));
        }
        return new BERSequence(aSN1EncodableVector);
    }
}

