/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.cms;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import java.math.BigInteger;

public class RsaKemParameters
extends ASN1Object {
    private final AlgorithmIdentifier a;
    private final BigInteger b;

    private RsaKemParameters(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 2) {
            throw new IllegalArgumentException("ASN.1 SEQUENCE should be of length 2");
        }
        this.a = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
        this.b = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(1)).getValue();
    }

    public static RsaKemParameters getInstance(Object object) {
        if (object instanceof RsaKemParameters) {
            return (RsaKemParameters)object;
        }
        if (object != null) {
            return new RsaKemParameters(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public RsaKemParameters(AlgorithmIdentifier algorithmIdentifier, int n2) {
        this.a = algorithmIdentifier;
        this.b = BigInteger.valueOf(n2);
    }

    public AlgorithmIdentifier getKeyDerivationFunction() {
        return this.a;
    }

    public BigInteger getKeyLength() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(new ASN1Integer(this.b));
        return new DERSequence(aSN1EncodableVector);
    }
}

