/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.crmf;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Choice;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.DERNull;
import com.aspose.imaging.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.crmf.POPOPrivKey;
import com.aspose.imaging.internal.bouncycastle.asn1.crmf.POPOSigningKey;

public class ProofOfPossession
extends ASN1Object
implements ASN1Choice {
    public static final int TYPE_RA_VERIFIED = 0;
    public static final int TYPE_SIGNING_KEY = 1;
    public static final int TYPE_KEY_ENCIPHERMENT = 2;
    public static final int TYPE_KEY_AGREEMENT = 3;
    private int a;
    private ASN1Encodable b;

    private ProofOfPossession(ASN1TaggedObject aSN1TaggedObject) {
        this.a = aSN1TaggedObject.getTagNo();
        switch (this.a) {
            case 0: {
                this.b = DERNull.INSTANCE;
                break;
            }
            case 1: {
                this.b = POPOSigningKey.getInstance(aSN1TaggedObject, false);
                break;
            }
            case 2: 
            case 3: {
                this.b = POPOPrivKey.getInstance(aSN1TaggedObject, true);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown tag: " + this.a);
            }
        }
    }

    public static ProofOfPossession getInstance(Object object) {
        if (object == null || object instanceof ProofOfPossession) {
            return (ProofOfPossession)object;
        }
        if (object instanceof ASN1TaggedObject) {
            return new ProofOfPossession((ASN1TaggedObject)object);
        }
        throw new IllegalArgumentException("Invalid object: " + object.getClass().getName());
    }

    public ProofOfPossession() {
        this.a = 0;
        this.b = DERNull.INSTANCE;
    }

    public ProofOfPossession(POPOSigningKey pOPOSigningKey) {
        this.a = 1;
        this.b = pOPOSigningKey;
    }

    public ProofOfPossession(int n2, POPOPrivKey pOPOPrivKey) {
        this.a = n2;
        this.b = pOPOPrivKey;
    }

    public int getType() {
        return this.a;
    }

    public ASN1Encodable getObject() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(false, this.a, this.b);
    }
}

