/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.dvcs;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Choice;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.dvcs.TargetEtcChain;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.DigestInfo;

public class Data
extends ASN1Object
implements ASN1Choice {
    private ASN1OctetString a;
    private DigestInfo b;
    private ASN1Sequence c;

    public Data(byte[] byArray) {
        this.a = new DEROctetString(byArray);
    }

    public Data(ASN1OctetString aSN1OctetString) {
        this.a = aSN1OctetString;
    }

    public Data(DigestInfo digestInfo) {
        this.b = digestInfo;
    }

    public Data(TargetEtcChain targetEtcChain) {
        this.c = new DERSequence(targetEtcChain);
    }

    public Data(TargetEtcChain[] targetEtcChainArray) {
        this.c = new DERSequence(targetEtcChainArray);
    }

    private Data(ASN1Sequence aSN1Sequence) {
        this.c = aSN1Sequence;
    }

    public static Data getInstance(Object object) {
        if (object instanceof Data) {
            return (Data)object;
        }
        if (object instanceof ASN1OctetString) {
            return new Data((ASN1OctetString)object);
        }
        if (object instanceof ASN1Sequence) {
            return new Data(DigestInfo.getInstance(object));
        }
        if (object instanceof ASN1TaggedObject) {
            return new Data(ASN1Sequence.getInstance((ASN1TaggedObject)object, false));
        }
        throw new IllegalArgumentException("Unknown object submitted to getInstance: " + object.getClass().getName());
    }

    public static Data getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return Data.getInstance(aSN1TaggedObject.getObject());
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.a != null) {
            return this.a.toASN1Primitive();
        }
        if (this.b != null) {
            return this.b.toASN1Primitive();
        }
        return new DERTaggedObject(false, 0, this.c);
    }

    public String toString() {
        if (this.a != null) {
            return "Data {\n" + this.a + "}\n";
        }
        if (this.b != null) {
            return "Data {\n" + this.b + "}\n";
        }
        return "Data {\n" + this.c + "}\n";
    }

    public ASN1OctetString getMessage() {
        return this.a;
    }

    public DigestInfo getMessageImprint() {
        return this.b;
    }

    public TargetEtcChain[] getCerts() {
        if (this.c == null) {
            return null;
        }
        TargetEtcChain[] targetEtcChainArray = new TargetEtcChain[this.c.size()];
        for (int i2 = 0; i2 != targetEtcChainArray.length; ++i2) {
            targetEtcChainArray[i2] = TargetEtcChain.getInstance(this.c.getObjectAt(i2));
        }
        return targetEtcChainArray;
    }
}

