/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.ess;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.IssuerSerial;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;

public class ESSCertIDv2
extends ASN1Object {
    private AlgorithmIdentifier a;
    private byte[] b;
    private IssuerSerial c;
    private static final AlgorithmIdentifier d = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256);

    public static ESSCertIDv2 getInstance(Object object) {
        if (object instanceof ESSCertIDv2) {
            return (ESSCertIDv2)object;
        }
        if (object != null) {
            return new ESSCertIDv2(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private ESSCertIDv2(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() > 3) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        int n2 = 0;
        this.a = aSN1Sequence.getObjectAt(0) instanceof ASN1OctetString ? d : AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(n2++).toASN1Primitive());
        this.b = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(n2++).toASN1Primitive()).getOctets();
        if (aSN1Sequence.size() > n2) {
            this.c = IssuerSerial.getInstance(aSN1Sequence.getObjectAt(n2));
        }
    }

    public ESSCertIDv2(byte[] byArray) {
        this(null, byArray, null);
    }

    public ESSCertIDv2(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        this(algorithmIdentifier, byArray, null);
    }

    public ESSCertIDv2(byte[] byArray, IssuerSerial issuerSerial) {
        this(null, byArray, issuerSerial);
    }

    public ESSCertIDv2(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, IssuerSerial issuerSerial) {
        this.a = algorithmIdentifier == null ? d : algorithmIdentifier;
        this.b = Arrays.clone(byArray);
        this.c = issuerSerial;
    }

    public AlgorithmIdentifier getHashAlgorithm() {
        return this.a;
    }

    public byte[] getCertHash() {
        return Arrays.clone(this.b);
    }

    public IssuerSerial getIssuerSerial() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (!this.a.equals(d)) {
            aSN1EncodableVector.add(this.a);
        }
        aSN1EncodableVector.add(new DEROctetString(this.b).toASN1Primitive());
        if (this.c != null) {
            aSN1EncodableVector.add(this.c);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

