/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.icao;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.icao.DataGroupHash;
import com.aspose.imaging.internal.bouncycastle.asn1.icao.ICAOObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.icao.LDSVersionInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import java.util.Enumeration;

public class LDSSecurityObject
extends ASN1Object
implements ICAOObjectIdentifiers {
    public static final int ub_DataGroups = 16;
    private ASN1Integer a = new ASN1Integer(0L);
    private AlgorithmIdentifier b;
    private DataGroupHash[] c;
    private LDSVersionInfo d;

    public static LDSSecurityObject getInstance(Object object) {
        if (object instanceof LDSSecurityObject) {
            return (LDSSecurityObject)object;
        }
        if (object != null) {
            return new LDSSecurityObject(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private LDSSecurityObject(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence == null || aSN1Sequence.size() == 0) {
            throw new IllegalArgumentException("null or empty sequence passed.");
        }
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.a = ASN1Integer.getInstance(enumeration.nextElement());
        this.b = AlgorithmIdentifier.getInstance(enumeration.nextElement());
        ASN1Sequence aSN1Sequence2 = ASN1Sequence.getInstance(enumeration.nextElement());
        if (this.a.getValue().intValue() == 1) {
            this.d = LDSVersionInfo.getInstance(enumeration.nextElement());
        }
        this.a(aSN1Sequence2.size());
        this.c = new DataGroupHash[aSN1Sequence2.size()];
        for (int i2 = 0; i2 < aSN1Sequence2.size(); ++i2) {
            this.c[i2] = DataGroupHash.getInstance(aSN1Sequence2.getObjectAt(i2));
        }
    }

    public LDSSecurityObject(AlgorithmIdentifier algorithmIdentifier, DataGroupHash[] dataGroupHashArray) {
        this.a = new ASN1Integer(0L);
        this.b = algorithmIdentifier;
        this.c = dataGroupHashArray;
        this.a(dataGroupHashArray.length);
    }

    public LDSSecurityObject(AlgorithmIdentifier algorithmIdentifier, DataGroupHash[] dataGroupHashArray, LDSVersionInfo lDSVersionInfo) {
        this.a = new ASN1Integer(1L);
        this.b = algorithmIdentifier;
        this.c = dataGroupHashArray;
        this.d = lDSVersionInfo;
        this.a(dataGroupHashArray.length);
    }

    private void a(int n2) {
        if (n2 < 2 || n2 > 16) {
            throw new IllegalArgumentException("wrong size in DataGroupHashValues : not in (2..16)");
        }
    }

    public int getVersion() {
        return this.a.getValue().intValue();
    }

    public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
        return this.b;
    }

    public DataGroupHash[] getDatagroupHash() {
        return this.c;
    }

    public LDSVersionInfo getVersionInfo() {
        return this.d;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            aSN1EncodableVector2.add(this.c[i2]);
        }
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        if (this.d != null) {
            aSN1EncodableVector.add(this.d);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

