/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.isismtt.x509;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.isismtt.x509.Admissions;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.GeneralName;
import java.util.Enumeration;

public class AdmissionSyntax
extends ASN1Object {
    private GeneralName a;
    private ASN1Sequence b;

    public static AdmissionSyntax getInstance(Object object) {
        if (object == null || object instanceof AdmissionSyntax) {
            return (AdmissionSyntax)object;
        }
        if (object instanceof ASN1Sequence) {
            return new AdmissionSyntax((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    private AdmissionSyntax(ASN1Sequence aSN1Sequence) {
        switch (aSN1Sequence.size()) {
            case 1: {
                this.b = DERSequence.getInstance(aSN1Sequence.getObjectAt(0));
                break;
            }
            case 2: {
                this.a = GeneralName.getInstance(aSN1Sequence.getObjectAt(0));
                this.b = DERSequence.getInstance(aSN1Sequence.getObjectAt(1));
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
            }
        }
    }

    public AdmissionSyntax(GeneralName generalName, ASN1Sequence aSN1Sequence) {
        this.a = generalName;
        this.b = aSN1Sequence;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.a != null) {
            aSN1EncodableVector.add(this.a);
        }
        aSN1EncodableVector.add(this.b);
        return new DERSequence(aSN1EncodableVector);
    }

    public GeneralName getAdmissionAuthority() {
        return this.a;
    }

    public Admissions[] getContentsOfAdmissions() {
        Admissions[] admissionsArray = new Admissions[this.b.size()];
        int n2 = 0;
        Enumeration enumeration = this.b.getObjects();
        while (enumeration.hasMoreElements()) {
            admissionsArray[n2++] = Admissions.getInstance(enumeration.nextElement());
        }
        return admissionsArray;
    }
}

