/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.ocsp;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1GeneralizedTime;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.DERIA5String;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DERTaggedObject;
import java.util.Enumeration;

public class CrlID
extends ASN1Object {
    private DERIA5String a;
    private ASN1Integer b;
    private ASN1GeneralizedTime c;

    private CrlID(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        block5: while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    this.a = DERIA5String.getInstance(aSN1TaggedObject, true);
                    continue block5;
                }
                case 1: {
                    this.b = ASN1Integer.getInstance(aSN1TaggedObject, true);
                    continue block5;
                }
                case 2: {
                    this.c = ASN1GeneralizedTime.getInstance(aSN1TaggedObject, true);
                    continue block5;
                }
            }
            throw new IllegalArgumentException("unknown tag number: " + aSN1TaggedObject.getTagNo());
        }
    }

    public static CrlID getInstance(Object object) {
        if (object instanceof CrlID) {
            return (CrlID)object;
        }
        if (object != null) {
            return new CrlID(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public DERIA5String getCrlUrl() {
        return this.a;
    }

    public ASN1Integer getCrlNum() {
        return this.b;
    }

    public ASN1GeneralizedTime getCrlTime() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.a != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, this.a));
        }
        if (this.b != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 1, this.b));
        }
        if (this.c != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 2, this.c));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

