/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.x500;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.x500.AttributeTypeAndValue;
import com.aspose.imaging.internal.bouncycastle.asn1.x500.RDN;
import com.aspose.imaging.internal.bouncycastle.asn1.x500.X500Name;
import com.aspose.imaging.internal.bouncycastle.asn1.x500.X500NameStyle;
import com.aspose.imaging.internal.bouncycastle.asn1.x500.style.BCStyle;
import java.util.Vector;

public class X500NameBuilder {
    private X500NameStyle a;
    private Vector b = new Vector();

    public X500NameBuilder() {
        this(BCStyle.INSTANCE);
    }

    public X500NameBuilder(X500NameStyle x500NameStyle) {
        this.a = x500NameStyle;
    }

    public X500NameBuilder addRDN(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        this.addRDN(aSN1ObjectIdentifier, this.a.stringToValue(aSN1ObjectIdentifier, string));
        return this;
    }

    public X500NameBuilder addRDN(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.b.addElement(new RDN(aSN1ObjectIdentifier, aSN1Encodable));
        return this;
    }

    public X500NameBuilder addRDN(AttributeTypeAndValue attributeTypeAndValue) {
        this.b.addElement(new RDN(attributeTypeAndValue));
        return this;
    }

    public X500NameBuilder addMultiValuedRDN(ASN1ObjectIdentifier[] aSN1ObjectIdentifierArray, String[] stringArray) {
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[stringArray.length];
        for (int i2 = 0; i2 != aSN1EncodableArray.length; ++i2) {
            aSN1EncodableArray[i2] = this.a.stringToValue(aSN1ObjectIdentifierArray[i2], stringArray[i2]);
        }
        return this.addMultiValuedRDN(aSN1ObjectIdentifierArray, aSN1EncodableArray);
    }

    public X500NameBuilder addMultiValuedRDN(ASN1ObjectIdentifier[] aSN1ObjectIdentifierArray, ASN1Encodable[] aSN1EncodableArray) {
        AttributeTypeAndValue[] attributeTypeAndValueArray = new AttributeTypeAndValue[aSN1ObjectIdentifierArray.length];
        for (int i2 = 0; i2 != aSN1ObjectIdentifierArray.length; ++i2) {
            attributeTypeAndValueArray[i2] = new AttributeTypeAndValue(aSN1ObjectIdentifierArray[i2], aSN1EncodableArray[i2]);
        }
        return this.addMultiValuedRDN(attributeTypeAndValueArray);
    }

    public X500NameBuilder addMultiValuedRDN(AttributeTypeAndValue[] attributeTypeAndValueArray) {
        this.b.addElement(new RDN(attributeTypeAndValueArray));
        return this;
    }

    public X500Name build() {
        RDN[] rDNArray = new RDN[this.b.size()];
        for (int i2 = 0; i2 != rDNArray.length; ++i2) {
            rDNArray[i2] = (RDN)this.b.elementAt(i2);
        }
        return new X500Name(this.a, rDNArray);
    }
}

